/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class AjaxSwingProperties
extends AppProperties {
    public HashMap<String, String> classPropertyCache = new HashMap();
    private static final String EMPTY = "empty";
    private static final String CLASS_PROPERTY_SEPARATOR = "#";
    private int sessionPingSeconds = -1;
    private boolean defaultTablePagination;
    public static boolean humanComponentNames = false;
    public static final String AJAXSWING_HOME = "ajaxswing.home";
    public static final String COMMON_CLASSPATH = "common.classPath";
    public static final String AGENT_START_CLASS_NAME = "agent.appStartClass";
    public static final String AGENT_APP_PARAMS = "agent.appParams";
    public static final String AGENT_ALLOW_LF_CHANGE = "agent.allowLFChange";
    public static final String AGENT_CLASSPATH = "agent.classPath";
    public static final String AGENT_REQUEST_TIMEOUT = "agent.requestTimeout";
    public static final String AGENT_USE_AJAXSWING_FONTS_CONFIG_FILE = "agent.useAjaxSwingFontsConfigFile";
    public static final String AGENT_RUN_AS_APPLET = "agent.runAsApplet";
    public static final String AGENT_PRODUCTION_MODE = "agent.productionMode";
    public static final String AGENT_ALLOW_TEXT_SELECTION = "agent.allowTextSelection";
    public static final String AGENT_DEFAULT_LOCALE = "agent.defaultLocale";
    public static final String AGENT_FORCE_JVM_LOCALE = "agent.forceJvmLocale";
    public static final String AGENT_USE_BROWSER_LOCALE = "agent.useBrowserLocale";
    public static final String AGENT_SCROLL_DYNAMIC_EVENTS = "agent.scrollDynamicEvents";
    public static final String AGENT_EMULATE_KEY_TYPE_EVENTS = "agent.emulateKeyType";
    public static final String AGENT_UNDECORATE_FIRST_FRAME = "agent.undecorateFirstFrame";
    public static final String BROWSER_ENABLE_AUTO_COMPLETE = "browser.enableAutoComplete";
    public static final String APPLET_TITLE = "applet.title";
    public static final String APPLET_DOCUMENT_BASE = "applet.documentBase";
    public static final String APPLET_CODE_BASE = "applet.codeBase";
    public static final String APPLET_WIDTH = "applet.width";
    public static final String APPLET_HEIGHT = "applet.height";
    public static final String APPLET_PARAM = "applet.param.";
    public static final String ROUTER_IN_PROCESS = "router.inProcess";
    public static final String ROUTER_PRELOAD_APP = "router.preloadApp";
    public static final String ROUTER_PRELOAD_WAIT_FOR_APP = "router.preloadWaitForApp";
    public static final String ROUTER_AGENT_WAIT_TIMEOUT = "router.agentWaitTimeout";
    public static final String ROUTER_SESSION_TIMEOUT = "router.sessionTimeout";
    public static final String ROUTER_AUTO_SUBMIT = "router.autoSubmit";
    public static final String ROUTER_REGISTRY_PORT = "router.registryPort";
    public static final String ROUTER_REGISTRY_PORT_RANGE = "router.registryPortRange";
    public static final String ROUTER_CHARACTER_ENCODING = "router.characterEncoding";
    public static final String ROUTER_CLIENTS_PER_JVM = "router.clientsPerJVM";
    public static final String ROUTER_RETIRE_JVM_AFTER_CLIENTS = "router.retireJVMAfterClients";
    public static final String ROUTER_HTTP_REQUEST_DATA_LEVEL = "router.httpRequestDataLevel";
    public static final String HTML_SUBMIT_URL = "html.submitURL";
    public static final String HTML_DOCS_URL = "html.docsURL";
    public static final String HTML_DOCS_REAL_PATH = "html.docsRealPath";
    public static final String HTML_THEME = "html.theme";
    public static final String HTML_EXIT_PAGE_URL = "html.exitPageURL";
    public static final String HTML_ERROR_PAGE_URL = "html.errorPageURL";
    public static final String HTML_INITIALIZATION_PAGE_URL = "html.initializationPageURL";
    public static final String HTML_HUMAN_COMPONENT_NAMES = "html.humanComponentNames";
    public static final String HTTP_URL_LOCALE = "http.url.locale";
    public static final String COMPONENT_UNDECORATE_WINDOW = "undecorateWindow";
    public static final String COMPONENT_BROWSE_CLIENT = "browseClient";
    public static final String COMPONENT_OPEN_CLIENT = "openOnClient";
    public static final String COMPONENT_SAVE_CLIENT = "saveOnClient";
    public static final String COMPONENT_CSS_STYLE = "cssStyle";
    public static final String COMPONENT_CSS_CLASS = "cssClass";
    public static final String COMPONENT_CUSTOM_ID = "ajsId";
    public static final String COMPONENT_TABLE_OBJECT = "tableObject";
    public static final String COMPONENT_ALWAYS_DIRTY = "alwaysDirty";
    public static final String COMPONENT_EMULATE_KEY_TYPE_EVENTS = "emulateKeyType";
    public static final String COMPONENT_PREVENT_SET_TEXT_FOR_TYPE = "preventSetTextForType";
    public static final String COMPONENT_RICH_TEXT_EDITOR = "richTextEditor";
    public static final String COMPONENT_PARENT_ID = "componentParentId";
    public static final String COMPONENT_EMULATE_KEY_TYPE_EVENTS_LIMITED = "emulateKeyTypeLimited";
    public static final String AGENT_MONITOR_ASYNCHRONOUS_UPDATES_DURATION = "agent.monitorAsynchronousUpdates.duration";
    public static final String AGENT_MONITOR_ASYNCHRONOUS_UPDATES_INTERVAL = "agent.monitorAsynchronousUpdates.interval";
    public static final String AGENT_MONITOR_ASYNCHRONOUS_UPDATES_UPDATE_ON_REPAINT = "agent.monitorAsynchronousUpdates.updateOnRepaint";
    public static final String AGENT_SCROLLING_IGNORE_OVERSIZED_ELEMENTS = "agent.scrolling.ignoreOversizedElements";
    public static final String PARENT_PROPERTIES_FILE = "parent";
    public static final String REQUEST_DATA_NONE = "none";
    public static final String REQUEST_DATA_INFO = "info";
    public static final String REQUEST_DATA_DEBUG = "debug";
    public static final String NULL_VALUE = "NULL";
    public static final String ENABLE_AUTO_COMPLETE = "enableAutoComplete";

    public AjaxSwingProperties() {
        this.init(null);
    }

    public AjaxSwingProperties(Properties defaults) throws Exception {
        super(defaults);
        this.init(null);
    }

    AjaxSwingProperties(String fileName) throws Exception {
        super(fileName);
        this.init(fileName);
    }

    public void init(String appName) {
        if ("default".equalsIgnoreCase(appName)) {
            TraceMgr.trace(this, "Reading global properties from default.properties");
            humanComponentNames = this.getBooleanProperty(HTML_HUMAN_COMPONENT_NAMES, false);
            TraceMgr.trace((Object)this, "humanComponentNames = " + humanComponentNames, 6);
        }
    }

    public String getParentName() {
        return this.getProperty(PARENT_PROPERTIES_FILE);
    }

    public boolean isDefaultTablePagination() {
        return this.defaultTablePagination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComponentProperty(Object component, String property) {
        String value = AjaxSwingProperties.getClientProperty(component, property);
        boolean iteratedInterfaces = false;
        int iteratedInterfaceNum = 0;
        Class<?> originalClass = component.getClass();
        String classPropertyValue = null;
        String classPropertyName = null;
        if (value == null) {
            classPropertyName = originalClass + CLASS_PROPERTY_SEPARATOR + property;
            value = classPropertyValue = this.classPropertyCache.get(classPropertyName);
        }
        if (value == null) {
            StringBuilder buffer = new StringBuilder(100);
            Class<?> cls = component.getClass();
            while (cls != null) {
                String className = cls.getName();
                buffer.append("component.");
                buffer.append(className);
                if (!property.startsWith(".")) {
                    buffer.append(".");
                }
                buffer.append(property);
                value = this.getProperty(buffer.toString());
                if (value != null) break;
                if (!iteratedInterfaces) {
                    if (originalClass.getInterfaces().length > iteratedInterfaceNum) {
                        cls = originalClass.getInterfaces()[iteratedInterfaceNum];
                        ++iteratedInterfaceNum;
                    } else {
                        iteratedInterfaces = true;
                        cls = originalClass.getSuperclass();
                    }
                } else {
                    cls = cls.getSuperclass();
                }
                buffer.setLength(0);
            }
            if (value == null) {
                buffer.setLength(0);
                buffer.append("component.*");
                if (!property.startsWith(".")) {
                    buffer.append(".");
                }
                buffer.append(property);
                value = this.getProperty(buffer.toString());
            }
            if (classPropertyValue == null) {
                HashMap<String, String> hashMap = this.classPropertyCache;
                synchronized (hashMap) {
                    this.classPropertyCache.put(classPropertyName, value == null ? EMPTY : value);
                }
            }
            if (value != null && component instanceof Component) {
                AjaxSwingProperties.setClientProperty((Component)component, property, value);
            }
        }
        return value == EMPTY ? null : value;
    }

    public int getComponentProperty(Object component, String key, int defaultValue) {
        String value = this.getComponentProperty(component, key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public boolean getComponentProperty(Object component, String key, boolean defaultValue) {
        String value = this.getComponentProperty(component, key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static JComponent getJComponent(Object component) {
        JComponent jComp = null;
        if (component instanceof JComponent) {
            jComp = (JComponent)component;
        } else if (component instanceof JDialog) {
            jComp = ((JDialog)component).getRootPane();
        } else if (component instanceof JFrame) {
            jComp = ((JFrame)component).getRootPane();
        }
        return jComp;
    }

    public static String getClientProperty(Object component, String property, String defaultValue) {
        String value = AjaxSwingProperties.getClientProperty(component, property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String getClientProperty(Object component, String property) {
        String value = null;
        JComponent jComp = AjaxSwingProperties.getJComponent(component);
        if (jComp != null) {
            Object clientValue = jComp.getClientProperty(property);
            if (clientValue == null) {
                clientValue = jComp.getClientProperty("ajaxswing." + property);
            }
            if (clientValue != null) {
                value = NULL_VALUE.equals(clientValue) ? null : clientValue.toString();
            }
        }
        return value;
    }

    public static void setClientProperty(Component component, String property, Object value) {
        JComponent jComp = AjaxSwingProperties.getJComponent(component);
        if (jComp != null) {
            if (value == null) {
                jComp.putClientProperty("ajaxswing." + property, NULL_VALUE);
            } else {
                jComp.putClientProperty("ajaxswing." + property, value);
            }
        }
    }

    public int getSessionPingSeconds() {
        if (this.sessionPingSeconds == -1) {
            boolean keepAlive = this.getBooleanProperty("window.*.session.keepAlive", false);
            boolean notify = this.getBooleanProperty("window.*.session.notifyBeforeExpiration", false);
            if (keepAlive || notify) {
                int keepAliveInterval;
                this.sessionPingSeconds = this.getIntProperty(ROUTER_SESSION_TIMEOUT, 300);
                int notificationLeadTime = 30;
                if (this.sessionPingSeconds - notificationLeadTime > 0) {
                    this.sessionPingSeconds -= notificationLeadTime;
                }
                if ((keepAliveInterval = this.getIntProperty("window.*.session.keepAliveInterval", -1)) != -1) {
                    this.sessionPingSeconds = keepAliveInterval;
                }
            } else {
                this.sessionPingSeconds = 0;
            }
            if (TraceMgr.getCutoffLevel() >= 6) {
                TraceMgr.trace(this, "sessionPingSeconds = " + this.sessionPingSeconds);
            }
        }
        return this.sessionPingSeconds;
    }
}

