/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.gui.AjaxSwingHeadlessToolkit15;
import com.creamtec.ajaxswing.gui.AjaxSwingToolkit15;
import com.creamtec.ajaxswing.gui.SupportedJavaVersion;
import com.creamtec.core.TraceMgr;
import java.awt.AWTHelper14;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionHelper {
    public static Class fontPropertiesClass;
    public static String CURRENT_JDK_VERSION;
    public static String SUPPORTED_JDK_VERSION;
    public static String JDK_17;
    public static String JDK_18;
    public static String TOOLKIT_CLASS_NAME;
    private static boolean initialized;
    public static final int AJAXSWING_VERSION_ID = 45;

    public static String getToolkitClassName() {
        VersionHelper.init(true);
        return TOOLKIT_CLASS_NAME;
    }

    public static void init(boolean initGUI) {
        if (initialized) {
            return;
        }
        if (initGUI) {
            TOOLKIT_CLASS_NAME = AjaxSwingToolkit15.getClassName();
            if (GraphicsEnvironment.isHeadless()) {
                TOOLKIT_CLASS_NAME = AjaxSwingHeadlessToolkit15.getClassName();
            }
            new AWTHelper14();
        }
        SUPPORTED_JDK_VERSION = SupportedJavaVersion.VERSION;
        VersionHelper.checkJdkVersion();
        initialized = true;
    }

    public static void checkJdkVersion() {
        CURRENT_JDK_VERSION = VersionHelper.getCurrentJdkVersion();
        if (!CURRENT_JDK_VERSION.startsWith(SUPPORTED_JDK_VERSION)) {
            throw new RuntimeException("AjaxSwing initialization error.<br> This version of AjaxSwing libraries is built for JDK " + SUPPORTED_JDK_VERSION + " while you are running JVM " + CURRENT_JDK_VERSION + ". <br><br>If this version of JDK is supported you need to run the appropriate enableJdkXX <br>" + " script from AjaxSwing's bin/setup directory.<br>" + " If this version of JDK is not supported by AjaxSwing, you will have to install a version <br>" + " that is supported and set JAVA_HOME environment variables to point to the correct JDK");
        }
    }

    public static String getCurrentJdkVersion() {
        int versionNumberStart;
        String javaVersion = System.getProperty("java.version");
        for (versionNumberStart = 0; versionNumberStart < javaVersion.length() && !Character.isDigit(javaVersion.charAt(versionNumberStart)); ++versionNumberStart) {
        }
        if (versionNumberStart == javaVersion.length()) {
            TraceMgr.trace("WARNING: failed to parse java version string for version number", 1);
        }
        javaVersion = javaVersion.substring(versionNumberStart);
        return javaVersion;
    }

    public static String getAjaxSwingVersion() {
        try {
            Class<VersionHelper> clazz = VersionHelper.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("AjaxSwing-Version").trim();
            return value;
        }
        catch (Exception ex) {
            TraceMgr.trace("WARN: Failed to read AjaxSwing version", ex);
            return "";
        }
    }

    static {
        JDK_17 = "1.7";
        JDK_18 = "1.8";
        initialized = false;
    }
}

