/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.gui.VersionHelper;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Encoder;

public class LicenseHelper {
    private static final String LICENSE_MANAGER_PATH = "https://us.creamtec.com/licenseManager/LicenseManager/";
    private static final String USAGE_CRED = new BASE64Encoder().encode("usage:test_usage".getBytes());
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static final HostnameVerifier allHostsTrustVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };

    public static void submitUsage(final AppProperties props) {
        if (AjaxSwingSecurityManager.EDITION_TYPE != AjaxSwingSecurityManager.EDITION_STD && !AjaxSwingSecurityManager.MONITOR) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LicenseHelper.urlOpener(LicenseHelper.createUsageSubmitURL(props));
                }
                catch (Exception e) {
                    TraceMgr.trace(LicenseHelper.class, "Submit usage failed." + e.getMessage(), TraceMgr.DEFAULT_WARNING_LEVEL);
                }
            }
        }).start();
    }

    private static URL createUsageSubmitURL(AppProperties props) throws MalformedURLException {
        StringBuilder postUsage = new StringBuilder();
        for (UserData field : UserData.values()) {
            try {
                String data = LicenseHelper.collectUserData(field, props).toString();
                if (data == null || data.isEmpty()) continue;
                postUsage.append("&usage.").append(URLEncoder.encode(field.getName(), "UTF-8")).append("=");
                postUsage.append(URLEncoder.encode(data, "UTF-8"));
            }
            catch (Exception e) {
                TraceMgr.trace(LicenseHelper.class, "Problem receiving " + field.getName(), TraceMgr.DEFAULT_WARNING_LEVEL);
            }
        }
        return new URL("https://us.creamtec.com/licenseManager/LicenseManager/postUsage?" + postUsage.substring(1, postUsage.length()));
    }

    private static void urlOpener(URL url) throws IOException {
        TraceMgr.trace(LicenseHelper.class, url.toString(), 6);
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsTrustVerifier);
        }
        catch (Exception sc) {
            // empty catch block
        }
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Basic " + USAGE_CRED);
        conn.setRequestMethod("GET");
        conn.connect();
        String text = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
        conn.disconnect();
    }

    private static Object collectUserData(UserData field, AppProperties props) throws UnknownHostException, SocketException {
        switch (field) {
            case IP: {
                return InetAddress.getLocalHost().getHostAddress();
            }
            case MAC: {
                return LicenseHelper.getMac();
            }
            case HOSTNAME: {
                return InetAddress.getLocalHost().getHostName();
            }
            case DOMAIN: {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            case CPU: {
                return System.getenv("PROCESSOR_IDENTIFIER");
            }
            case CPUCORECOUNT: {
                return Runtime.getRuntime().availableProcessors();
            }
            case PRODUCTVERSION: {
                String ver = VersionHelper.getAjaxSwingVersion();
                return ver.length() > 0 ? ver : Integer.valueOf(45);
            }
            case JDKVERSION: {
                return System.getProperty("java.version");
            }
            case OS: {
                return System.getProperty("os.name") + " v." + System.getProperty("os.version") + " " + System.getProperty("os.arch");
            }
            case COMPANY: {
                return props.getProperty("licensee", "unknown");
            }
            case LICENSEID: {
                return props.getProperty("licID", props.getProperty("lic", "42"));
            }
            case CUSTOM: {
                return "";
            }
        }
        return "";
    }

    private static String getMac() throws SocketException, UnknownHostException {
        NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    public static enum UserData {
        IP("ip"),
        MAC("mac"),
        HOSTNAME("hostname"),
        DOMAIN("domain"),
        CPU("cpu"),
        CPUCORECOUNT("cpuCoreCount"),
        COMPANY("company"),
        LICENSEID("licenseId"),
        PRODUCTVERSION("productVersion"),
        JDKVERSION("jdkVersion"),
        OS("os"),
        CUSTOM("custom");

        private String name;

        private UserData(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

