/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.AjaxSwingComponentHint;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.core.TraceMgr;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AjaxSwingAppletFrame
extends Frame {
    public AjaxSwingAppletFrame(ClientAgent agent, Applet applet) throws Exception {
        this.setTitle(agent.getProps().getProperty("applet.title"));
        Dimension size = applet.getPreferredSize();
        if (size.getWidth() == 0.0 || size.getHeight() == 0.0) {
            size.setSize(300, 200);
        }
        size.width = agent.getProps().getIntProperty("applet.width", size.width);
        size.height = agent.getProps().getIntProperty("applet.height", size.height);
        this.setSize(size);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TraceMgr.trace(this, "Exiting applet");
                System.exit(0);
            }
        });
        this.add((Component)applet, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (!this.isOpaque()) {
            Graphics gg = g.create();
            try {
                if (gg instanceof Graphics2D) {
                    Color bgColor = this.getBackground();
                    gg.setColor(bgColor);
                    ((Graphics2D)gg).setComposite(AlphaComposite.getInstance(2));
                    gg.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
            finally {
                gg.dispose();
            }
        }
        if (this.isShowing()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                Graphics g2 = g.create();
                if (g2 == null) continue;
                Rectangle bounds = comp.getBounds();
                g2.translate(bounds.x, bounds.y);
                g2.setClip(0, 0, bounds.width, bounds.height);
                if (g2 instanceof Graphics2D) {
                    ((Graphics2D)g2).setRenderingHint(AjaxSwingComponentHint.getInstance(), comp);
                }
                try {
                    comp.paint(g2);
                    continue;
                }
                finally {
                    if (g2 instanceof Graphics2D) {
                        ((Graphics2D)g2).setRenderingHint(AjaxSwingComponentHint.getInstance(), null);
                    }
                    g2.dispose();
                }
            }
        }
    }
}

