/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.gui.AjaxSwingFontConfiguration;
import com.creamtec.ajaxswing.gui.AjaxSwingGraphicsDevice;
import com.creamtec.core.TraceMgr;
import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.lang.reflect.Constructor;
import sun.awt.FontConfiguration;
import sun.awt.X11GraphicsEnvironment;
import sun.font.FontManagerFactory;
import sun.font.SunFontManager;
import sun.java2d.SunGraphicsEnvironment;

public class AjaxSwingGraphicsEnvironment
extends X11GraphicsEnvironment {
    public AjaxSwingGraphicsEnvironment() {
        TraceMgr.trace(this, "constructor");
    }

    @Override
    protected int getNumScreens() {
        TraceMgr.trace(this, "getNumScreens");
        return 1;
    }

    @Override
    protected GraphicsDevice makeScreenDevice(int i) {
        TraceMgr.trace(this, "makeScreenDevice, i = " + i);
        return new AjaxSwingGraphicsDevice();
    }

    public PrinterJob getPrinterJob() {
        TraceMgr.trace(this, "getPrinterJob");
        return null;
    }

    protected FontConfiguration createFontConfiguration() {
        try {
            boolean usePlatformFontConfiguration = AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getBooleanProperty("agent.usePlatformFontConfiguration", true);
            if (usePlatformFontConfiguration) {
                Class fontConfigurationClass = this.loadClassIfExists("sun.awt.windows.WFontConfiguration");
                if (fontConfigurationClass == null) {
                    fontConfigurationClass = this.loadClassIfExists("sun.awt.motif.MFontConfiguration");
                }
                if (fontConfigurationClass != null) {
                    Constructor constructor = fontConfigurationClass.getConstructor(SunGraphicsEnvironment.class);
                    return (FontConfiguration)constructor.newInstance(this);
                }
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, "Warning: failed to load platform form configuration", (Throwable)x);
        }
        TraceMgr.trace(this, "createFontConfiguration(), returning AjaxSwingFontConfiguration()");
        return new AjaxSwingFontConfiguration((SunFontManager)FontManagerFactory.getInstance());
    }

    public FontConfiguration createFontConfiguration(boolean flag, boolean flag1) {
        try {
            boolean usePlatformFontConfiguration = AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getBooleanProperty("agent.usePlatformFontConfiguration", true);
            if (usePlatformFontConfiguration) {
                Class fontConfigurationClass = this.loadClassIfExists("sun.awt.windows.WFontConfiguration");
                if (fontConfigurationClass == null) {
                    fontConfigurationClass = this.loadClassIfExists("sun.awt.motif.MFontConfiguration");
                }
                if (fontConfigurationClass != null) {
                    Constructor constructor = fontConfigurationClass.getConstructor(SunGraphicsEnvironment.class, Boolean.TYPE, Boolean.TYPE);
                    return (FontConfiguration)constructor.newInstance(this, flag, flag);
                }
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, "Warning: failed to load platform form configuration", (Throwable)x);
        }
        TraceMgr.trace(this, "createFontConfiguration(), returning AjaxSwingFontConfiguration(...)");
        return new AjaxSwingFontConfiguration((SunFontManager)FontManagerFactory.getInstance(), flag, flag1);
    }

    protected Class loadClassIfExists(String name) {
        Class<?> mClass = null;
        try {
            mClass = Class.forName(name);
            TraceMgr.trace(this, "Loaded font configuration class " + name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return mClass;
    }

    @Override
    public String getFileNameFromXLFD(String fontName) {
        return ((SunFontManager)FontManagerFactory.getInstance()).getDefaultFontFile();
    }

    public static String getClassName() {
        String name = new NameHelper().getClass().getName();
        return name.substring(0, name.indexOf(36));
    }

    @Override
    public boolean isDisplayLocal() {
        return true;
    }

    public static class NameHelper {
    }
}

