/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.AbstractDocumentRenderer;
import com.creamtec.ajaxswing.v4.render.ComponentUpdater;
import com.creamtec.core.TraceMgr;
import java.util.Enumeration;
import java.util.HashMap;

public class WindowUpdater {
    protected HashMap<String, ComponentUpdater> componentUpdatersMap = new HashMap();

    public ComponentUpdater getComponentUpdater(Class className) {
        if (className == null) {
            return null;
        }
        ComponentUpdater updater = this.componentUpdatersMap.get(className.getName());
        if (updater != null) {
            this.componentUpdatersMap.put(className.getName(), updater);
            return updater;
        }
        if (className.equals("java.lang.Object")) {
            return null;
        }
        return this.getComponentUpdater(className.getSuperclass());
    }

    public void initCustomUpdatersAndEmulators(ClientAgent agent) {
        TraceMgr.trace((Object)this, "Initializing custom updaters and emulators...", 6);
        if (agent != null) {
            Enumeration<Object> keys = agent.getProps().keys();
            boolean keepLoadingUpdaters = true;
            boolean keepLoadingEmulators = true;
            if (!agent.getProps().containsKey("updater.javax.swing.JFileChooser")) {
                agent.getProps().put("updater.javax.swing.JFileChooser", "com.creamtec.ajaxswing.v4.render.DefaultJFileChooserProcessor");
            }
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.startsWith("updater.") && keepLoadingUpdaters) {
                    String updaterClassName = agent.getProps().getProperty(key);
                    TraceMgr.trace((Object)this, "Loading custom updater " + updaterClassName, 6);
                    updaterClassName = updaterClassName.trim();
                    try {
                        Class<?> updaterClass = agent.getClassLoader().loadClass(updaterClassName);
                        Object updater = updaterClass.newInstance();
                        if (!(updater instanceof ComponentUpdater)) {
                            throw new AjaxSwingException("Error: Custom updater " + updaterClassName + " does not implement interface ComponentUpdater");
                        }
                        this.componentUpdatersMap.put(key.substring(8), (ComponentUpdater)updater);
                        TraceMgr.trace((Object)this, "Sucessfully registered updater", 6);
                        if (AbstractDocumentRenderer.LIMIT_MODE) {
                            keepLoadingUpdaters = false;
                        }
                    }
                    catch (Throwable x) {
                        TraceMgr.trace((Object)this, "Failed to load custom updater " + updaterClassName, x);
                    }
                }
                if (keepLoadingUpdaters || keepLoadingEmulators) continue;
                break;
            }
            TraceMgr.trace((Object)this, "Custom updaters and emulators initialized", 6);
        } else {
            TraceMgr.trace((Object)this, "*** Warning: failed to determine the agent to load custom updaters and emulators", 3);
        }
    }
}

