/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.ajaxswing.core.AjaxSwingThread;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentManager;
import com.creamtec.ajaxswing.core.ThreadManager;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingContainerPeer;
import com.creamtec.core.TraceMgr;
import java.awt.AWTHelper;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.WindowPeer;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class AjaxSwingWindowPeer
extends AjaxSwingContainerPeer
implements WindowPeer {
    public AjaxSwingWindowPeer(Window window) {
        super(window);
        JRootPane rootPane;
        if (!(window instanceof JWindow) || (rootPane = ((JWindow)window).getRootPane()) != null) {
            // empty if block
        }
    }

    @Override
    public void toFront() {
        TraceMgr.trace((Object)this, "toFront", 6);
        AjaxSwingThread myThread = this.getMyThread();
        if (myThread != null) {
            myThread.getClientAgent().getUIManager().windowToFront((Window)this.target);
        } else if (this.target instanceof Window) {
            ClientAgentManager.getMyAgent(this).getUIManager().windowToFront((Window)this.target);
        }
    }

    @Override
    public void toBack() {
        TraceMgr.trace((Object)this, "toBack", 6);
        AjaxSwingThread myThread = this.getMyThread();
        if (myThread != null) {
            myThread.getClientAgent().getUIManager().windowToBack((Window)this.target);
        }
    }

    @Override
    public void show() {
        TraceMgr.trace(this, "show");
        ClientAgent agent = ClientAgent.getCurrentInstance();
        ThreadManager.setMyThread(this, agent.getAjaxSwingThreadGroup().getPrimeThread());
        TraceMgr.trace(this, "show, my thread = " + this.getMyThread() + ", agent = " + agent);
        int duration = agent.getProps().getIntProperty("agent.monitorAsynchronousUpdates.duration", 0);
        if (duration > 0) {
            agent.setUpdateBrowser(true);
        }
        ClientAgentManager.setMyAgent(this, agent);
        agent.getUIManager().showWindow((Window)this.target);
    }

    @Override
    public void hide() {
        TraceMgr.trace(this, "hide");
        ClientAgent agent = ClientAgentManager.getMyAgent(this);
        TraceMgr.trace(this, "hide, my thread = " + ThreadManager.getMyThread(this) + ", agent = " + agent);
        if (agent == null) {
            agent = ClientAgent.getCurrentInstance();
        }
        agent.getUIManager().hideWindow((Window)this.target);
        ClientAgentManager.clearMyAgent(this);
        ThreadManager.setMyThread(this, null);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int operation) {
        boolean resized = this.getDelegate().getWidth() != width || this.getDelegate().getHeight() != height;
        boolean moved = this.getDelegate().getX() != x || this.getDelegate().getY() != y;
        super.setBounds(x, y, width, height, operation);
        if (resized || moved) {
            ComponentEvent e;
            EventQueue eventQueue = null;
            ClientAgent agent = ClientAgent.getCurrentInstance();
            eventQueue = agent != null ? agent.getEventQueue() : AWTHelper.getEventQueue(Thread.currentThread());
            if (resized && eventQueue != null) {
                e = new ComponentEvent(this.getTarget(), 101);
                eventQueue.postEvent(e);
            }
            if (moved && eventQueue != null) {
                e = new ComponentEvent(this.getTarget(), 100);
                eventQueue.postEvent(e);
            }
        }
    }

    public int handleFocusTraversalEvent(KeyEvent keyevent) {
        TraceMgr.trace(this, "handleFocusTraversalEvent");
        if (keyevent.getKeyCode() != 9 || keyevent.getSource() instanceof TextArea) {
            return 0;
        }
        if ((keyevent.getModifiers() & 0xFFFFFFFE) > 0) {
            return 0;
        }
        int i = keyevent.getID();
        if (i == 402 || i == 400) {
            return 1;
        }
        return !keyevent.isShiftDown() ? 2 : 3;
    }

    public AjaxSwingThread getMyThread() {
        return ThreadManager.getMyThread(this);
    }

    public boolean requestWindowFocus() {
        return true;
    }

    public void updateAlwaysOnTop() {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
    }

    @Override
    public void setModalBlocked(Dialog blocker, boolean blocked) {
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    public void updateWindow(BufferedImage backBuffer) {
    }

    @Override
    public void repositionSecurityWarning() {
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void updateAlwaysOnTopState() {
        TraceMgr.trace(this, "updateAlwaysOnTopState");
        this.setAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }
}

