/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.servlet;

import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.servlet.SessionListener;
import com.creamtec.core.TraceMgr;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SessionManager
extends Thread {
    protected Map sessions = new HashMap();
    protected long sessionTimeout;
    protected boolean keepChecking = true;

    public SessionManager(long sessionTimeout) {
        this(sessionTimeout, null);
    }

    public SessionManager(long sessionTimeout, String name) {
        this.sessionTimeout = sessionTimeout * 1000L;
        if (name != null) {
            TraceMgr.trace(this, "Starting [" + name + "] session tracking thread with timeout (s) of " + sessionTimeout);
        } else {
            TraceMgr.trace(this, "Starting session tracking thread with timeout (s) of " + sessionTimeout);
        }
        this.start();
    }

    public void addSession(Object session, SessionListener listener, ClientAgentRemote agent) {
        this.sessions.put(session, new SessionInfo(session, listener, agent));
    }

    public void removeSession(Object session) {
        this.sessions.remove(session);
    }

    public void actionPerformed(Object session) {
        SessionInfo info = (SessionInfo)this.sessions.get(session);
        if (info != null) {
            info.lastOperationTime = System.currentTimeMillis();
        }
    }

    public void shutdown() {
        this.keepChecking = false;
    }

    public Set getSessions() {
        return this.sessions.keySet();
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout * 1000L;
    }

    @Override
    public void run() {
        while (this.keepChecking) {
            long curTime = System.currentTimeMillis();
            Object[] infos = this.sessions.values().toArray();
            TraceMgr.trace((Object)this, "Checking sessions size = " + infos.length, 5);
            long minTimeout = Long.MAX_VALUE;
            for (int i = 0; i < infos.length; ++i) {
                long agentTimeout;
                SessionInfo info = (SessionInfo)infos[i];
                try {
                    agentTimeout = info.agent.getSessionTimeout();
                }
                catch (RemoteException e) {
                    agentTimeout = -1L;
                }
                long l = agentTimeout = agentTimeout == -1L ? this.sessionTimeout : agentTimeout * 1000L;
                if (agentTimeout < minTimeout) {
                    minTimeout = agentTimeout;
                }
                if (info.lastOperationTime + agentTimeout >= curTime) continue;
                info.listener.sessionExpired(info.session);
                Thread.yield();
            }
            try {
                SessionManager.sleep(minTimeout > 240000L ? 120000L : minTimeout / 2L);
            }
            catch (Exception x) {
                break;
            }
        }
    }

    public SessionInfo getSession(int clientId) {
        return (SessionInfo)this.sessions.get(clientId);
    }

    public static class SessionInfo {
        public long lastOperationTime = System.currentTimeMillis();
        public Object session;
        public SessionListener listener;
        public ClientAgentRemote agent;

        public SessionInfo(Object session, SessionListener listener, ClientAgentRemote agent) {
            this.session = session;
            this.listener = listener;
            this.agent = agent;
        }
    }
}

