/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4.utils;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.peer.LightweightPeer;
import java.awt.peer.PanelPeer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.text.JTextComponent;

public class ComponentUtils {
    public static Component findChildOfClass(Container container, Class cls) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component child;
            Component comp = container.getComponent(i);
            if (cls.isInstance(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || (child = ComponentUtils.findChildOfClass((Container)comp, cls)) == null) continue;
            return child;
        }
        return null;
    }

    public static Container getActiveWindow() {
        try {
            JDesktopPane desktopPane;
            Container activeWindow = ClientAgent.getCurrentInstance().getUIManager().getWindowInFocus();
            if (activeWindow != null && (desktopPane = (JDesktopPane)ComponentUtils.findChildOfClass(activeWindow, JDesktopPane.class)) != null && desktopPane.getSelectedFrame() != null) {
                activeWindow = desktopPane.getSelectedFrame();
            }
            return activeWindow;
        }
        catch (Exception ex) {
            TraceMgr.trace("WARN: Failed to get active window", ex);
            return null;
        }
    }

    public static boolean isHeavyPanel(Component comp) {
        return !(comp.getPeer() instanceof LightweightPeer) && comp.getPeer() instanceof PanelPeer && comp instanceof Container;
    }

    public static String getCssClasses(Component comp) {
        JScrollBar bar;
        String simpleName = null;
        simpleName = comp.getClass().getPackage() != null ? comp.getClass().getName().substring(comp.getClass().getPackage().getName().length() + 1) : comp.getClass().getName();
        String base = simpleName.replace('$', '_');
        StringBuilder builder = new StringBuilder(base);
        if (ComponentUtils.isWindow(comp)) {
            builder.append(" window");
            if (comp instanceof Dialog && ((Dialog)comp).isModal()) {
                builder.append(" modal");
            }
        }
        if (ComponentUtils.isTitledPane(comp)) {
            builder.append(" titlePane");
        }
        if (comp instanceof BasicSplitPaneDivider) {
            BasicSplitPaneDivider divider = (BasicSplitPaneDivider)comp;
            if (divider.isEnabled() && divider.getBasicSplitPaneUI() != null && divider.getBasicSplitPaneUI().getOrientation() == 0) {
                builder.append(" JDividerEnabledHorizontal");
            }
            if (divider.isEnabled() && divider.getBasicSplitPaneUI() != null && divider.getBasicSplitPaneUI().getOrientation() == 1) {
                builder.append(" JDividerEnabledVertical");
            }
        }
        if ((comp instanceof AbstractButton || comp instanceof JMenuItem || comp instanceof JMenu) && comp.isEnabled()) {
            builder.append(" enabled");
        }
        if (comp instanceof JButton && !"JButton".equals(base)) {
            builder.append(" JButton");
        }
        if (comp instanceof JMenu && !"JMenu".equals(base)) {
            builder.append(" JMenu");
        }
        if (comp instanceof JMenuItem && !"JMenuItem".equals(base)) {
            builder.append(" JMenuItem");
        }
        if (comp instanceof BasicComboPopup && !"BasicComboPopup".equals(base)) {
            builder.append(" BasicComboPopup");
        }
        if (comp instanceof JScrollBar && (bar = (JScrollBar)comp).isEnabled()) {
            if (bar.getOrientation() == 0) {
                builder.append(" JScrollBarEnabledHorizontal");
            }
            if (bar.getOrientation() == 1) {
                builder.append(" JScrollBarEnabledVertical");
            }
        }
        if (comp instanceof JSlider) {
            JSlider slider = (JSlider)comp;
            if (slider.isEnabled() && slider.getOrientation() == 0) {
                builder.append(" JSliderEnabledHorizontal");
            }
            if (slider.isEnabled() && slider.getOrientation() == 1) {
                builder.append(" JSliderEnabledVertical");
            }
        }
        if (comp instanceof JTextComponent) {
            builder.append(" JTextComponent");
        }
        if (comp instanceof JEditorPane && "true".equalsIgnoreCase(ClientAgent.getCurrentInstance().getComponentProperty(comp, "richTextEditor"))) {
            String contentType = ((JEditorPane)comp).getContentType();
            builder.append(" ").append(contentType == null ? "" : contentType.toLowerCase().replace('/', '-'));
        }
        return builder.toString();
    }

    public static FileOpener getFileOpener(Component component) {
        if (component instanceof JComponent) {
            return (FileOpener)((JComponent)component).getClientProperty("ajaxswing.fileOpener");
        }
        return null;
    }

    public static Map<String, String> getHtmlAttributes(JComponent component) {
        HashMap attributes = (HashMap)component.getClientProperty("ajaxswing.html.attributes");
        if (attributes == null) {
            attributes = new HashMap();
            component.putClientProperty("ajaxswing.html.attributes", attributes);
        }
        return attributes;
    }

    public static String getWindowTitle(Component comp) {
        Window window = null;
        window = comp instanceof Window ? (Window)comp : (Window)SwingUtilities.getAncestorOfClass(Window.class, comp);
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return "UKNOWN TITLE, class = " + comp.getClass().getName();
    }

    public static boolean isTitledPane(Object comp) {
        if (comp == null) {
            return false;
        }
        String name = comp.getClass().getSimpleName();
        if ("MetalInternalFrameTitlePane".equals(name)) {
            return true;
        }
        return "MetalTitlePane".equals(name);
    }

    public static boolean isWindow(Component comp) {
        return comp instanceof Window || comp instanceof JInternalFrame;
    }

    public static void setFileOpener(JComponent component, FileOpener fileOpener) {
        component.putClientProperty("ajaxswing.fileOpener", fileOpener);
    }
}

