/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.ajaxswing.gui.VersionHelper;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Bootstrapper {
    private static final String LAST_KNOWN_JDK_VERSION_FILE = "lastKnownJdkVersion.txt";

    public static void main(String[] args) {
        try {
            TraceMgr.loadSettings = false;
            String root = System.getProperty("ajaxswing.home");
            if (root == null) {
                throw new Exception("Initialization property ajaxswing.home is not specified. Use -Dajaxswing.home=dir switch to java command line");
            }
            Utilities.setRootDir(root);
            String javaVersion = System.getProperty("java.version");
            String lastKnownJdkVersion = Bootstrapper.readLastKnownJdkVersion();
            TraceMgr.trace(Bootstrapper.class, "Java version: " + javaVersion);
            TraceMgr.trace(Bootstrapper.class, "Last version: " + lastKnownJdkVersion);
            if (javaVersion != null && !javaVersion.equals(lastKnownJdkVersion)) {
                TraceMgr.trace(Bootstrapper.class, "Last compatible Java version " + lastKnownJdkVersion + " doesn't match current JDK version " + javaVersion + ", running compatibility script...", 3);
                Bootstrapper.enableCompatibleJdk();
                Bootstrapper.writeLastKnownJdkVersion();
                TraceMgr.trace(Bootstrapper.class, "AjaxSwing is now compatible with the current JDk version", 3);
            }
        }
        catch (Exception x) {
            TraceMgr.trace("Failed to bootstrap AjaxSwing", x);
            System.exit(1);
        }
    }

    private static void enableCompatibleJdk() throws Exception {
        String cmdLine = Utilities.getFullPath("bin" + File.separator + "setup" + File.separator);
        String jdkVersion = VersionHelper.getCurrentJdkVersion();
        String[] numbers = jdkVersion.split("\\.");
        String majorVersion = numbers[0] + numbers[1];
        cmdLine = cmdLine + "enableJdk" + majorVersion;
        cmdLine = System.getProperty("os.name").indexOf("indows") != -1 ? cmdLine + ".bat" : cmdLine + ".sh";
        Utilities.execProcess(new String[]{cmdLine}, true);
    }

    private static String readLastKnownJdkVersion() throws Exception {
        String lastKnownJdkVersion = "";
        String fileName = Utilities.getConfFullPath(LAST_KNOWN_JDK_VERSION_FILE);
        File file = new File(fileName);
        if (file.exists() && file.canRead()) {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            lastKnownJdkVersion = reader.readLine();
            reader.close();
        }
        return lastKnownJdkVersion;
    }

    private static void writeLastKnownJdkVersion() throws IOException {
        String javaVersion = System.getProperty("java.version");
        String fileName = Utilities.getConfFullPath(LAST_KNOWN_JDK_VERSION_FILE);
        FileWriter file = new FileWriter(fileName);
        file.write(javaVersion);
        file.close();
    }
}

