/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.creamtec.ajaxswing.core.AjaxSwingThread;
import com.creamtec.ajaxswing.core.AjaxSwingThreadGroup;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagLayoutInfo;
import java.awt.KeyboardFocusManager;
import java.awt.List;
import java.awt.event.MouseListener;

public class AWTHelper {
    protected static AWTHelper instance = null;

    public AWTHelper() {
        instance = this;
    }

    public AWTHelper getInstance() {
        return instance;
    }

    public void assertEventQueueInitialized(EventQueue queue) {
    }

    public static Component getBorderLayoutComponent(BorderLayout layout, String constraint) {
        if (constraint.equals("North")) {
            return layout.north;
        }
        if (constraint.equals("South")) {
            return layout.south;
        }
        if (constraint.equals("Center")) {
            return layout.center;
        }
        if (constraint.equals("West")) {
            return layout.west;
        }
        if (constraint.equals("East")) {
            return layout.east;
        }
        return null;
    }

    public static Dimension getGridBagLayoutSize(GridBagLayout layout, Container parent) {
        GridBagLayoutInfo info = layout.GetLayoutInfo(parent, 2);
        return new Dimension(info.width, info.height);
    }

    public static EventDispatchThread getDispatchThread(EventQueue queue) {
        return queue.getDispatchThread();
    }

    public static boolean isDispatchThread(Thread thread) {
        return thread instanceof EventDispatchThread;
    }

    public static void stopDispatching(EventQueue queue) {
        if (queue.getDispatchThread() != null && queue.getDispatchThread().isAlive() && !queue.getDispatchThread().isInterrupted()) {
            queue.getDispatchThread().interrupt();
        }
    }

    public static int getItemListenersCount(Checkbox comp) {
        return comp.itemListener != null ? 1 : 0;
    }

    public static int getItemListenersCount(Choice comp) {
        return comp.itemListener != null ? 1 : 0;
    }

    public static int getItemListenersCount(List comp) {
        return comp.itemListener != null ? 1 : 0;
    }

    public static void invalidateTree(Container cont) {
        cont.invalidateTree();
    }

    public static void validateTree(Container cont) {
        cont.validateTree();
    }

    public static MouseListener getMouseListener(Component comp) {
        return comp.mouseListener;
    }

    public static void setPrimeThread(EventQueue queue, AjaxSwingThread thread) {
        if (instance != null) {
            instance.assertEventQueueInitialized(queue);
        }
        if (queue.getDispatchThread() != null && queue.getDispatchThread().getThreadGroup() != null) {
            ThreadGroup group = queue.getDispatchThread().getThreadGroup();
            ((AjaxSwingThreadGroup)group).setPrimeThread(thread);
        }
    }

    public static EventQueue getEventQueue(Thread thread) {
        if (thread instanceof EventDispatchThread) {
            EventDispatchThread dispatchThread = (EventDispatchThread)thread;
            return dispatchThread.getEventQueue();
        }
        return null;
    }

    public static void initDispatchThread(EventQueue queue) {
        queue.initDispatchThread();
    }

    public static boolean isRecursivelyVisible(Component component) {
        return component.isRecursivelyVisible();
    }

    public static Color getForeground(Component component) {
        return component.foreground;
    }

    public static Color getBackground(Component component) {
        return component.background;
    }

    public static Font getFont(Component component) {
        return component.font;
    }

    public static void setGlobalFocusOwner(Component component) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalFocusOwner(component);
    }
}

