/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentFocusManager
extends DefaultKeyboardFocusManager {
    private static final Logger focusLog = Logger.getLogger("java.awt.focus.KeyboardFocusManager");
    private Window ajaxswingFocusedWindow;
    private Component ajaxswingFocusOwner;
    private Component ajaxswingPermanentFocusOwner;
    private Window ajaxswingActiveWindow;
    private Container ajaxswingCurrentFocusCycleRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void setGlobalFocusedWindow(Window focusedWindow) throws SecurityException {
        Window oldFocusedWindow = null;
        boolean shouldFire = false;
        if (focusedWindow == null || focusedWindow.isFocusableWindow()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            oldFocusedWindow = this.getFocusedWindow();
            try {
                this.fireVetoableChange("focusedWindow", oldFocusedWindow, focusedWindow);
            }
            catch (PropertyVetoException e) {
                // MONITOREXIT : clazz
                return;
            }
            this.ajaxswingFocusedWindow = focusedWindow;
            shouldFire = true;
            // MONITOREXIT : clazz
        }
        if (!shouldFire) return;
        this.firePropertyChange("focusedWindow", oldFocusedWindow, focusedWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getFocusOwner() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (this.ajaxswingFocusOwner == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Component getGlobalFocusOwner() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void setGlobalFocusOwner(Component focusOwner) {
        Component oldFocusOwner = null;
        boolean shouldFire = false;
        if (focusOwner == null || focusOwner.isFocusable()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            oldFocusOwner = this.getFocusOwner();
            try {
                this.fireVetoableChange("focusOwner", oldFocusOwner, focusOwner);
            }
            catch (PropertyVetoException e) {
                // MONITOREXIT : clazz
                return;
            }
            this.ajaxswingFocusOwner = focusOwner;
            if (!(focusOwner == null || this.getCurrentFocusCycleRoot() != null && focusOwner.isFocusCycleRoot(this.getCurrentFocusCycleRoot()))) {
                Container rootAncestor = focusOwner.getFocusCycleRootAncestor();
                if (rootAncestor == null && focusOwner instanceof Window) {
                    rootAncestor = (Container)focusOwner;
                }
                if (rootAncestor != null) {
                    this.setGlobalCurrentFocusCycleRoot(rootAncestor);
                }
            }
            shouldFire = true;
            // MONITOREXIT : clazz
        }
        if (!shouldFire) return;
        this.firePropertyChange("focusOwner", oldFocusOwner, focusOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Component getGlobalPermanentFocusOwner() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingPermanentFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void setGlobalPermanentFocusOwner(Component permanentFocusOwner) throws SecurityException {
        Component oldPermanentFocusOwner = null;
        boolean shouldFire = false;
        if (permanentFocusOwner == null || permanentFocusOwner.isFocusable()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            oldPermanentFocusOwner = this.getPermanentFocusOwner();
            try {
                this.fireVetoableChange("permanentFocusOwner", oldPermanentFocusOwner, permanentFocusOwner);
            }
            catch (PropertyVetoException e) {
                // MONITOREXIT : clazz
                return;
            }
            this.ajaxswingPermanentFocusOwner = permanentFocusOwner;
            KeyboardFocusManager.setMostRecentFocusOwner(permanentFocusOwner);
            shouldFire = true;
            // MONITOREXIT : clazz
        }
        if (!shouldFire) return;
        this.firePropertyChange("permanentFocusOwner", oldPermanentFocusOwner, permanentFocusOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Window getFocusedWindow() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (this.ajaxswingFocusedWindow == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingFocusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Window getGlobalFocusedWindow() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingFocusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Window getActiveWindow() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (this.ajaxswingActiveWindow == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingActiveWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Window getGlobalActiveWindow() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingActiveWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setGlobalActiveWindow(Window activeWindow) throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            Window oldActiveWindow = this.getActiveWindow();
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("Setting global active window to " + activeWindow + ", old active " + oldActiveWindow);
            }
            try {
                this.fireVetoableChange("activeWindow", oldActiveWindow, activeWindow);
            }
            catch (PropertyVetoException e) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.ajaxswingActiveWindow = activeWindow;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.firePropertyChange("activeWindow", oldActiveWindow, activeWindow);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getCurrentFocusCycleRoot() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (this.ajaxswingCurrentFocusCycleRoot == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingCurrentFocusCycleRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Container getGlobalCurrentFocusCycleRoot() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingCurrentFocusCycleRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalCurrentFocusCycleRoot(Container newFocusCycleRoot) throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            Container oldFocusCycleRoot = this.getCurrentFocusCycleRoot();
            this.ajaxswingCurrentFocusCycleRoot = newFocusCycleRoot;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.firePropertyChange("currentFocusCycleRoot", oldFocusCycleRoot, newFocusCycleRoot);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getPermanentFocusOwner() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (this.ajaxswingPermanentFocusOwner == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ajaxswingPermanentFocusOwner;
        }
    }

    @Override
    void dumpRequests() {
        super.dumpRequests();
    }

    @Override
    Component getCurrentWaitingRequest(Component parent) {
        return super.getCurrentWaitingRequest(parent);
    }
}

