/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.creamtec.ajaxswing.gui.VersionHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class SwingHelper {
    private SwingHelper() {
    }

    public static ButtonGroup getButtonGroup(AbstractButton button) {
        if (button.getModel() instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)button.getModel()).group;
        }
        return null;
    }

    public static int getBoxLayoutAxis(Container cont, BoxLayout layout) {
        Dimension size = SwingHelper.getBoxLayoutDim(cont);
        Insets insets = cont.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        if (size.width == layout.minimumLayoutSize((Container)cont).width) {
            return 0;
        }
        return 1;
    }

    public static Dimension getBoxLayoutDim(Container target) {
        Dimension targetMin = target.getMinimumSize();
        SwingHelper.ensureSizeValidity(target, targetMin);
        Dimension d = new Dimension();
        int n = target.getComponentCount();
        SizeRequirements[] xChildren = new SizeRequirements[n];
        SizeRequirements[] yChildren = new SizeRequirements[n];
        for (int i = 0; i < n; ++i) {
            Component c = target.getComponent(i);
            Dimension min = c.getMinimumSize();
            Dimension typ = c.getPreferredSize();
            Dimension max = c.getMaximumSize();
            xChildren[i] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
            yChildren[i] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
        }
        d.width = SizeRequirements.getTiledSizeRequirements((SizeRequirements[])xChildren).minimum;
        d.height = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])yChildren).minimum;
        return d;
    }

    public static void ensureSizeValidity(Component comp, Dimension min) {
        if (min.width != 0 && min.height != 0 && min.width != min.height) {
            return;
        }
        if (comp instanceof JComponent) {
            if (min.width == 0) {
                min.width = 4;
            }
            if (min.height == 0) {
                min.height = 2;
            }
            if (min.width == min.height) {
                min.width += 2;
            }
            ((JComponent)comp).setMinimumSize(new Dimension(min.width, min.height));
            comp.invalidate();
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component c = cont.getComponent(i);
                min = c.getMinimumSize();
                SwingHelper.ensureSizeValidity(c, min);
            }
        }
    }

    public static void clearTreeExpansionState(JTree tree) {
        tree.clearToggledPaths();
    }

    public static EventListenerList getEventListeners(JComponent comp) {
        return comp.listenerList;
    }

    public static EventListenerList getEventListeners(DefaultListSelectionModel model) {
        return model.listenerList;
    }

    public static Frame getSharedOwnerFrame() {
        return SwingUtilities.getSharedOwnerFrame();
    }

    public static boolean isJEditorPaneLoading(JEditorPane editorPane) {
        try {
            Field field = editorPane.getClass().getDeclaredField("loading");
            field.setAccessible(true);
            return field.get(editorPane) != null;
        }
        catch (NoSuchFieldException field) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean isRecursivelyVisible(Component component) {
        Container parent = component.getParent();
        if ((VersionHelper.SUPPORTED_JDK_VERSION == "1.5" || VersionHelper.SUPPORTED_JDK_VERSION == "1.6") && parent != null && parent.getClass().getName().equals("javax.swing.SwingUtilities$SharedOwnerFrame")) {
            return true;
        }
        return component.isVisible() && (parent == null || SwingHelper.isRecursivelyVisible(parent));
    }

    public static Point getPopupMenuLocation(Component menu) {
        if (menu instanceof JPopupMenu) {
            return ((JPopupMenu)menu).popup.getComponent().getLocation();
        }
        if (menu instanceof JMenu) {
            return ((JMenu)menu).getPopupMenu().popup.getComponent().getLocation();
        }
        return null;
    }

    public static Component getPopupMenuPanel(Component menu) {
        if (menu instanceof JPopupMenu) {
            return ((JPopupMenu)menu).popup.getComponent();
        }
        if (menu instanceof JMenu) {
            return ((JMenu)menu).getPopupMenu().popup.getComponent();
        }
        return null;
    }

    public static boolean isAPopupHeavyWeightWindow(Window window) {
        String windowClassName = window.getClass().getName();
        return windowClassName.equalsIgnoreCase("javax.swing.Popup$HeavyWeightWindow");
    }

    public static Component findPopupMenuInWindow(Component comp) {
        Component result = null;
        if (comp instanceof JPopupMenu) {
            result = comp;
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                result = SwingHelper.findPopupMenuInWindow(container.getComponent(i));
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public static Object getPopupForceHeavyWeightPopupKey() {
        try {
            Class<?> classObj = Class.forName("javax.swing.PopupFactory");
            Field field = classObj.getDeclaredField("forceHeavyWeightPopupKey");
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception exception) {
            return "__force_heavy_weight_popup__";
        }
    }
}

