/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.JVMProcess;
import com.creamtec.ajaxswing.core.AgentInitData;
import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.HttpResponseData;
import com.creamtec.ajaxswing.rendering.html.HTMLClientAgent;
import com.creamtec.core.TraceMgr;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.List;
import java.util.Locale;

public class ClientAgentImpl
extends UnicastRemoteObject
implements ClientAgentRemote,
Unreferenced {
    protected ClientAgent delegate;
    protected String agentName;
    protected boolean hasShutdown;
    public static int instancesCount;

    public ClientAgentImpl(String agentName, String appName) throws Exception {
        TraceMgr.trace((Object)this, (String)("Instantiating stand alone client agent for app " + appName), (int)3);
        this.delegate = new ClientAgentDelegate(agentName, appName);
        if (this.delegate.getProps().getBooleanProperty("router.preloadApp", false)) {
            this.delegate.runApp(true);
        }
        if (agentName != null) {
            this.agentName = agentName;
        }
        TraceMgr.trace((Object)this, (String)("Initialization complete, instances in JVM = " + ++instancesCount), (int)2);
    }

    public void init(AgentInitData initData, HttpRequestData requestData) throws Exception, RemoteException {
        try {
            this.delegate.init(initData, requestData);
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)"Failed to initialize", (Throwable)x);
            throw x;
        }
    }

    public boolean isDownloadAllowed(String downloadFileName) throws RemoteException {
        return this.delegate.isDownloadAllowed(downloadFileName);
    }

    public void removeDownloadFileName(String downloadFileName) {
        this.delegate.removeDownloadFileName(downloadFileName);
    }

    public void denyDownload(String downloadFileName) {
        this.delegate.denyDownload(downloadFileName);
    }

    public void denyDownload(File file) {
        this.delegate.denyDownload(file);
    }

    public void runApp(boolean wait) throws AjaxSwingException, RemoteException {
        this.delegate.runApp(wait);
    }

    public void shutdown() {
        if (!this.hasShutdown) {
            this.hasShutdown = true;
            TraceMgr.trace((Object)this, (String)("shutdown, remaining instances in JVM = " + --instancesCount), (int)2);
            this.delegate.shutdown();
        }
    }

    public HttpResponseData processHttpRequest(HttpRequestData request) throws Exception, RemoteException {
        try {
            JVMProcess.getInstance().ping();
            HttpResponseData output = this.delegate.processHttpRequest(request);
            TraceMgr.newLine();
            return output;
        }
        catch (AjaxSwingException x) {
            TraceMgr.trace((Object)this, (String)"Failed to process a request", (Throwable)x);
            TraceMgr.newLine();
            throw x;
        }
    }

    public HttpResponseData renderWindows(HttpRequestData request) throws Exception, RemoteException {
        try {
            JVMProcess.getInstance().ping();
            HttpResponseData output = this.delegate.renderWindows(request);
            TraceMgr.newLine();
            return output;
        }
        catch (AjaxSwingException x) {
            TraceMgr.trace((Object)this, (String)"Failed to process a request", (Throwable)x);
            TraceMgr.newLine();
            throw x;
        }
    }

    @Override
    public void unreferenced() {
        TraceMgr.trace((Object)this, (String)"unreferenced");
        this.shutdown();
    }

    public void ping() throws RemoteException {
        JVMProcess.getInstance().ping();
    }

    public long getSessionTimeout() throws RemoteException {
        return this.delegate.getSessionTimeout();
    }

    public void setSessionTimeout(long seconds) throws RemoteException {
        this.delegate.setSessionTimeout(seconds);
    }

    public String getExitPage() throws RemoteException {
        return this.delegate.getExitPage();
    }

    public void setExitPage(String pageName) throws RemoteException {
        this.delegate.setExitPage(pageName);
    }

    public Locale getUserLocale() {
        return this.delegate.getUserLocale();
    }

    public AjaxSwingProperties getProps() {
        return this.delegate.getProps();
    }

    public void setUserLocale(Locale currentLocale) {
        this.delegate.setUserLocale(currentLocale);
    }

    public String getBrowserLocale() {
        return this.delegate.getBrowserLocale();
    }

    public void setBrowserLocale(String browserLocale) {
        this.delegate.setBrowserLocale(browserLocale);
    }

    public void setFontCalibrationData(String allCalibrationData) {
        this.delegate.setFontCalibrationData(allCalibrationData);
    }

    public double getFontCalibrationData(String fontName, int fontSize, boolean isCapital) {
        return this.delegate.getFontCalibrationData(fontName, fontSize, isCapital);
    }

    public List getTempFiles() throws RemoteException {
        return this.delegate.getTempFiles();
    }

    public String getCsrfToken() throws RemoteException {
        return this.delegate.getCsrfToken();
    }

    class ClientAgentDelegate
    extends HTMLClientAgent {
        public ClientAgentDelegate(String agentName, String appName) throws Exception {
            super(agentName, appName);
        }
    }
}

