/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.servlet.AppDesc;
import com.creamtec.core.TraceMgr;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.lang.StringUtils;

public class FileUploadHandler {
    DiskFileUpload upload = new DiskFileUpload();

    public FileUploadHandler(String tmpDirPath) throws Exception {
        this.upload.setRepositoryPath(tmpDirPath);
        this.upload.setSizeThreshold(0);
    }

    public void handleUpload(AppDesc appDesc, HttpServletRequest request, HttpRequestData requestData) throws Exception {
        FileItem item;
        int i;
        TraceMgr.trace((Object)this, (String)"Handle file upload", (int)6);
        List items = this.upload.parseRequest(request);
        HashMap<String, String> params = new HashMap<String, String>();
        for (i = 0; i < items.size(); ++i) {
            item = (FileItem)items.get(i);
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            String value = item.getString("UTF8");
            if (TraceMgr.getCutoffLevel() >= 5) {
                TraceMgr.trace((Object)this, (String)(" param = " + name + ", value = " + value), (int)5);
            }
            params.put(name, value);
        }
        requestData.setAction((String)params.get("__Action"));
        for (i = 0; i < items.size(); ++i) {
            item = (FileItem)items.get(i);
            if (item.isFormField() || StringUtils.isEmpty(item.getName())) continue;
            String localFileName = this.getLocalFileName(appDesc, item);
            String localFilePath = this.saveUploadedFile(item, localFileName);
            params.put("upload.localFile", localFilePath);
        }
        requestData.setParams(params);
    }

    protected String getLocalFileName(AppDesc appDesc, FileItem item) throws UnsupportedEncodingException {
        String remoteName = new String(item.getName().getBytes(), "UTF-8");
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace((Object)this, (String)("Uploaded file remote name = " + remoteName), (int)6);
        }
        int lastSeparator = remoteName.lastIndexOf(92);
        if ((lastSeparator = Math.max(lastSeparator, remoteName.lastIndexOf(47))) != -1) {
            remoteName = remoteName.substring(lastSeparator + 1);
        }
        String suffix = String.valueOf(System.currentTimeMillis());
        suffix = suffix.substring(suffix.length() - 6);
        return appDesc.getAppName() + "_" + suffix + "_" + remoteName;
    }

    protected String saveUploadedFile(FileItem item, String fileName) throws Exception {
        TraceMgr.trace((Object)this, (String)("processing uploaded file " + fileName), (int)6);
        File uploadedFile = new File(this.upload.getRepositoryPath(), fileName);
        try {
            uploadedFile.createNewFile();
        }
        catch (Exception ex) {
            int i1 = fileName.lastIndexOf(46);
            String ext = i1 == -1 ? ".dat" : fileName.substring(i1);
            uploadedFile = new File(this.upload.getRepositoryPath(), "gen" + fileName.hashCode() + ext);
        }
        item.write(uploadedFile);
        TraceMgr.trace((Object)this, (String)("Uploaded file stored as " + uploadedFile.getCanonicalPath()), (int)6);
        return uploadedFile.getCanonicalPath();
    }

    public boolean isMultipartContent(HttpServletRequest request) {
        return FileUpload.isMultipartContent((HttpServletRequest)request);
    }
}

