/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.core.TraceMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpServletRequestImpl
implements HttpServletRequest,
Serializable {
    private static final long THROW_ILLEGAL_ARGUMENT_EXCEPTION = -100L;
    private static final int THROW_NUMBER_FORMAT_EXCEPTION = -100;
    private String authType;
    private String contextPath;
    private SerializableCookie[] cookies;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private String remoteUser;
    private String requestedSessionId;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private boolean requestedSessionIdFromCookie;
    private boolean requestedSessionIdFromURL;
    private boolean requestedSessionIdValid;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private Locale locale;
    private SerializableEnumeration locales;
    private HashMap parameterMap;
    private String protocol;
    private String remoteAddr;
    private String remoteHost;
    private String scheme;
    private String serverName;
    private int serverPort;
    private boolean secure;
    private SerializableEnumeration params;
    private SerializableEnumeration attrNames;
    private HashMap attrMap;
    private SerializableEnumeration headerNames;
    private HashMap dateHeaders;
    private HashMap stringHeaders;
    private HashMap enumHeaders;
    private HashMap intHeaders;
    private String localAddr;
    private String localName;
    private int localPort;
    private int remotePort;

    public HttpServletRequestImpl(HttpServletRequest request, String requestDataLevel) {
        this.initRequest(request, requestDataLevel);
    }

    private void initRequest(HttpServletRequest request, String requestDataLevel) {
        if ("info".equals(requestDataLevel) || "debug".equals(requestDataLevel)) {
            this.copyInfoLevelData(request);
            if ("debug".equals(requestDataLevel)) {
                this.copyDebugLevelData(request);
            }
        } else {
            throw new UnsupportedOperationException("Invalid request data level:" + requestDataLevel + "; Supported values: none, info and debug.");
        }
    }

    private void copyDebugLevelData(HttpServletRequest request) {
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies != null) {
            this.cookies = new SerializableCookie[requestCookies.length];
            for (int i = 0; i < requestCookies.length; ++i) {
                this.cookies[i] = new SerializableCookie(requestCookies[i]);
            }
        }
        this.locales = new SerializableEnumeration(request.getLocales());
        this.params = new SerializableEnumeration(request.getParameterNames());
        this.attrNames = new SerializableEnumeration(request.getAttributeNames());
        Map requestParametersMap = request.getParameterMap();
        requestParametersMap.keySet();
        this.parameterMap = new HashMap(requestParametersMap);
        Enumeration tmpNames = request.getAttributeNames();
        this.attrMap = new HashMap();
        while (tmpNames.hasMoreElements()) {
            String attributeName = (String)tmpNames.nextElement();
            Object attribute = request.getAttribute(attributeName);
            if (attribute instanceof Serializable) {
                this.attrMap.put(attributeName, attribute);
                continue;
            }
            TraceMgr.trace((Object)this, (String)("Not serializable object " + attribute + " - skip."), (int)TraceMgr.DEFAULT_TRACE_LEVEL);
        }
        this.headerNames = new SerializableEnumeration(request.getHeaderNames());
        tmpNames = request.getHeaderNames();
        this.dateHeaders = new HashMap();
        this.stringHeaders = new HashMap();
        this.enumHeaders = new HashMap();
        this.intHeaders = new HashMap();
        while (tmpNames.hasMoreElements()) {
            String headerName = (String)tmpNames.nextElement();
            try {
                this.dateHeaders.put(headerName, new Long(request.getDateHeader(headerName)));
            }
            catch (IllegalArgumentException e) {
                this.dateHeaders.put(headerName, new Long(-100L));
            }
            this.stringHeaders.put(headerName, request.getHeader(headerName));
            this.enumHeaders.put(headerName, new SerializableEnumeration(request.getHeaders(headerName)));
            try {
                this.intHeaders.put(headerName, new Integer(request.getIntHeader(headerName)));
            }
            catch (NumberFormatException e) {
                this.intHeaders.put(headerName, new Integer(-100));
            }
        }
    }

    private void copyInfoLevelData(HttpServletRequest request) {
        this.authType = request.getAuthType();
        this.characterEncoding = request.getCharacterEncoding();
        this.contentLength = request.getContentLength();
        this.contentType = request.getContentType();
        this.contextPath = request.getContextPath();
        this.locale = request.getLocale();
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.pathTranslated = request.getPathTranslated();
        this.protocol = request.getProtocol();
        this.queryString = request.getQueryString();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.remoteUser = request.getRemoteUser();
        this.requestedSessionId = request.getRequestedSessionId();
        this.requestedSessionIdFromCookie = request.isRequestedSessionIdFromCookie();
        this.requestedSessionIdFromURL = request.isRequestedSessionIdFromURL();
        this.requestedSessionIdValid = request.isRequestedSessionIdValid();
        this.requestURI = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.scheme = request.getScheme();
        this.secure = request.isSecure();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.servletPath = request.getServletPath();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        return this.locales;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getParameter(String s) {
        String value = null;
        Object objValue = this.parameterMap.get(s);
        if (objValue != null) {
            value = objValue instanceof String[] ? ((String[])objValue)[0] : objValue.toString();
        }
        return value;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public String[] getParameterValues(String s) {
        String[] value = null;
        Object objValue = this.parameterMap.get(s);
        if (objValue != null) {
            value = objValue instanceof String[] ? (String[])objValue : new String[]{objValue.toString()};
        }
        return value;
    }

    public Enumeration getParameterNames() {
        return this.params;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Object getAttribute(String s) {
        return this.attrMap.get(s);
    }

    public Enumeration getAttributeNames() {
        return this.attrNames;
    }

    public Enumeration getHeaderNames() {
        return this.headerNames;
    }

    public long getDateHeader(String s) {
        long value = (Long)this.dateHeaders.get(s);
        if (value == -100L) {
            throw new IllegalArgumentException("Header value can't be converted to a date");
        }
        return value;
    }

    public String getHeader(String s) {
        return (String)this.stringHeaders.get(s);
    }

    public Enumeration getHeaders(String s) {
        return (Enumeration)this.enumHeaders.get(s);
    }

    public int getIntHeader(String s) {
        int value = (Integer)this.intHeaders.get(s);
        if (value == -100) {
            throw new NumberFormatException("If the header value can't be converted to an int");
        }
        return value;
    }

    public boolean isUserInRole(String s) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public HttpSession getSession(boolean b) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public String getRealPath(String s) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl. Value is not available for remote client.");
    }

    public void removeAttribute(String s) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl");
    }

    public void setAttribute(String s, Object o) {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl");
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Method not supported in HttpServletRequestImpl");
    }

    public static class SerializableEnumeration
    extends ArrayList
    implements Enumeration {
        private static final long serialVersionUID = 123L;
        private int current = 0;

        public SerializableEnumeration() {
        }

        public SerializableEnumeration(Enumeration enumeration) {
            this.current = 0;
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (o instanceof Serializable) {
                    this.add(o);
                    continue;
                }
                TraceMgr.trace((Object)this, (String)("Not serializable object " + o + " - skip."), (int)TraceMgr.DEFAULT_TRACE_LEVEL);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.current < this.size();
        }

        public Object nextElement() throws NoSuchElementException {
            try {
                return this.get(this.current++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }
    }

    public static class SerializableCookie
    extends MyCookie
    implements Serializable {
        private static final long serialVersionUID = 123L;
        private String myName = null;
        private String myValue = null;

        public SerializableCookie() {
        }

        public SerializableCookie(Cookie cookie) {
            super(cookie.getName(), cookie.getValue());
            this.setComment(cookie.getComment());
            if (cookie.getDomain() != null) {
                this.setDomain(cookie.getDomain());
            }
            this.setMaxAge(cookie.getMaxAge());
            this.setPath(cookie.getPath());
            this.setSecure(cookie.getSecure());
            this.myName = cookie.getName();
            this.myValue = cookie.getValue();
        }

        public String getName() {
            if (this.myName != null) {
                return this.myName;
            }
            return super.getName();
        }

        public String getValue() {
            if (this.myValue != null) {
                return this.myValue;
            }
            return super.getValue();
        }
    }

    public static class MyCookie
    extends Cookie {
        public MyCookie() {
            super("", "");
        }

        public MyCookie(String a, String b) {
            super(a, b);
        }
    }
}

