/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.i18n;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.i18n.I18NKeys;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;

public class I18NUtils {
    public static final String BASE_NAME = "i18n.ajaxswing_messages";
    private static ClassLoader classLoader = null;

    public static ClassLoader getClassLoader() {
        if (classLoader == null) {
            try {
                classLoader = I18NUtils.createI18NClassLoader();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return classLoader;
    }

    public static String getMessage(I18NKeys key, Locale userLocale) {
        ResourceBundle rb = ResourceBundle.getBundle(BASE_NAME, userLocale, I18NUtils.getClassLoader());
        return rb.getString(key.getKey());
    }

    public static Locale getPreferredBrowserLocale(HttpServletRequest request) {
        String acceptLanguage = request.getHeader("Accept-Language");
        String targetLocale = I18NUtils.getPreferredLanguage(acceptLanguage);
        if (targetLocale != null) {
            return I18NUtils.createLocale(targetLocale);
        }
        TraceMgr.trace((String)"WARNING! Browser locale is NULL", (int)6);
        return null;
    }

    public static Locale getApplicationLocale(AppProperties props, HttpServletRequest request) {
        Boolean useBrowserlocale = props.getBooleanProperty("agent.useBrowserLocale", false);
        Locale browserLocale = I18NUtils.getPreferredBrowserLocale(request);
        Locale targetLocale = null;
        if (useBrowserlocale.booleanValue() && browserLocale != null) {
            targetLocale = browserLocale;
        } else {
            String localeStr = props.getProperty("agent.defaultLocale", Locale.getDefault().toString());
            targetLocale = I18NUtils.createLocale(localeStr);
        }
        TraceMgr.trace((String)String.format("useBrowserlocale = %s, browserLocale = %s, targetLocale = %s", useBrowserlocale, browserLocale, targetLocale), (int)10);
        return targetLocale;
    }

    public static String getPreferredLanguage(String acceptLanguageHeader) {
        String[] locales;
        if (acceptLanguageHeader != null && (locales = acceptLanguageHeader.split(",")).length > 0) {
            TraceMgr.trace((String)String.format("Preferred Browser Locale is %S", locales[0]), (int)10);
            return locales[0];
        }
        TraceMgr.trace((String)"WARNING! Browser locale is NULL", (int)6);
        return null;
    }

    public static String getPrefferedLanguage(ClientAgent clientAgent) {
        String preferredLanguage = I18NUtils.getPreferredLanguage((String)clientAgent.getRequestData().getHeaders().get("accept-language"));
        TraceMgr.trace((String)String.format("Preffered Browser Language is %s", preferredLanguage), (int)10);
        return preferredLanguage;
    }

    public static ClassLoader createI18NClassLoader() throws MalformedURLException {
        File file = new File(Utilities.getConfDir());
        return new URLClassLoader(new URL[]{file.toURL()});
    }

    public static Locale createLocale(String localeStr) {
        if (localeStr == null) {
            return null;
        }
        localeStr = StringEscapeUtils.escapeHtml(localeStr);
        Locale result = null;
        localeStr = localeStr.replace('-', '_');
        String[] params = localeStr.split("_");
        switch (params.length) {
            case 1: {
                result = new Locale(params[0]);
                break;
            }
            case 2: {
                result = new Locale(params[0], params[1]);
                break;
            }
            case 3: {
                result = new Locale(params[0], params[1], params[2]);
                break;
            }
            default: {
                result = new Locale(params[0], params[1], params[2]);
            }
        }
        return result;
    }

    public static void reloadResourceBundles() {
        classLoader = null;
    }
}

