/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.laf.ui;

import java.awt.AWTMethods;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRootPaneUI;

public class AjaxSwingRootPaneUI
extends MetalRootPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new AjaxSwingRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("iconImage") || propertyName.equals("windowDecorationStyle")) {
            JRootPane root = null;
            if (e.getSource() instanceof Window) {
                root = SwingUtilities.getRootPane((Window)e.getSource());
            } else if (e.getSource() instanceof JRootPane) {
                root = (JRootPane)e.getSource();
            }
            if (root != null && root.getLayeredPane() != null) {
                for (int i = 0; i < root.getLayeredPane().getComponentCount(); ++i) {
                    Component comp = root.getLayeredPane().getComponent(i);
                    String name = comp.getClass().getSimpleName();
                    if ("MetalInternalFrameTitlePane".equals(name)) {
                        this.lightenButtons((JComponent)comp);
                    }
                    if (!"MetalTitlePane".equals(name)) continue;
                    this.lightenButtons((JComponent)comp);
                }
            }
        }
    }

    private void lightenButtons(JComponent comp) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            JComponent button;
            if (comp.getComponent(i) instanceof JButton) {
                button = (JButton)comp.getComponent(i);
                ((AbstractButton)button).setContentAreaFilled(false);
                if (((AbstractButton)button).getIcon() instanceof ImageIcon) {
                    if (((AbstractButton)button).getIcon().toString().contains("creamtec/ajaxswing/laf/icons/empty.gif")) {
                        button.setVisible(false);
                    } else {
                        button.setVisible(true);
                    }
                }
            }
            if (!(comp.getComponent(i) instanceof JMenuBar)) continue;
            button = (JMenuBar)comp.getComponent(i);
            Window window = SwingUtilities.getWindowAncestor(button.getRootPane());
            if (window == null) {
                button.setVisible(false);
                continue;
            }
            List icons = AWTMethods.getIconsImages((Window)window);
            if (icons == null) {
                button.setVisible(false);
                window.addPropertyChangeListener("iconImage", this);
                continue;
            }
            if (icons.size() == 0) {
                button.setVisible(false);
                window.addPropertyChangeListener("iconImage", this);
                continue;
            }
            button.setVisible(true);
        }
    }
}

