/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentManager;
import com.creamtec.ajaxswing.core.FastSubmitHandler;
import com.creamtec.ajaxswing.i18n.I18NKeys;
import com.creamtec.ajaxswing.i18n.I18NRenderUtils;
import com.creamtec.ajaxswing.i18n.I18NUtils;
import com.creamtec.ajaxswing.rendering.AbstractDocumentRenderer;
import com.creamtec.ajaxswing.rendering.Document;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxPage;
import com.creamtec.ajaxswing.v4.AjaxSwingV4Handler;
import com.creamtec.ajaxswing.v4.AjaxSwingV4Renderer;
import com.creamtec.ajaxswing.v4.render.DefaultComponentProcessor;
import com.creamtec.ajaxswing.v4.utils.ComponentUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class HTMLPageRenderer
extends AbstractDocumentRenderer {
    protected AjaxSwingV4Handler handler = null;
    private AjaxSwingV4Renderer renderer = null;

    public void appendHeader(HTMLPage page, List<Window> windows) {
        String refreshTag;
        String submitTag;
        StringBuilder header = page.getHeader();
        int routerAutoSubmit = page.getClientAgent().getProps().getIntProperty("router.autoSubmit", 0);
        if (routerAutoSubmit != 0) {
            StringBuilder timeoutString = new StringBuilder(100);
            timeoutString.append("setTimeout('v4Submit(\"/");
            timeoutString.append("update");
            timeoutString.append("/global/\");',");
            timeoutString.append(routerAutoSubmit * 1000 * 60);
            timeoutString.append(");\n");
            page.appendOnLoadScriptBody(timeoutString.toString());
        }
        if ((submitTag = page.getClientAgent().getWindowProperty(page.getTitle(), "autoSubmit")) != null) {
            StringBuffer timeoutString = new StringBuffer();
            timeoutString.append("setTimeout('v4Submit(\"/update/global/\");',");
            timeoutString.append(submitTag);
            timeoutString.append("*1000*60);\n");
            page.appendOnLoadScriptBody(timeoutString.toString());
        }
        if ((refreshTag = page.getClientAgent().getWindowProperty(page.getTitle(), "autoRefresh")) != null) {
            header.append("<meta http-equiv=\"Refresh\" content=\"");
            header.append(refreshTag);
            header.append("\">\n");
        }
        this.appendTimers(page);
        if (page.getRenderContext().errorMessage != null) {
            StringBuilder script = new StringBuilder();
            script.append("$(function() {\n");
            script.append("data = new Object();");
            script.append("data.errorMessageAutoRefreshText = '");
            script.append(page.getRenderContext().errorMessageAutoRefreshText);
            script.append("';data.errorRefreshTime = ");
            script.append(page.getRenderContext().errorRefreshTime);
            script.append(";showErrorMessageUI('");
            script.append(page.getRenderContext().errorMessage);
            script.append("',0,null,'");
            script.append(page.getRenderContext().errorMessageTitle);
            script.append("',data");
            script.append(");");
            script.append("});\n");
            page.appendHeaderScript(script.toString());
        }
    }

    public Document createDocument() throws Exception {
        return new HTMLPage();
    }

    public void initializeDocument(Document document) {
        super.initializeDocument(document);
        ClientAgent agent = ClientAgent.getCurrentInstance();
        if (agent != null) {
            this.handler = (AjaxSwingV4Handler)agent.getSession().get("v4handler");
            if (this.handler == null) {
                this.handler = new AjaxSwingV4Handler(agent);
                agent.getSession().put("v4handler", this.handler);
            }
            agent.addFastSubmitHandler((FastSubmitHandler)this.handler, "v4");
        } else {
            TraceMgr.trace((String)"ClientAgent is null while we render html page, the most reason of it asynchronous closing of threads", (int)5);
        }
        this.renderer = new AjaxSwingV4Renderer();
        this.defaultComponentRenderer = new DefaultComponentProcessor();
    }

    public Document renderDocument(ClientAgent agent, List<Window> windows) throws Exception {
        HTMLPage page = (HTMLPage)agent.getHTMLPage();
        page.appendHeaderScript(I18NRenderUtils.generateJavascriptHeader(agent.getUserLocale()));
        page.appendHeaderScript(this.generateConfigurationHeader(agent.getProps()));
        page.setDocumentRenderer(this);
        String title = agent.getProps().getProperty("html.pageTitle");
        Locale locale = null;
        locale = StringUtils.isNotEmpty(agent.getBrowserLocale()) ? I18NUtils.createLocale(agent.getBrowserLocale()) : agent.getUserLocale();
        if (title == null) {
            String string = title = windows.size() == 0 ? I18NUtils.getMessage(I18NKeys.MESSAGE_NO_VISIBLE_WINDOW_TEXT, locale) : ComponentUtils.getWindowTitle((Component)windows.get(0));
        }
        if (AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_STD) {
            title = title + " - Powered by AjaxSwing";
        }
        page.setTitle(title);
        this.appendHeader(page, windows);
        this.appendBody(page, windows, locale);
        return page;
    }

    protected void appendBody(HTMLPage page, List<Window> windows, Locale locale) throws Exception {
        StringBuilder body = page.getBody();
        body.append("\n<form id=\"AjaxSwingForm\" name=\"AjaxSwingForm\" method=\"POST\" onkeypress=\"return onFormKeyDown(event)\" action=\"");
        body.append(page.getClientAgent().getInitData().submitURL);
        body.append("\" enctype=\"multipart/form-data\"");
        body.append(">\n");
        body.append("<input type=\"hidden\" name=\"__csrfToken\" value=\"");
        body.append(page.getClientAgent().getCsrfToken());
        body.append("\"/>");
        body.append("<div id=\"rootContainer\" style=\"position:relative;left:0px;top:0px;width:100%;height:100%;z-index:1;overflow:visible\" class=\"desktop\">\n");
        for (Window window : windows) {
            try {
                ClientAgentManager.setMyAgent((Object)Thread.currentThread(), (ClientAgent)page.getClientAgent());
                this.renderWindow((Document)page, window);
            }
            catch (Exception ex) {
                TraceMgr.trace((String)"FATAL: Rendering failed for window", (Throwable)ex);
            }
        }
        if (windows.size() == 0) {
            body.append("<div id=\"NoWindowsVisible\"><script type=\"text/javascript\">setUpdateInterval(4)</script>");
            body.append("<div class='dialog border' style='font-size:20px;font-family:arial,helvetica;padding:30px;margin:200px;white-space:nowrap;border:1px dashed gray;text-align:center;'>");
            body.append(I18NUtils.getMessage(I18NKeys.MESSAGE_NO_VISIBLE_WINDOW_TEXT, locale));
            body.append("</div>");
            body.append("</div>");
        }
        if (AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_STD) {
            this.addWatermark(body, page);
        }
        body.append("</div>\n");
        body.append("</form>\n\n");
    }

    private void addWatermark(StringBuilder body, HTMLPage page) {
        String text = "Powered by AjaxSwing";
        String normalShadow = "text-shadow: -1px -1px 1px #fff, 1px 1px 1px #000  !important;";
        String title = "AjaxSwing is a web deployment platform for Java Swing applications.";
        body.append("<div ");
        body.append("style='position: fixed !important; bottom: 0px !important; right: 0px !important; z-index: 1000 !important; overflow:hidden;");
        body.append("padding: 1em !important;");
        body.append(normalShadow);
        body.append("'>");
        body.append("<a href=\"http://creamtec.com/products/ajaxswing\"");
        body.append(" style='color: #E9E9E9 !important; ");
        body.append("font-weight: bold; text-decoration: none !important; font-size:150%  !important'");
        body.append("title=\"");
        body.append(title);
        body.append("\">");
        body.append("<div style='  opacity: 0.6 !important;");
        if (page.getClientAgent().isBrowserIE()) {
            if (page.getClientAgent().getBrowserVersion() < 7.0f) {
                body.append("-ms-filter:alpha(opacity=60) !important;");
            } else {
                body.append("filter:alpha(opacity=60) !important;");
            }
            body.append("position: absolute !important;");
        }
        body.append("'>");
        body.append(text);
        body.append("</div>");
        if (page.getClientAgent().isBrowserIE()) {
            body.append("<div style='color: #333 !important; display: inline-block !important; zoom: 1 !important;");
            if (page.getClientAgent().getBrowserVersion() < 7.0f) {
                body.append("-ms-filter:\"progid:DXImageTransform.Microsoft.Blur(makeShadow=true, pixelRadius=2, shadowOpacity=0.3)\" !important;");
            } else {
                body.append("filter:progid:DXImageTransform.Microsoft.Blur(makeShadow=true, pixelRadius=2, shadowOpacity=0.3) !important;");
            }
            body.append("'>");
            body.append(text);
            body.append("</div>");
        }
        body.append("</a>");
        body.append("</div>\n");
    }

    protected void renderWindow(Document page, Window window) throws Exception {
        AjaxPage ajaxPage;
        super.renderWindow(page, window);
        try {
            window.validate();
        }
        catch (Exception ex) {
            TraceMgr.trace((Object)((Object)this), (String)"Fail during window.validate(): ", (Throwable)ex);
        }
        if (page instanceof AjaxPage) {
            ajaxPage = (AjaxPage)page;
            ajaxPage.startInterval(window);
        }
        this.renderer.renderComponent((HTMLPage)page, window, this.handler);
        if (page instanceof AjaxPage) {
            ajaxPage = (AjaxPage)page;
            ajaxPage.endInterval(window);
        }
    }

    private void appendTimers(HTMLPage page) {
        boolean keepAlive = "true".equals(page.getClientAgent().getWindowProperty(page.getTitle(), "session.keepAlive"));
        int updateInterval = page.getClientAgent().getUpdateBrowserInterval();
        if (keepAlive || updateInterval != 0) {
            StringBuffer jsString = new StringBuffer();
            jsString.append("ajaxSwingKeepSessionAlive = ");
            jsString.append(keepAlive ? "true" : "false");
            jsString.append(";\n");
            jsString.append("$(function(){setUpdateInterval(");
            jsString.append(updateInterval);
            jsString.append(")});\n");
            page.appendHeaderScript(jsString.toString());
        }
    }

    private String generateConfigurationHeader(AjaxSwingProperties props) {
        String CONFIGURATION_PREFIX = "browser.";
        StringBuilder sb = new StringBuilder();
        sb.append("var configurationBundle = new Object();\n");
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : props.entrySet()) {
            if (!((String)entry2.getKey()).startsWith("browser.")) continue;
            sb.append(String.format("configurationBundle['%s']='%s';\n", entry2.getKey(), entry2.getValue()));
        }
        sb.append(String.format("configurationBundle['%s']='%s';\n", "agent.productionMode", props.getBooleanProperty("agent.productionMode", true)));
        sb.append(String.format("configurationBundle['%s']='%s';\n", "agent.allowTextSelection", props.getBooleanProperty("agent.allowTextSelection", false)));
        return sb.toString();
    }

    public String getWindowTitle(Frame window) {
        String title;
        String string = title = window == null ? "No windows visible" : window.getTitle();
        if (AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_STD) {
            title = title + " - Powered by AjaxSwing";
        }
        return title;
    }
}

