/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html.positioned;

import com.creamtec.ajaxswing.ServletUtils;
import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.Document;
import com.creamtec.ajaxswing.rendering.html.HTMLPageRenderer;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxPage;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxResponse;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;

public class AjaxPageRenderer
extends HTMLPageRenderer {
    @Override
    public Document createDocument() throws Exception {
        return new AjaxPage();
    }

    public void redirectoToStandardPage(ClientAgent agent, int status, Throwable ex) throws Exception {
        AjaxPage page = (AjaxPage)agent.getHTMLPage();
        if (ex != null) {
            String errorMessage = "";
            if (!agent.getProps().getBooleanProperty("agent.productionMode", true)) {
                errorMessage = ex instanceof AjaxSwingException ? ex.getMessage() : TraceMgr.getExceptionText((String)"Failed with exception", (Throwable)ex);
            }
            agent.getResponseData().setErrorMessage(errorMessage);
        }
        if (agent.getExitPage() != null) {
            agent.getProps().setProperty("html.exitPageURL", agent.getExitPage());
        }
        String themeDocsUrls = page == null ? "/Light_docs" : page.getThemeDocsURL();
        String redirectURL = ServletUtils.getStandardPageURL(status, themeDocsUrls, (AppProperties)agent.getProps(), agent.getUserLocale());
        agent.getResponseData().setRedirectURL(redirectURL);
        String submitURL = page == null ? agent.getInitData().getSubmitURL() : page.getSubmitURL();
        agent.getResponseData().setSubmitURL(submitURL);
        agent.getResponseData().setStatus(status);
        AjaxResponse response = new AjaxResponse();
        response.setRedirectURL(redirectURL);
        if (status != 1 || !agent.getProps().getBooleanProperty("agent.productionMode", true)) {
            // empty if block
        }
        agent.getResponseData().setHtmlPageBytes(page.getJsonSerializer().writeValueAsString((Object)response).getBytes("UTF8"));
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace((Object)((Object)this), (String)("Redirecting to standard page with URL " + redirectURL), (int)6);
        }
    }
}

