/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html.positioned;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.CellRendererPane;
import org.apache.commons.lang.StringUtils;

public class ComponentState {
    private String componentId;
    private String parentId;
    private int action;
    private String html;
    private String javaScript;
    public static final int UNCHANGED = 0;
    public static final int DELETE = 1;
    public static final int INSERT = 2;
    public static final int UPDATE = 3;

    public static String getActionDescription(int state) {
        switch (state) {
            case 0: {
                return "UNCHANGED";
            }
            case 1: {
                return "DELETE";
            }
            case 2: {
                return "INSERT";
            }
            case 3: {
                return "UPDATE";
            }
        }
        return "UNKNOWN";
    }

    public ComponentState(String componentId) {
        this.componentId = componentId;
    }

    public ComponentState(Object component, HTMLPage page) {
        this(component, page, "");
    }

    public ComponentState(Object component, HTMLPage page, String namePostfix) {
        if (component instanceof String) {
            this.setComponentId((String)component);
        } else if (component instanceof Component) {
            this.setComponentId(NameUtils.getComponentName((Object)component, (String)namePostfix));
            Component comp = (Component)component;
            if (comp instanceof Window) {
                this.setParentId("rootContainer");
            } else {
                String parentId = AjaxSwingProperties.getClientProperty((Object)comp, (String)"componentParentId");
                if (StringUtils.isNotBlank(parentId)) {
                    this.setParentId(parentId);
                } else {
                    Container parent = comp.getParent();
                    if (parent != null && "com.jidesoft.pivot.HeaderExpandablePanel".equals(parent.getClass().getCanonicalName())) {
                        parent = parent.getParent();
                        TraceMgr.trace((String)("We got case when parent component is com.jidesoft.pivot.HeaderExpandablePanel, that doesn't paint real div, so we take parent of parent component as parent " + parent), (int)6);
                    }
                    if (parent != null && parent instanceof CellRendererPane) {
                        parent = parent.getParent();
                    }
                    if (parent != null) {
                        this.setParentId(NameUtils.getComponentName((Object)parent));
                    }
                }
            }
        } else {
            throw new AjaxSwingException("Unexpected component type " + component.getClass() + ", component = " + component);
        }
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String id) {
        this.componentId = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getJavaScript() {
        return this.javaScript;
    }

    public void setJavaScript(String javaScript) {
        this.javaScript = javaScript;
    }
}

