/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.ui;

import com.creamtec.ajaxswing.core.LicenseManager;
import com.creamtec.ajaxswing.gui.peer.ClientAgentBase;
import com.creamtec.ajaxswing.ui.AjaxSwingConsole;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.registry.Registry;
import javax.swing.JOptionPane;

public class WebServerManager {
    boolean webServerRunning = false;
    boolean firstTime = true;
    AjaxSwingConsole console;
    boolean windows = true;
    Registry registry;
    public static final String START_SERVER_CMDLINE_WIN = "..\\bin\\startServer.bat";
    public static final String STOP_SERVER_CMDLINE_WIN = "..\\bin\\stopServer.bat";
    public static final String START_SERVER_CMDLINE_UNIX = "../bin/startServer.sh";
    public static final String STOP_SERVER_CMDLINE_UNIX = "../bin/stopServer.sh";

    public WebServerManager(AjaxSwingConsole console) throws Exception {
        TraceMgr.trace((Object)this, (String)"constructor");
        this.console = console;
        this.windows = System.getProperty("os.name").indexOf("indows") != -1;
        TraceMgr.trace((Object)this, (String)("OS windows? " + this.windows));
        this.webServerRunning = this.checkIfWebServerRunning();
        this.initLicense();
    }

    void startWebServer() {
        try {
            int attempt;
            TraceMgr.trace((Object)this, (String)"startWebServer");
            if (this.webServerRunning) {
                this.console.showStatus("Web server is running");
                return;
            }
            if (this.firstTime && !this.windows) {
                this.firstTime = false;
            }
            this.console.showStatus("Starting web server...");
            Utilities.execProcess((String)this.getStartServerCmdLine(), (boolean)true);
            for (attempt = 5; attempt > 0 && !this.checkIfWebServerRunning(); --attempt) {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            if (attempt > 0) {
                this.webServerRunning = true;
                this.console.showStatus("Web server is running");
            } else {
                this.console.showStatus("Failed to start web server");
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)"Failed to run test web server", (Throwable)x);
            JOptionPane.showMessageDialog(this.console, TraceMgr.getExceptionText((String)"Failed to run test web server process", (Throwable)x), "Error", 0);
        }
    }

    void stopWebServer() {
        TraceMgr.trace((Object)this, (String)"stopWebServer");
        try {
            if (this.checkIfWebServerRunning()) {
                this.console.showStatus("Stopping web server...");
                Utilities.execProcess((String)this.getStopServerCmdLine(), (boolean)true);
            }
            this.console.showStatus("Web server stopped");
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)"Failed to stop test web server", (Throwable)x);
            JOptionPane.showMessageDialog(this.console, TraceMgr.getExceptionText((String)"Failed to run test web server process", (Throwable)x), "Error", 0);
        }
        this.webServerRunning = false;
    }

    String getStartServerCmdLine() {
        return this.windows ? START_SERVER_CMDLINE_WIN : START_SERVER_CMDLINE_UNIX;
    }

    String getStopServerCmdLine() {
        return this.windows ? STOP_SERVER_CMDLINE_WIN : STOP_SERVER_CMDLINE_UNIX;
    }

    void setServerDirty(boolean dirty) {
        if (dirty && this.webServerRunning) {
            this.stopWebServer();
        }
    }

    public boolean isServerRunning() {
        return this.webServerRunning;
    }

    public void initLicense() {
        AppProperties licenseProps = ClientAgentBase.initLicense((boolean)true);
        LicenseManager.initInstance((AppProperties)licenseProps);
    }

    public boolean checkIfWebServerRunning() {
        try {
            this.console.showStatus("Checking if web server is running...");
            URL url = new URL("http://localhost:8040");
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            is.close();
            this.console.showStatus("Web server is running");
            return true;
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, (String)("WebServer check failed with exception " + x.getMessage()));
            this.console.showStatus("Web server is not running");
            return false;
        }
    }
}

