/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4;

import com.creamtec.ajaxswing.core.AjaxSwingUnderlineCharAtHint;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.HtmlGraphics;
import com.creamtec.ajaxswing.v4.RenderingGraphics;
import com.creamtec.ajaxswing.v4.utils.ReflectionUtils;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRenderingGraphics
extends HtmlGraphics {
    static HashMap<String, String> paintUrls = new HashMap();
    protected Rectangle clip = null;
    protected Shape clipShape = null;
    protected Color diagonalBackground = Color.WHITE;
    protected int translateX = 0;
    protected int translateY = 0;
    protected Integer underlineCharAt;
    protected int translateXCompensation = 0;
    protected boolean verticalRotate = false;
    protected boolean compensateY = false;
    protected boolean correctDrawPosition = false;
    protected int offset = 0;
    private Color background = Color.WHITE;
    private Color color = Color.BLACK;
    private Composite composite;
    private Font font = defaultFont;
    private FontRenderContext fontRenderContext = null;
    private RenderingHints localRenderingHints;
    private Rectangle myClip = null;
    private Paint paint = null;
    private final RenderingGraphics parent = null;
    private Rectangle parentClip = null;
    private Stroke stroke;

    public AbstractRenderingGraphics(HTMLPage page) {
        super(page);
        this.clip = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.myClip = (Rectangle)this.clip.clone();
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint oldPaint = this.paint;
        Color oldColor = this.color;
        this.color = this.background;
        this.paint = null;
        this.fillRect(x, y, width, height);
        this.color = oldColor;
        this.paint = oldPaint;
    }

    @Override
    public void clip(Shape s) {
        this.setClip(s);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setClip(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Shape getClip() {
        return this.clip == null ? null : (Shape)this.clip.clone();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip == null ? null : (Rectangle)this.clip.clone();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.fontRenderContext == null) {
            AffineTransform localAffineTransform = new AffineTransform();
            this.fontRenderContext = new FontRenderContext(localAffineTransform, false, false);
        }
        return this.fontRenderContext;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        if (this.localRenderingHints == null) {
            this.localRenderingHints = new RenderingHints(null);
        }
        return this.localRenderingHints;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform t = new AffineTransform();
        t.translate(this.translateY, this.translateY);
        return t;
    }

    public Point getTranslate() {
        return new Point(this.translateX, this.translateY);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public void rotate(double theta) {
        boolean bl = theta == 0.0 ? !this.correctDrawPosition : (this.correctDrawPosition = this.correctDrawPosition);
        if (Math.abs(Math.sin(theta)) == 1.0) {
            boolean bl2 = this.verticalRotate = theta >= 0.0;
            this.compensateY = theta == Math.abs(4.71238898038469) ? theta >= 0.0 : this.compensateY;
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
    }

    @Override
    public void scale(double sx, double sy) {
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        this.diagonalBackground = color == null ? Color.WHITE : color;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.clipShape = null;
        if (this.clip == null) {
            this.clip = new Rectangle();
            this.myClip = (Rectangle)this.clip.clone();
        }
        this.clip.setBounds(x, y, width, height);
        if (this.parentClip != null) {
            this.myClip = (Rectangle)this.clip.clone();
            this.clip.translate(this.translateX, this.translateY);
            this.clip = this.parentClip.intersection(this.clip);
            this.clip.translate(-this.translateX, -this.translateY);
        }
    }

    @Override
    public void setClip(Shape clip) {
        this.clipShape = null;
        if (clip instanceof Rectangle) {
            Rectangle r = (Rectangle)((Rectangle)clip).clone();
            this.setClip(r.x, r.y, r.width, r.height);
        } else {
            this.clipShape = clip;
        }
        if (clip == null) {
            this.clip = null;
            this.myClip = null;
        }
    }

    @Override
    public void setColor(Color c) {
        this.color = c == null ? Color.BLACK : c;
        this.paint = this.color;
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (paint == null || this.paint == paint) {
            return;
        }
        this.paint = paint;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintKey instanceof AjaxSwingUnderlineCharAtHint) {
            if (hintValue instanceof Integer) {
                this.underlineCharAt = (Integer)hintValue;
            }
            if (hintValue == null) {
                this.underlineCharAt = null;
            }
        }
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    @Override
    public void setTransform(AffineTransform Tx) {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void shear(double shx, double shy) {
    }

    @Override
    public void transform(AffineTransform Tx) {
    }

    @Override
    public void translate(double tx, double ty) {
        this.translateX += (int)tx;
        this.translateY += (int)ty;
        if (this.clip != null) {
            this.translateClip(-((int)tx), -((int)ty));
        }
    }

    @Override
    public void translate(int x, int y) {
        this.translateX = x < 0 ? (this.translateX += x + this.translateXCompensation) : (this.translateX += x);
        this.translateY += y;
        if (this.clip != null) {
            this.translateClip(-x, -y);
        }
    }

    public void translateNoClip(int x, int y) {
        this.translateX += x;
        this.translateY += y;
        if (this.parentClip != null) {
            this.parentClip.translate(x, y);
        }
    }

    @Override
    protected void cloneFrom(HtmlGraphics g) {
        super.cloneFrom(g);
        if (g instanceof AbstractRenderingGraphics) {
            AbstractRenderingGraphics graphics = (AbstractRenderingGraphics)g;
            if (graphics.clip != null) {
                this.clip = (Rectangle)graphics.clip.clone();
                this.myClip = (Rectangle)this.clip.clone();
            }
            this.translateX = graphics.translateX;
            this.translateY = graphics.translateY;
            this.color = graphics.color;
            this.background = graphics.background;
            this.diagonalBackground = graphics.diagonalBackground;
            this.font = graphics.font;
            if (graphics.clip != null) {
                this.parentClip = (Rectangle)graphics.clip.clone();
                this.parentClip.translate(this.translateX, this.translateY);
            }
        }
    }

    protected String getCachedPaint(Paint paint) {
        String className = paint.getClass().getCanonicalName();
        String key = "paint";
        if ("java.awt.GradientPaint".equals(className)) {
            GradientPaint g = (GradientPaint)paint;
            key = key + g.getColor1().getRGB();
            key = key + g.getColor2().getRGB();
        }
        if ("org.apache.batik.ext.awt.LinearGradientPaint".equals(className)) {
            Color[] colors = (Color[])ReflectionUtils.invokeMethod(paint, "getColors");
            for (int i = 0; i < colors.length; ++i) {
                key = key + colors[i].getRGB();
            }
        }
        if ("java.awt.GradientPaint".equals(className) || "org.apache.batik.ext.awt.LinearGradientPaint".equals(className)) {
            String imageUrl = paintUrls.get(key);
            if (imageUrl != null) {
                return imageUrl;
            }
            Rectangle userBounds = new Rectangle(0, 0, 128, 128);
            PaintContext pc = paint.createContext(ColorModel.getRGBdefault(), userBounds, userBounds, new AffineTransform(), this.getRenderingHints());
            Raster r = pc.getRaster(userBounds.x, userBounds.y, userBounds.width, userBounds.height);
            BufferedImage img = new BufferedImage(pc.getColorModel(), (WritableRaster)r, true, null);
            imageUrl = this.getImageUrl(img, true);
            if (imageUrl.contains("?")) {
                imageUrl = imageUrl.substring(0, imageUrl.lastIndexOf(63));
            }
            paintUrls.put(key, imageUrl);
        }
        return null;
    }

    protected int getTranslateX() {
        return this.translateX + (this.parent == null ? 0 : this.parent.getTranslateX());
    }

    protected int getTranslateY() {
        return this.translateY + (this.parent == null ? 0 : this.parent.getTranslateY());
    }

    protected Color rewriteColor(Color c) {
        if (c == null) {
            return null;
        }
        if ("ars".equals(ClientAgent.getCurrentInstance().getAppName())) {
            c = this.rewriteColor(c, new Color(0xC4C4C4), new Color(0xEEEEEE));
        }
        return c;
    }

    private Color rewriteColor(Color c, Color from, Color to) {
        int db;
        int dg;
        int dr = c.getRed() - from.getRed();
        long d = dr * dr + (dg = c.getGreen() - from.getGreen()) * dg + (db = c.getBlue() - from.getBlue()) * db;
        if (d < 1200L) {
            return new Color(Math.min(to.getRed() + dr, 255), Math.min(to.getGreen() + dg, 255), Math.min(to.getBlue() + db, 255));
        }
        return c;
    }

    private void translateClip(int x, int y) {
        if (this.myClip != null) {
            this.clip = (Rectangle)this.myClip.clone();
            this.myClip.translate(x, y);
        }
        this.clip.x += x;
        this.clip.y += y;
        if (this.parentClip != null) {
            this.clip.translate(this.translateX, this.translateY);
            this.clip = this.parentClip.intersection(this.clip);
            this.clip.translate(-this.translateX, -this.translateY);
        }
        if (this.clip.x < 0) {
            this.clip.x = 0;
        }
        if (this.clip.y < 0) {
            this.clip.y = 0;
        }
    }
}

