/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4.render;

import com.creamtec.ajaxswing.rendering.TemplateEngine;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.rendering.html.HTMLPageRenderer;
import com.creamtec.ajaxswing.v4.ComponentGraphics;
import com.creamtec.ajaxswing.v4.render.ComponentRenderer;
import com.creamtec.ajaxswing.v4.render.TemplateRenderer;
import com.creamtec.core.TraceMgr;
import freemarker.template.Template;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TemplateRendererImpl
implements TemplateRenderer {
    protected Template template;

    public TemplateRendererImpl() {
    }

    public TemplateRendererImpl(String templateName) throws Exception {
        this.setTemplateName(templateName);
    }

    public void initialize() {
    }

    public void renderComponent(ComponentGraphics graphics, Component component) throws Exception {
        Map<String, Object> data = this.getTemplateData(graphics.getPage(), component);
        if (this.template == null) {
            String fileName = File.separator + this.getTargetClassName(graphics.getPage(), component) + ".html";
            try {
                this.setTemplateName("custom-component" + fileName);
            }
            catch (FileNotFoundException ex) {
                this.setTemplateName("default-component" + fileName);
            }
        }
        StringWriter writer = new StringWriter();
        this.template.process(data, (Writer)writer);
        graphics.append(writer.toString());
    }

    public void setTemplateName(String templateName) throws Exception {
        this.template = TemplateEngine.getInstance().getConfiguration().getTemplate(templateName);
    }

    protected Map<String, Object> getTemplateData(HTMLPage page, Object component) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("page", (Object)page);
        root.put("agent", page.getClientAgent());
        root.put("component", component);
        if (component instanceof Component) {
            Component comp = (Component)component;
            Rectangle bounds = comp.getBounds();
            root.put("bounds", bounds);
            root.put("id", page.getComponentName(comp));
        }
        return root;
    }

    private String getTargetClassName(HTMLPage page, Object component) {
        ComponentRenderer renderer;
        Class<?> cls;
        HTMLPageRenderer doc = page.getPageRenderer();
        for (cls = component.getClass(); cls != Object.class && (renderer = doc.getComponentRenderer(cls.getName())) != this; cls = cls.getSuperclass()) {
        }
        if (cls == null) {
            TraceMgr.trace((String)("Failed to find class name for current renderer. Component: " + component.getClass().getName()));
        }
        return cls.getName().toString();
    }
}

