/**
 * 
 */
package com.creamtec.ajaxswing.support.components;

import java.io.IOException;
import java.net.URL;

import javax.swing.text.EditorKit;

import com.creamtec.ajaxswing.AjaxSwingManager;
import com.creamtec.ajaxswing.core.ClientAgent;

/**
 */
public class JEditorPane extends javax.swing.JEditorPane {
    boolean isAjaxSwingRunning = AjaxSwingManager.isAjaxSwingRunning();
    String url;
    String text;

    public JEditorPane() {
    }

    /**
     * @param initialPage
     * @throws IOException
     */
    public JEditorPane(URL initialPage) throws IOException {
        if (this.isAjaxSwingRunning) {
            this.url = initialPage.toExternalForm();
        }
        else 
            super.setPage(initialPage);
    }

    /**
     * @param url
     * @throws IOException
     */
    public JEditorPane(String url) throws IOException {
        if (this.isAjaxSwingRunning) {
            this.url = url;
        }
        else 
            super.setPage(url);
    }

    /**
     * @param type
     * @param text
     */
    public JEditorPane(String type, String text) {
        setContentType(type);
        if (this.isAjaxSwingRunning) {
            this.text = text;
        }
        else {
            setText(text);
            
        }
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public EditorKit getEditorKitForContentType(String type) {
        if (this.isAjaxSwingRunning)
            return null;
        return super.getEditorKitForContentType(type);
    }

    public String getText() {
        if (this.isAjaxSwingRunning)
            return text;
        else
            return super.getText();
    }

    public void setText(String text) {
        if (this.isAjaxSwingRunning) {
            this.text = text;
            //sometimes needed for size calculation on component
            //and we can't get window title when not in renderer
            ClientAgent agent = ClientAgent.getCurrentInstance();
            Object valueAll = agent.getComponentProperty(this, "passAllText");
			if((text != null) && (text.indexOf("<br>") != -1)) {
				super.setText(text);
			} else {
				if((valueAll != null) && ("true".equals(valueAll))) {
					super.setText(text);
				} else {
				Object value = agent.getComponentProperty(this, "passText");
					if(value != null) {
						String[] parts = value.toString().split("\\|");
						for(int i=0;i<parts.length;i++)
						if(text.indexOf(parts[i]) != -1)	
							super.setText(text);
					}
				}
			}
            // Notify repaint manager so browser can be updated when needed
            agent.getRepaintManager().addInvalidComponent(this);
        }
        else
            super.setText(text);
    }

}
