package com.creamtec.ajaxswing.support.old;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingConstants;

import com.creamtec.ajaxswing.AjaxSwingConstants;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.validation.Validatable;

/**
 * Provides utility methods for working with Swing components 
 */
public class ComponentUtils {
    private static Class[] setComponentPopupMenuArgTypes = {JPopupMenu.class};

    /**
     * HTML attributes specified for Swing component are automatically appended to the rendered HTML 
     * element that represents the component. For instance, calling
     * ComponentUtils.getHtmlAttributes(myButton).put("tabindex", "1") for a button that is 
     * represented with <input> HTML element will result in the following HTML
     * <i><input type="button" tabIndex="1"...></i> HTML attribute being added
     * @param component
     * @return map of HTML attributes associated with the given component
     */
    public static Map getHtmlAttributes(JComponent component) {
        Map attributes = (Map) component.getClientProperty(AjaxSwingConstants.HTML_ATTRIBUTES);
        if (attributes == null) {
            attributes = new HashMap();
            component.putClientProperty(AjaxSwingConstants.HTML_ATTRIBUTES, attributes);
        }
        return attributes;
    }
    
    public static JPopupMenu getPopupMenu(Component component) {
        try {
            // On JDK 1.5+ use getComponentPopupMenu method 
            Method method = component.getClass().getMethod("getComponentPopupMenu", null);
            return (JPopupMenu) method.invoke(component, null);
        } catch (Exception e) {
          
        }
        return null;
    }
    
    public static void setPopupMenu(Component component, JPopupMenu menu) {
        try {
            // On JDK 1.5+ use setComponentPopupMenu method 
            Method method = component.getClass().getMethod("setComponentPopupMenu", setComponentPopupMenuArgTypes);
            method.invoke(component, new Object[]{menu});
        } catch (Exception e) {
           
        }
    }
 /*   
    public static void setFileOpener(JComponent component, FileOpener fileOpener) {
        component.putClientProperty(AjaxSwingConstants.FILE_OPENER, fileOpener);
    }
    
    public static FileOpener getFileOpener(Component component) {
        FileOpener fileOpener = null;
        if (component instanceof JComponent) {
            fileOpener = (FileOpener) ((JComponent)component).getClientProperty(AjaxSwingConstants.FILE_OPENER);
        }
        
        if (fileOpener != null) {
            String value = ClientAgent.getCurrentInstance().getComponentProperty(component, AjaxSwingProperties.COMPONENT_BROWSE_CLIENT);
            // If the property is explicitly specified, it overrides the state of the component
            if (value != null && "false".equalsIgnoreCase(value)) {
                //TraceMgr.trace(ComponentUtils.class, "FileOpener ignored because browseClient=false", 4); XXX TraceMgr.trace
            	System.out.println("FileOpener ignored because browseClient=false");
                fileOpener = null;
            }
        }
        
        return fileOpener;
    }
  */  
    public static Validatable getValidationSpecs(Object component) {
        if(component instanceof JComponent) {
         
        }
        return null;
    }
    
    public static void setValidationSpecs(JComponent component, Validatable specs) {
       
    }
    
    public static boolean isJSliderNeedInvertion(JSlider jSlider) {
    	return (jSlider.getOrientation() == SwingConstants.HORIZONTAL && jSlider.getInverted()) ||
    		(jSlider.getOrientation() == SwingConstants.VERTICAL && !jSlider.getInverted());
    }
    
}