package com.creamtec.ajaxswing.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;

import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CustomControl extends JComponent {

    protected String text;
    protected JCheckBox chk3D;
    protected int offsetX = 50;


    public CustomControl()
    {
        this.chk3D = new JCheckBox("3D", true);
        this.chk3D.setText("3D");
        this.setLayout(null);
        this.chk3D.setBounds(2, 3, 42, 14);
        add(this.chk3D);

        this.chk3D.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                chk3D_actionPerformed(e);
            }
        });
    }

    public String getText()
    {
        return this.text;
    }

    public void setText(String text)
    {
        this.text = text;
    }


    public boolean is3D()
    {
        return this.chk3D.isSelected();
    }


    public void set3D(boolean is3D)
    {
        this.chk3D.setSelected(is3D);
    }


    public int getTextOffset() {
        return this.offsetX;
    }


    public void setTextOffset(int offset) {
        this.offsetX = offset;
    }


    public JCheckBox getCheckBox()
    {
        return this.chk3D;
    }


    public void paint (Graphics g)
    {
        super.paint(g);

        int offsetY = g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent() + 2;

        if (this.chk3D.isSelected()) {
            // Draw shade
            g.setColor(Color.white);
            g.drawString(this.text, offsetX + 1, offsetY + 1);
            g.setColor(Color.black);
        }

        // ..and the text
        g.drawString(this.text, offsetX + 0, offsetY);
    }


    public void chk3D_actionPerformed(ActionEvent e) {
        this.repaint();
    }

}