package com.creamtec.ajaxswing.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import com.creamtec.ajaxswing.support.ListSupport;

/**
 * Created 22.09.2008 15:08:41
 * <p>
 * Custom JList implementation which supports right-click context menu.
 * 
 * @author Alexander Kislitsyn
 *
 */
public class CustomList extends JList implements ListSupport
{
    private JPopupMenu menu;

    
	public CustomList()
	{
		this(new AbstractListModel() {
		              public int getSize() { return 0; }
		              public Object getElementAt(int i) { return "No Data Model"; }
		            });
	}
	
	public CustomList(ListModel model)
	{
		super(model);
		
		this.initProperties();
		this.initMenu();
	}
    
	protected void initProperties()
	{
		this.putClientProperty(ListSupport.ACTION_AUTOSCROLL, Boolean.TRUE);
		this.putClientProperty(ListSupport.ACTION_COLORIZE, Boolean.TRUE);
		this.putClientProperty(ListSupport.ACTION_COPY, Boolean.FALSE);
	}
	
    protected void initMenu() 
    {
    	this.menu = new JPopupMenu();
    	
    	final JCheckBoxMenuItem item1 = new JCheckBoxMenuItem("Autoscroll");
    	final JMenuItem item2 = new JMenuItem("Copy");
    	final JMenuItem item3 = new JMenuItem("Select All");
    	final JCheckBoxMenuItem item4 = new JCheckBoxMenuItem("Show color");
    	final JMenuItem item5 = new JMenuItem("Remove");

    	
        item1.setSelected(
        		((Boolean)this.getClientProperty(ListSupport.ACTION_AUTOSCROLL)).booleanValue());
        item1.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		putClientProperty(ListSupport.ACTION_AUTOSCROLL, Boolean.valueOf(item1.isSelected()));
        	}
        });

        item2.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
                String selection = getSelectedValue().toString();
                StringSelection data = new StringSelection(selection);
                Clipboard clipboard = 
                     Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
                
                // NOTE: Workaround with copy action
        		putClientProperty(ListSupport.ACTION_COPY, Boolean.TRUE);
        	}
        });
        
        item3.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		if (getSelectionMode() == ListSelectionModel.MULTIPLE_INTERVAL_SELECTION)
        		{
        			int size = getModel().getSize();
        			setSelectionInterval(0, size-1);
        		}
        		else
        		{
                    JOptionPane.showMessageDialog(null, "Selection mode for the selected JList component is not MULTIPLE_INTERVAL_SELECTION");
        		}
        	}
        });
        
        item4.setSelected(((Boolean)this.getClientProperty(ListSupport.ACTION_COLORIZE)).booleanValue());
        item4.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		putClientProperty(ListSupport.ACTION_COLORIZE, Boolean.valueOf(item4.isSelected()));
        	}
        });
        
        item5.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ListModel listModel = getModel();
                if (listModel instanceof DefaultListModel)
                {
                	DefaultListModel model = (DefaultListModel)listModel;
                    int[] indexes = getSelectedIndices();
                    for (int i = indexes.length - 1; i >= 0; i--)
                    {
                    	model.remove(indexes[i]);
                    }
                }
            }
        });

        this.menu.add(item1);
        this.menu.add(item2);
        this.menu.add(item3);
        this.menu.add(item4);
        this.menu.add(item5);
    }
    
	
	public JPopupMenu getContextMenu(int row)
	{
		return this.menu;
	}

    
}
