package com.creamtec.ajaxswing.ui;

import java.awt.Color;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class CustomToolTipLabel extends JLabel {
    
    protected JComponent toolTipContent;
    
    public CustomToolTipLabel() {
    }
    
    public CustomToolTipLabel(String text) {
        super(text);
    }
    
    public JComponent getToolTipContent() {
        return toolTipContent;
    }

    public void setToolTipContent(JComponent tooltipContent) {
        this.toolTipContent = tooltipContent;
    }

    public JToolTip createToolTip() {
        JToolTip tip = super.createToolTip();
        tip.setBackground(Color.YELLOW);
        tip.setForeground(Color.RED);
        tip.setTipText(this.getToolTipText());
        
        if(getToolTipContent() != null) {
            tip.setSize(getToolTipContent().getSize());
            tip.setPreferredSize(getToolTipContent().getPreferredSize());
            tip.add(getToolTipContent());
        }
        return tip;
    }
    
}
