package com.creamtec.ajaxswing.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.TreeSupport;
import com.creamtec.ajaxswing.ui.TreePanel.NodeData;

public class CustomTree extends JTree implements TreeSupport {
    protected JPopupMenu specialContextMenu = new JPopupMenu();

    public CustomTree(TreeModel newModel) {
        super(newModel);
        
        JMenu about = new JMenu("About a very long line");
        JMenuItem nothing = new JMenuItem("Do nothing");
        nothing.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Thanks for nothing");
            }
            
        });
        about.add(nothing);
        this.specialContextMenu.add(about);
        
        // Add special item
        JMenuItem item = new JMenuItem("Archive emails");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Emails Archived");
            }
        });
        this.specialContextMenu.add(item);
        
        JMenu help = new JMenu("Help");
        help.add(new JMenuItem("Do nothing"));
        
        this.specialContextMenu.add(help);
    }
        
    // TreeSupport methods
	public JPopupMenu getNodeContextMenu(TreeNode node) {
	    if (node != null && node instanceof DefaultMutableTreeNode) {
	        DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
	        if (mutableNode.getUserObject() != null && mutableNode.getUserObject() instanceof NodeData) {
	            NodeData nodeData = (NodeData) mutableNode.getUserObject();
	            if ("Inbox".equals(nodeData.text)) {
	                return this.specialContextMenu;
	            }
	        }
	    }
		return null;
	}

	// Use a custom icon for root node - implement this method for changes to the image in the browser (collapse/expand)
	public String getNodeImageBundleName(TreeNode node) {
	    if (node == getModel().getRoot()) {
	        if ("Windows".equals(ClientAgent.getCurrentInstance().getProps().get(AjaxSwingProperties.HTML_THEME))) 
	            return "custom";
	    }
        // Use default bundle
        return "default";
	}

    // Use a custom icon for root node - implement this method to set the correct initial image
	public String getNodeImagePath(TreeNode node, int imageIndex) {
        if (node == getModel().getRoot()) {
            if ("Windows".equals(ClientAgent.getCurrentInstance().getProps().get(AjaxSwingProperties.HTML_THEME))) 
                return CUSTOM_NODE_IMAGE_NAMES[imageIndex];
        }
        // Use default image name
        return null;
	}

	final static String[] CUSTOM_NODE_IMAGE_NAMES = { 
		"/images/custom_tree/Blank.gif", 
		"/images/custom_tree/Line.gif", 
		"/images/custom_tree/Item.gif", 
		"/images/custom_tree/LastItem.gif", 
		"/images/custom_tree/FolderOpen.gif", 
		"/images/custom_tree/FolderClosed.gif", 
		"/images/custom_tree/FolderLastOpen.gif", 
		"/images/custom_tree/FolderLastClosed.gif", 
		"/images/custom_tree/RootFolderOpen.gif", 
		"/images/custom_tree/RootFolderClosed.gif", 
		"/images/custom_tree/RootLastFolderOpen.gif", 
		"/images/custom_tree/RootLastFolderClosed.gif" 
	};

}
