package com.creamtec.ajaxswing.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.event.CellEditorListener;
import javax.swing.table.*;


public class JTableCellRenderer extends JButton implements TableCellRenderer, TableCellEditor, ActionListener {
    
    protected int row;
    protected int column;

    /**
     * Creates a investment table cell renderer.
     */
    public JTableCellRenderer() {
        this.addActionListener(this);
    }

    public Component getTableCellRendererComponent(JTable table, Object value,
                          boolean isSelected, boolean hasFocus, int row, int column) {

        setValue(value, column);
        this.row = row;
        this.column = column;

        return this;
    }


    protected void setValue(Object value, int col) {
        if (value != null) {
            if (value instanceof CellValue)
                setText(((CellValue)value).getText());
            else
                super.setText(value.toString());
        }
        else
            setText("");
    }

    public void actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(null, "Clicked button on row " + this.row + ", column " + this.column);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        setValue(value, column);
        this.row = row;
        this.column = column;

        return this;
    }

    public void addCellEditorListener(CellEditorListener l) {
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        return true;
    }
    
}