/**
 * Copyright 2000 by CreamTec, LLC. All rights reserved.
 */

package com.creamtec.ajaxswing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.creamtec.ajaxswing.AjaxSwingConstants;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.core.TraceMgr;


public class LoginDialog extends JDialog {
    // Use a custom class to test that derived classes are properly supported
    public static class LoginTextField extends JPasswordField {
    }

    boolean ok = false;

    JPanel panelMain = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel panelNorth = new JPanel();
    JPanel panelSouth = new JPanel();
    JButton btnCancel = new JButton();
    JButton btnOK = new JButton();
    JLabel lblUserName = new JLabel();
    JLabel lblPassword = new JLabel();
    JTextArea txfUser = new JTextArea();
    JTextField txfPassword = new LoginTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    CustomToolTipLabel lblDomain = new CustomToolTipLabel();
    JComboBox cmbDomain = new JComboBox();
    JList lstHosts = new JList();
    
    JEditorPane jTextDesc = new JEditorPane();
    CustomToolTipLabel lblHosts = new CustomToolTipLabel("Host");
    protected JCheckBox chkDisableAll = new JCheckBox();
    protected JCheckBox chkReadOnly = new JCheckBox();

    public LoginDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try  {
            jbInit();
//            this.setUndecorated(true);
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginDialog() {
        this(null, "Login Dialog with Custom Colors and ToolTips", true);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        panelMain.setLayout(borderLayout1);
        btnCancel.setBackground(new Color(230, 230, 128));
        btnCancel.setText("Cancel");
        btnCancel.setToolTipText("Press to Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                btnCancel_actionPerformed(e);
            }
        });
        btnOK.setBackground(new Color(230, 230, 128));
        btnOK.setText("OK");
        btnOK.setName("OKButton");
        btnOK.setToolTipText("Press to approve");
        btnOK.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                btnOK_actionPerformed(e);
            }
        });
        this.getRootPane().setDefaultButton(btnOK);
        
        
        jTextDesc.setEditable(false);
        jTextDesc.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                TraceMgr.trace(this, "mouseOver, e = " + e);
                JOptionPane.showMessageDialog(null, "Mouse over event received");
                LoginDialog.this.jTextDesc.removeMouseListener(this);
            }
        });
        jTextDesc.setContentType("text/html");
        jTextDesc.setText("<b>Hint:</b> you can type in any user name and password. Using " +
    "Domain combobox you can select a domain to login and from a listbox " +
    "below you can choose the host. The information you have selected " +
    "will be displayed in the main frame when you close the dialog");
        jTextDesc.setToolTipText("Description text");
        // Inform AjaxSwing that we are interested in mouse over event, not double click (default)
   
        
        panelNorth.setLayout(gridBagLayout1);
        lblUserName.setFont(new java.awt.Font("Dialog", 1, 12));
        lblUserName.setText("User Name");
        lblUserName.setHorizontalAlignment(JLabel.RIGHT);
        lblUserName.setForeground(Color.red);
        lblUserName.setToolTipText("Double click for event");
        lblUserName.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                TraceMgr.trace(this, "mouseClicked, e = " + e);
                String eventName = e.getClickCount() == 2? "double click": "click";
                JOptionPane.showMessageDialog(null, "Mouse " + eventName + " event received");
            }
            public void mousePressed(MouseEvent e) {
                TraceMgr.trace(this, "mousePressed, e = " + e);
            }
            public void mouseReleased(MouseEvent e) {
                TraceMgr.trace(this, "mouseReleased, e = " + e);
            }
        });
        
        lblPassword.setFont(new java.awt.Font("Dialog", 1, 12));
        lblPassword.setText("Password");
        lblPassword.setHorizontalAlignment(JLabel.RIGHT);
        lblPassword.setForeground(Color.red);
        lblPassword.setToolTipText("Click for event");
        lblPassword.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                TraceMgr.trace(this, "mouseClicked, e = " + e);
                String eventName = e.getClickCount() == 2? "double click": "click";
                JOptionPane.showMessageDialog(null, "Mouse " + eventName + " event received");
            }
        });
        // Inform AjaxSwing that we are interested in double clicks, not single clicks
  
        txfPassword.setBackground(new Color(230, 230, 128));
        txfPassword.setColumns(30);
        txfPassword.setToolTipText("Enter password here");
        txfUser.setName("UserNameTextField");
        txfUser.setBackground(new Color(230, 230, 128));
        txfUser.setColumns(30);
        txfUser.setToolTipText("Enter user name here");
        txfPassword.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                txfPassword_actionPerformed(e);
            }
        });
        lblDomain.setBackground(new Color(230, 230, 128));
        lblDomain.setFont(new java.awt.Font("Dialog", 2, 12));
        lblDomain.setForeground(new Color(192, 192, 0));
        lblDomain.setText("<Domain>");
        lblDomain.setHorizontalAlignment(JLabel.RIGHT);
        
        // Show how to set custom tooltip content
        JPanel tooltip = new JPanel();
        tooltip.setLayout(new BorderLayout());
        tooltip.add(new JButton("North"), BorderLayout.NORTH);
        tooltip.add(new JLabel("<html>Ignored mouse event listener<br>(custom tooltip content)</html>"), BorderLayout.CENTER);
        tooltip.add(new JButton("South"), BorderLayout.SOUTH);
        tooltip.setSize(new Dimension(200, 100));
        tooltip.putClientProperty(AjaxSwingProperties.COMPONENT_CSS_CLASS, "tooltip");
        lblDomain.setToolTipContent(tooltip);
        
        lblDomain.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                TraceMgr.trace(this, "mouseClicked, e = " + e);
                String eventName = e.getClickCount() == 2? "double click": "click";
                JOptionPane.showMessageDialog(null, "Mouse " + eventName + " event received");
            }
        });
        // Inform AjaxSwing that we are interested in double clicks, not single clicks

        cmbDomain.addItem("<Windows>");
        cmbDomain.addItem("<Solaris>");
        cmbDomain.addItem("<Linux>");
        cmbDomain.setBackground(new Color(230, 230, 128));
        cmbDomain.setSelectedIndex(1);
        cmbDomain.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                cmbDomain_actionPerformed(e);
            }
        });
        cmbDomain.setToolTipText("Choose domain");

        lstHosts.setListData(new String[]{"Sun", "Earth", "Mars", "Jupiter"});
        lstHosts.setForeground(new Color(192, 192, 0));
        lstHosts.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        lstHosts.setToolTipText("Select host");
        
        lstHosts.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (LoginDialog.this.lstHosts.getSelectedValue() != null && !e.getValueIsAdjusting()) {
                    JOptionPane.showMessageDialog(LoginDialog.this, "You have just seen a very powerful feature of AjaxSwing - the ability to determine\n" +
                            " which controls have listeners in the enabled applications, and to track the events\n" +
                            " on the HTML Page.",
                            "EVENT RECEIVED, your selection is " + LoginDialog.this.lstHosts.getSelectedValue(), JOptionPane.INFORMATION_MESSAGE);
                    lstHosts.getSelectionModel().removeListSelectionListener(this);
                }
            }
        });
        
        lblHosts.setFont(new java.awt.Font("Dialog", 2, 12));
        lblHosts.setForeground(new Color(192, 192, 0));
        lblHosts.setToolTipText("<html><b>Custom Tooltip Example</b><br>And it works</html>");
       
        chkDisableAll.setForeground(new Color(30, 157, 8));
        chkDisableAll.setBackground(Color.WHITE);
        chkDisableAll.setText("Disable All");
        chkDisableAll.setToolTipText("If checked, disables all components");
        chkDisableAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                chkDisableAll_actionPerformed(e);
            }
        });
        panelMain.setBackground(new Color(230, 230, 230));
        panelSouth.setBackground(new Color(230, 230, 230));
        panelNorth.setBackground(new Color(230, 230, 230));
        panelMain.setToolTipText("");
        chkReadOnly.setForeground(new Color(30, 157, 8));
        chkReadOnly.setBackground(Color.WHITE);
        chkReadOnly.setText("Read Only");
        chkReadOnly.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                chkReadOnly_actionPerformed(e);
            }
        });
        getContentPane().add(panelMain);
        panelMain.add(panelNorth, BorderLayout.NORTH);
        panelNorth.add(jTextDesc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panelNorth.add(lblUserName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 4, 4, 0), 4, 4));
        panelNorth.add(txfUser,  new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 4, 4), 4, 4));
        panelNorth.add(lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 0), 4, 4));
        panelNorth.add(txfPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 4, 4), 4, 3));
        panelNorth.add(lblDomain, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panelNorth.add(cmbDomain, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 4, 4), 0, 0));
        panelNorth.add(lblHosts, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 0, 0), 0, 0));
        panelNorth.add(lstHosts, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(4, 4, 4, 4), 0, 0));
        panelMain.add(panelSouth, BorderLayout.SOUTH);
        panelSouth.add(btnOK, null);
        panelSouth.add(btnCancel, null);
        panelSouth.add(chkDisableAll, null);
        panelSouth.add(chkReadOnly, null);

        setSize(new Dimension(400, 350));
        //XXX removed
        //com.creamtec.core.GUIUtilities.centerWindow(this);
    }

    void btnOK_actionPerformed(ActionEvent e) {
        ok = true;
        dispose();
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        dispose();
    }

    void txfPassword_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, "Change event on the password field");
    }


    void cmbDomain_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, "You have just seen a very powerful feature of AjaxSwing - the ability to determine\n" +
            " which controls have listeners in the enabled applications, and to track the events\n" +
            " on the HTML Page.",
            "EVENT RECEIVED, your selection is " + this.cmbDomain.getSelectedItem(), JOptionPane.INFORMATION_MESSAGE);
    }

    void chkDisableAll_actionPerformed(ActionEvent e) {
        this.btnOK.setEnabled(!this.chkDisableAll.isSelected());
        this.btnCancel.setEnabled(!this.chkDisableAll.isSelected());
        this.txfUser.setEnabled(!this.chkDisableAll.isSelected());
        this.txfPassword.setEnabled(!this.chkDisableAll.isSelected());
        this.lstHosts.setEnabled(!this.chkDisableAll.isSelected());
        this.cmbDomain.setEnabled(!this.chkDisableAll.isSelected());
        this.chkReadOnly.setEnabled(!this.chkDisableAll.isSelected());
    }

    void chkReadOnly_actionPerformed(ActionEvent e) {
        this.txfUser.setEditable(!this.chkReadOnly.isSelected());
        this.txfPassword.setEditable(!this.chkReadOnly.isSelected());
        this.cmbDomain.setEditable(!this.chkReadOnly.isSelected()); // for some reason it doesn't work
    }
    
}

