/**
 * Copyright 2000 by CreamTec, LLC. All rights reserved.
 */
package com.creamtec.ajaxswing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Random;

import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.creamtec.ajaxswing.AjaxSwingManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.ListSupport;
import com.creamtec.ajaxswing.support.old.ComponentUtils;

public class TabbedDialog extends JDialog {

    JPanel panel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JRadioButton jRadioButton1 = new JRadioButton();
    JRadioButton jRadioButton2 = new JRadioButton();
    JRadioButton jRadioButton3 = new JRadioButton();
    JCheckBox jCheckBox1 = new JCheckBox();
    JCheckBox jCheckBox2 = new JCheckBox();
    JToggleButton jToggleButton1 = new JToggleButton();
    JButton jButton1 = new JButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    JScrollPane spnTable = new JScrollPane();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane spnText = new JScrollPane();
    JTextArea jTextArea1 = new JTextArea();
    JEditorPane hint = new JEditorPane();
    JTextField jTextField1 = new JTextField();
    JTable tblPeople;
    protected JLabel lblSelection = new JLabel();
    ArrayList data = new ArrayList();
    JTree jTree1 = new JTree();

    public TabbedDialog(Frame frame, String title, boolean modal) {
        //super(title);
        super(frame, title, modal);
        try {
            jbInit();
            setSize(new Dimension(500, 440));
            this.setLocationRelativeTo(null);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        this.tblPeople = createTable();
        spnTable.setViewportView(this.tblPeople);
        this.tblPeople.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        // this.tblPeople.setTableHeader(null);

        TableColumn colText = this.tblPeople.getColumnModel().getColumn(0);
        colText.setHeaderValue("JTextField<1>");
        colText.setPreferredWidth(150);
        JTextField tf = new JTextField(10);
        colText.setCellEditor(new DefaultCellEditor(tf));
  
// For testing complex component renderer and editor
//        colText.setCellRenderer(new PanelCellEditor());
//        colText.setCellEditor(new PanelCellEditor());
        
        TableColumn colRenderer = this.tblPeople.getColumnModel().getColumn(1);
        colRenderer.setCellRenderer(new JTableCellRenderer());
        colRenderer.setCellEditor(new JTableCellRenderer());

        TableColumn colCmb = this.tblPeople.getColumnModel().getColumn(2);
        JComboBox cb = new JComboBox(new String[] { "Red", "Green", "Blue" });
        cb.setEditable(true);
        colCmb.setCellEditor(new DefaultCellEditor(cb));

        TableColumn colNumber = this.tblPeople.getColumnModel().getColumn(3);
        colNumber.setPreferredWidth(30);

        TableColumn colChk = this.tblPeople.getColumnModel().getColumn(4);
        colChk.setHeaderValue("ChkBx");
        colChk.setPreferredWidth(20);
        
        this.tblPeople.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() == false) {
                    int row = TabbedDialog.this.tblPeople.getSelectedRow();
                    if (row != -1) {
                        String name = (String) TabbedDialog.this.tblPeople.getModel().getValueAt(row, 0);
                        if (name.length() > 15)
                            name = name.substring(0, 15) + "...";
                        TabbedDialog.this.lblSelection.setText("Selection: " + name);
                    }
                }
            }
        });
    }

    public TabbedDialog() {
        this(null, "Tabs and Table", true);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        panel1.setLayout(gridBagLayout1);
        jRadioButton2.setSelected(true);
        jRadioButton1.setText("Refresh dialog when Close is pressed");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(TabbedDialog.this, "You have just selected Refresh on close", "EVENT", JOptionPane.INFORMATION_MESSAGE);
                jRadioButton1.removeActionListener(this);
                //TabbedDialog.this.setTitle("Updated at " + System.currentTimeMillis());
            }
        });
        
        jRadioButton2.setText("Dispose dialog when Close is pressed");
        jRadioButton3.setText("Stand-alone radio button");
        jCheckBox1.setSelected(true);
        jCheckBox1.setText("<html>JCheckBox with <i>actionListener</i></html>");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                jCheckBox1_actionPerformed(e);
            }

        });
        jCheckBox2.setText("JCheckBox with itemListener");
        jCheckBox2.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                jCheckBox2_itemStateChanged(e);
            }

        });
        jToggleButton1.setText("JToggleButton option");
        jButton1.setText("<html><b><i>Close</i></b></html>");
        jButton1.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                jButton1_actionPerformed(e);
            }

        });
        jTextArea1.setText("Very long text line that should be visible on the web page in a text box");
        jTextArea1.setColumns(30);
        hint.setEditable(false);
        hint.setContentType("text/html");
        hint.setText("<b>Hint:</b> Tabs and Table dialog shows how different selection controls are mapped by AjaxSwing. It demonstrates the client side filtering and sorting enabled for JTable");
        jTextField1.setText("JTextField");
        jTextField1.setColumns(30);
        lblSelection.setText("Selection: n/a");
        buttonGroup.add(jRadioButton1);
        buttonGroup.add(jRadioButton2);
        getContentPane().add(panel1);
        panel1.add(jRadioButton1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(jRadioButton2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(jCheckBox1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(jCheckBox2, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 0), 0, 0));
        panel1.add(jToggleButton1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 0), 0, 0));
        panel1.add(jTabbedPane1, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jTabbedPane1.add(spnTable, "Table");
        jTabbedPane1.add(spnText, "Text");
        jTabbedPane1.add(new JPanel(), "Disabled Tab");
        jTabbedPane1.setEnabledAt(2, false);
        
        initTree();
        initUpdateInterval();
        initListTable();
        initScrollBar();
        
        // Test multi-line tab header
        for(int i = 0; i < 5; i++) {
            jTabbedPane1.add(new JLabel("Tab" + i), "Test Tab" + i);
        }
        
        URL imageUrl = getClass().getResource("/images/StartServer.gif");
        ImageIcon icon = new ImageIcon(imageUrl);
        jTabbedPane1.setIconAt(jTabbedPane1.getTabCount() - 1, icon);

        panel1.add(hint, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(jTextField1, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(jButton1, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add(jRadioButton3, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 0), 0, 0));
        panel1.add(lblSelection, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
        spnText.getViewport().add(jTextArea1, null);
    }

    private void initScrollBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        final JLabel label = new JLabel();
        label.setText(" Value: ");
        JScrollBar scrollbar = new JScrollBar(JScrollBar.HORIZONTAL);
        scrollbar.addAdjustmentListener(new AdjustmentListener() {
            public void adjustmentValueChanged(AdjustmentEvent e) {
                label.setText(" Value: " + e.getValue());
            }
        });
        panel.add(scrollbar, BorderLayout.NORTH);
        panel.add(label, BorderLayout.SOUTH);
        this.jTabbedPane1.add(panel, "JScrollBar");
    }

    private void createContextMenuForList(final JList list)
    {
    	JPopupMenu menu = new JPopupMenu();
    	
    	final JCheckBoxMenuItem item1 = new JCheckBoxMenuItem("Autoscroll");
    	final JMenuItem item2 = new JMenuItem("Copy");
    	final JMenuItem item3 = new JMenuItem("Select All");
    	final JCheckBoxMenuItem item4 = new JCheckBoxMenuItem("Show color");
    	final JMenuItem item5 = new JMenuItem("Remove");

        item1.setSelected(
        		((Boolean)list.getClientProperty(ListSupport.ACTION_AUTOSCROLL)).booleanValue());
        item1.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		list.putClientProperty(ListSupport.ACTION_AUTOSCROLL, Boolean.valueOf(item1.isSelected()));
        	}
        });

        item2.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
                String selection = list.getSelectedValue().toString();
                StringSelection data = new StringSelection(selection);
                Clipboard clipboard = 
                     Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
                
                // NOTE: Workaround with copy action
                list.putClientProperty(ListSupport.ACTION_COPY, Boolean.TRUE);
        	}
        });
        
        item3.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		if (list.getSelectionMode() == ListSelectionModel.MULTIPLE_INTERVAL_SELECTION)
        		{
        			int size = list.getModel().getSize();
        			list.setSelectionInterval(0, size-1);
                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(list, true);
        		}
        		else
        		{
                    JOptionPane.showMessageDialog(null, "Selection mode for the selected JList component is not MULTIPLE_INTERVAL_SELECTION");
        		}
        	}
        });
        
        item4.setSelected(((Boolean)list.getClientProperty(ListSupport.ACTION_COLORIZE)).booleanValue());
        item4.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e)
        	{
        		list.putClientProperty(ListSupport.ACTION_COLORIZE, Boolean.valueOf(item4.isSelected()));
        	}
        });
        
        item5.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ListModel listModel = list.getModel();
                if (listModel instanceof DefaultListModel)
                {
                	DefaultListModel model = (DefaultListModel)listModel;
                    int[] indexes = list.getSelectedIndices();
                    for (int i = indexes.length - 1; i >= 0; i--)
                    {
                    	model.remove(indexes[i]);
                    }
                }
            }
        });

        menu.add(item1);
        menu.add(item2);
        menu.add(item3);
        menu.add(item4);
        menu.add(item5);
        
		ComponentUtils.setPopupMenu(list, menu);
    }
    
    private void initListTable() {
		JPanel panel = new JPanel(new BorderLayout());

		DefaultListModel listModel = new DefaultListModel();
		listModel.addElement("listElement1");
		listModel.addElement("listElement2");
		listModel.addElement("listElement3");
		listModel.addElement("listElement4");
		listModel.addElement("listElement5");
		listModel.addElement("listElement6");
		listModel.addElement("listElement7");
		listModel.addElement("listElement8");
		listModel.addElement("listElement9");
		listModel.addElement("listElement10");
		listModel.addElement("listElement11");
		listModel.addElement("listElement12");
		listModel.addElement("listElement13");
		listModel.addElement("listElement14");
		// final JList eventList = new JList(listModel);
		final JList eventList = new CustomList(listModel);
		eventList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

		listModel = new DefaultListModel();
		listModel.addElement("sec\"Element1");
		listModel.addElement("secElement2");
		listModel.addElement("sec\\Element3\\yellow");
		listModel.addElement("secElement4");
		listModel.addElement("secElement5");
		listModel.addElement("secElement6");
		final JList eventSecList = new JList(listModel);
		eventSecList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		eventSecList.putClientProperty(ListSupport.ACTION_AUTOSCROLL, Boolean.TRUE);
		eventSecList.putClientProperty(ListSupport.ACTION_COLORIZE, Boolean.TRUE);
		eventSecList.putClientProperty(ListSupport.ACTION_COPY, Boolean.FALSE);
		this.createContextMenuForList(eventSecList);
		
		DefaultTableModel tableModel = new DefaultTableModel();
		tableModel.addColumn("List Column");
		tableModel.addRow(new Object[] {"tableElement1"});
		tableModel.addRow(new Object[] {"tableElement2"});
		tableModel.addRow(new Object[] {"tableElement3"});
		tableModel.addRow(new Object[] {"tableElement4"});
		tableModel.addRow(new Object[] {"tableElement5"});
		tableModel.addRow(new Object[] {"tableElement6 tableElement6 tableElement6 tableElement6 tableElement6"});
		final JTable eventTable = new JTable(tableModel);
		eventTable.setSize(200, 200);

		final JPanel eventPanel = new JPanel(new GridLayout(1,3));
		eventPanel.add(new JScrollPane(eventList));
		eventPanel.add(new JScrollPane(eventSecList));
		eventPanel.add(new JScrollPane(eventTable));

        final JTextFieldValidatableInt updateInterval = new JTextFieldValidatableInt();
        updateInterval.setMinValue(0);
        updateInterval.setMaxValue(10);
        updateInterval.setPreferredSize(new Dimension(40, 20));
		
		JButton addEvent = new JButton("Set Interval");
		addEvent.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
		        final int updateIntervalValue = updateInterval.getIntValue();
				if (updateIntervalValue > 0)
				{
					new Thread() {
						public void run()
						{
			                if (AjaxSwingManager.isAjaxSwingRunning())
			                {
			                	ClientAgent.getCurrentInstance().setUpdateBrowserInterval(updateIntervalValue);
			                }
							
			                int clean = 0;
			                for (int i = 0; i < 10; i++) 
			                {
								Random rand = new Random();
								int n = rand.nextInt(100);

								((DefaultListModel)eventList.getModel()).addElement("custom\\List_" + n + "_Item_too_long_to_be_in_fit\\green");
								
								int lastindex = ((DefaultListModel)eventList.getModel()).size() - 1;
								Object value = ((DefaultListModel)eventList.getModel()).get(lastindex);
								value = value.toString() + String.valueOf(i) + "\\red";
								// value = value.toString();
								((DefaultListModel)eventList.getModel()).set(lastindex, value);
								
								if (((DefaultListModel)eventSecList.getModel()).size() > 0 && clean <= 0)
								{
									if (clean == 0)
									{
										DefaultListModel model = (DefaultListModel)eventSecList.getModel();
										model.clear();
									}
									// ((DefaultListModel)eventSecList.getModel()).addElement("FIRST");
									clean++;
								}
								else
								{
//									((DefaultListModel)eventSecList.getModel()).remove(0);
									((DefaultListModel)eventSecList.getModel()).addElement("");
//									((DefaultListModel)eventSecList.getModel()).addElement("simple value");
//									((DefaultListModel)eventSecList.getModel()).addElement("g\\r'e\"en\\green");
									((DefaultListModel)eventSecList.getModel()).addElement("the\\ent'_ this is long long long long long long line" + n + "\\red");
									((DefaultListModel)eventSecList.getModel()).addElement("ev\\ent'_2\nmultiline\n" + n + "\\red");
								}
								
								n = rand.nextInt(100);
								((DefaultTableModel)eventTable.getModel()).addRow(new Object[] {"customTable" + n + " ======|======|======|======|======|======|======|======|"});
								
			                    if (AjaxSwingManager.isAjaxSwingRunning()) {
			                        //ClientAgent.getCurrentInstance().setUpdateBrowser(true);
			                    	
			                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(eventList, true);
			                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(eventSecList, true);
			                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(eventTable, true);
			                    }
								
								try {
			                        Thread.sleep(1000);
			                    }
			                    catch(Exception x) {
			                        break;
			                    }
			                }
			                
							((DefaultListModel)eventSecList.getModel()).addElement("at last simple value");
	                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(eventSecList, true);
			                
			                if (AjaxSwingManager.isAjaxSwingRunning())
			                {
			                	ClientAgent.getCurrentInstance().setUpdateBrowserInterval(0);
			                }
						}
					}.start();
				}
			}
		});

		JPanel intervalPane = new JPanel(new FlowLayout());
		intervalPane.add(updateInterval);
		intervalPane.add(addEvent);
		
		panel.add(intervalPane, BorderLayout.SOUTH);
		panel.add(eventPanel, BorderLayout.CENTER);
        
        this.jTabbedPane1.add(panel, "List-Table");
    }
    
    private void initUpdateInterval() {
        JPanel updatePanel = new JPanel();
        updatePanel.setLayout(new BorderLayout());
        
        JPanel northPanel = new JPanel();
        northPanel.add(new JLabel("Update interval"), BorderLayout.NORTH);
        final JTextFieldValidatableInt updateInterval = new JTextFieldValidatableInt();
        updateInterval.setMinValue(0);
        updateInterval.setMaxValue(10);
        updateInterval.setPreferredSize(new Dimension(40, 20));
        northPanel.add(updateInterval);
        updatePanel.add(northPanel, BorderLayout.NORTH);
        
        final JLabel lastUpdatedLabel = new JLabel("Last updated at " + new Date());
        JPanel centerPanel = new JPanel();
        centerPanel.add(lastUpdatedLabel);
        updatePanel.add(centerPanel, BorderLayout.CENTER);
        
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                final int updateIntervalValue = updateInterval.getIntValue();
                if (AjaxSwingManager.isAjaxSwingRunning())
                {
                    ClientAgent.getCurrentInstance().setUpdateBrowserInterval(updateIntervalValue);
                }
                
                if (updateIntervalValue != 0) {
                    new Thread() {
                        public void run() {
                            int myUpdateIntervalValue = updateIntervalValue;
                            for (int i = 0; i < 60; i++) {
                                try {
                                    Thread.sleep(1000);
                                }
                                catch(Exception x) {
                                    break;
                                }
                                
                                if (myUpdateIntervalValue != updateInterval.getIntValue() || ClientAgent.getCurrentInstance().getUpdateBrowserInterval() == 0) {
                                    // User changed the value or the dialog is closed
                                    break;
                                }
                                
                                lastUpdatedLabel.setText("<html>Last updated at <font color=red>" + new Date() + "</font></html>");
                                if (AjaxSwingManager.isAjaxSwingRunning()) {
                                    //ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(lastUpdatedLabel, true);
                                }
                            }
                        }
                    }.start();
                }
            }
        });

        JPanel southPanel = new JPanel();
        southPanel.add(applyButton);
        updatePanel.add(southPanel, BorderLayout.SOUTH);
        
        jTabbedPane1.add(updatePanel, "Update Interval");
    }

    private void initTree() {
        // Test tree with context menu inside a dialog
        createTreeComponentContextMenu();
        jTree1.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        /* Now WebMail demo has a tree with selection listener so this one is kept lean and mean for speed
        jTree1.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                String text = "n/a";
                if (e.getNewLeadSelectionPath() != null)
                    text = e.getNewLeadSelectionPath().getLastPathComponent().toString();
                TabbedDialog.this.lblSelection.setText("Selection: " + text);
            }
        });
        */
        jTree1.setCellRenderer(new CustomTreeCellRenderer());
        jTree1.setRootVisible(false);
        
        JScrollPane scrollPane = new JScrollPane(jTree1);
        scrollPane.setName("JScrollPaneForTree");
        scrollPane.setBackground(new Color(255, 255, 255));
        jTabbedPane1.add(scrollPane, "Tree");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem("Open"));
        menu.add(new JMenuItem("Save"));
        menu.add(new JMenuItem("Save As"));
        menu.add(new JMenuItem("Close"));
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
    }

    private void createTreeComponentContextMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenu submenu = new JMenu("Add Actions");
        JMenuItem item = new JMenuItem("Add Folder");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionAddNode(e);
            }
        });
        submenu.add(item);
        contextMenu.add(submenu);
        
        submenu = new JMenu("Remove Actions");
        item = new JMenuItem("Remove Folder");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionRemoveNode(e);
            }
        });
        submenu.add(item);
        contextMenu.add(submenu);
        ComponentUtils.setPopupMenu(jTree1, contextMenu);
    }

    void actionAddNode(ActionEvent e) {
        MutableTreeNode node = null;
        TreePath sel = jTree1.getSelectionPath();

        if (sel != null) {
            node = (MutableTreeNode) sel.getLastPathComponent();
        } else {
            node = (MutableTreeNode) jTree1.getModel().getRoot();
        }

        DefaultTreeModel treeModel = (DefaultTreeModel) jTree1.getModel();
        MutableTreeNode newNode = new DefaultMutableTreeNode("New Node");
        treeModel.insertNodeInto(newNode, node, node.getChildCount());
    }

    void actionRemoveNode(ActionEvent e) {
        MutableTreeNode node = null;
        TreePath sel = jTree1.getSelectionPath();

        if (sel != null) {
            node = (MutableTreeNode) sel.getLastPathComponent();

            if (node != jTree1.getModel().getRoot()) {
                DefaultTreeModel model = (DefaultTreeModel) jTree1.getModel();
                model.removeNodeFromParent(node);
            }
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        if (jRadioButton1.isSelected()) {
            setTitle("Refreshed Dialog");
            hint.setText("The dialog has been refreshed with the data entered by you and the page has been regenerated. To close the dialog select <b>Dispose on close</b>.");
        } else {
            dispose();
        }
    }

    JTable createTable() {
        final String[] names = { "First Name", "CellRenderer", "JComboBox", "Number", "?" };
        data.add(new Object[] { "<html>Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark Mark</html>", new CellValue("Andrews"), "Red", new Integer(2), new Boolean(true) });
        data.add(new Object[] { "Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan", new CellValue("Chung"), "Green", new Integer(838), new Boolean(false) });
        data.add(new Object[] { "Tom", new CellValue("Ball"), "Blue", new Integer(99), new Boolean(false), new Boolean(true) });
        data.add(new Object[] { "Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan Alan", new CellValue("Chung"), "Green", new Integer(838), new Boolean(false) });
        data.add(new Object[] { "Tom", new CellValue("Ball"), "Blue", new Integer(99), new Boolean(false), new Boolean(true) });
        /*
         * {"Jeff", new CellValue("Dinkins"), "Red", new Integer(8), new Boolean(true)}, {"Amy", new CellValue("Fowler"), "Green", new Integer(3), new Boolean(false)}, {"Brian", "Gerhold", "Green",
         * new Integer(0), new Boolean(false)}, {"James", "Gosling", "Pink", new Integer(21), new Boolean(false)}, {"David", "Karlton", "Red", new Integer(1), new Boolean(false)}, {"Dave", "Kloba",
         * "Yellow", new Integer(14), new Boolean(false)}, {"Peter", "Korn", "Purple", new Integer(12), new Boolean(false)}, {"Phil", "Milne", "Purple", new Integer(3), new Boolean(false)}, {"Dave",
         * "Moore", "Green", new Integer(88), new Boolean(false)}, {"Hans", "Muller", "Maroon", new Integer(5), new Boolean(false)}, {"Rick", "Levenson", "Blue", new Integer(2), new Boolean(false)},
         * {"Tim", "Prinzing", "Blue", new Integer(22), new Boolean(false)}, {"Chester", "Rose", "Black", new Integer(0), new Boolean(false)}, {"Ray", "Ryan", "Gray", new Integer(77), new
         * Boolean(false)}, {"Georges", "Saab", "Red", new Integer(4), new Boolean(false)}, {"Willie", "Walker", "Phthalo Blue", new Integer(4), new Boolean(false)}, {"Kathy", "Walrath", "Blue", new
         * Integer(8), new Boolean(false)},
         */
        data.add(new Object[] { "Arnaud", "Weber", "Blue", new Integer(44), new Boolean(false) });
        // Create a model of the data.
        TableModel dataModel = new AbstractTableModel() {

            // These methods always need to be implemented.
            public int getColumnCount() {
                return names.length;
            }

            public int getRowCount() {
                return data.size();
            }

            public Object getValueAt(int row, int col) {
                Object[] rowData = (Object[]) data.get(row);
                return rowData[col];
            }

            // The default implementations of these methods in
            // AbstractTableModel would work, but we can refine them.
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                return getValueAt(0, c).getClass();
            }

            public boolean isCellEditable(int row, int col) {
                if (row % 2 == 0) {
                    return false;
                } else {
                    return true;
                }
            }

            public void setValueAt(Object aValue, int row, int column) {
                try {
                    Object[] rowData = (Object[]) data.get(row);
                    if (column == 3 && aValue != null) {
                        if (aValue instanceof Integer)
                            rowData[column] = aValue;
                        else
                            rowData[column] = Integer.valueOf(aValue.toString());
                    } else {
                        rowData[column] = aValue; // Boolean or text
                    }
                } catch (Exception x) {
                    x.printStackTrace();
                }
            }

        };
        return new CustomTable(dataModel){};
    }

    void jCheckBox1_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, "actionPerformed received for checkbox 1", "EVENT", JOptionPane.INFORMATION_MESSAGE);
    }

    void jCheckBox2_itemStateChanged(ItemEvent e) {
        JOptionPane.showMessageDialog(this, "itemStateChanged received for checkbox 2", "EVENT", JOptionPane.INFORMATION_MESSAGE);
    }

    public void dispose() {
        ClientAgent.getCurrentInstance().setUpdateBrowserInterval(0);       // Stop updates
        this.removeAll();
        super.dispose();
    }

    
    class PanelCellEditor implements TableCellEditor, TableCellRenderer {
        protected JPanel panel = new JPanel();
        protected JTextField textField = new JTextField();
        protected JCheckBox checkBox = new JCheckBox("renderer");
        protected JRadioButton radioButton = new JRadioButton("renderer");
        int row, col;
        
        public PanelCellEditor() {
            panel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 0));
            panel.add(textField);
            JButton button = new JButton("...");
            button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(null, "Thanks for clicking me for row = " + row + ", col = " + col);
                }
            });
            panel.add(button);
            
            checkBox.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(null, "Thanks for clicking checkbox for row = " + row + ", col = " + col);
                }
            });
            
            ButtonGroup fakeGroup = new ButtonGroup();
            fakeGroup.add(radioButton);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.row = row;
            this.col = col;
            if(row < 2) {
                textField.setText(value.toString());
                return panel;
            }
            else if (row < 4) {
                return checkBox;
            }
            else {
                return radioButton;
            }
        }
        
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.col = col;
            if(row < 2) {
                textField.setText(value.toString());
                return panel;
            }
            else if (row < 4) {
                return checkBox;
            }
            else {
                return radioButton;
            }
        }

        public void addCellEditorListener(CellEditorListener l) {
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return textField.getText();
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener l) {
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }
        
    }

}