/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.AjaxSwingSessionListener;
import com.creamtec.ajaxswing.core.ClientAgent;
import java.util.HashMap;

public class AjaxSwingManager {
    private static AjaxSwingSessionListener sessionListener;

    private AjaxSwingManager() {
    }

    public static void beginOperation() {
        if (!AjaxSwingManager.isAjaxSwingRunning()) {
            return;
        }
        ClientAgent.getCurrentInstance().beginOperation();
    }

    public static void endOperation() {
        if (!AjaxSwingManager.isAjaxSwingRunning()) {
            return;
        }
        ClientAgent.getCurrentInstance().endOperation();
    }

    public static void endOperation(boolean endAfterNextModalDialog) {
        if (!AjaxSwingManager.isAjaxSwingRunning()) {
            return;
        }
        ClientAgent.getCurrentInstance().endOperation(endAfterNextModalDialog);
    }

    public static void openInNewTab(String url) {
        if (!AjaxSwingManager.isAjaxSwingRunning()) {
            return;
        }
        ClientAgent.getCurrentInstance().openInNewTab(url);
    }

    public static int getClientId() {
        if (!AjaxSwingManager.isAjaxSwingRunning()) {
            return 0;
        }
        try {
            ClientAgent agent = ClientAgent.getCurrentInstance();
            return agent.getClientId();
        }
        catch (Throwable x) {
            x.printStackTrace();
            return 0;
        }
    }

    public static boolean isAjaxSwingRunning() {
        try {
            Class.forName("com.creamtec.ajaxswing.core.ClientAgent");
        }
        catch (Throwable x) {
            return false;
        }
        return ClientAgent.isToolkitInstalled();
    }

    public static HashMap getRequestParameters() {
        return ClientAgent.getCurrentInstance().getRequestData().getParams();
    }

    public static void setAjaxSwingSessionListener(AjaxSwingSessionListener sessionListener) {
        AjaxSwingManager.sessionListener = sessionListener;
    }

    public static AjaxSwingSessionListener getAjaxSwingSessionListener() {
        return sessionListener;
    }

    public static boolean changeSessionId() {
        try {
            ClientAgent.getCurrentInstance().setShouldChangeSessionId(true);
            return true;
        }
        catch (Throwable x) {
            x.printStackTrace();
            return false;
        }
    }
}

