/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.AjaxSwingManager;
import com.creamtec.ajaxswing.AjaxSwingRouter;
import com.creamtec.ajaxswing.FileUploadHandler;
import com.creamtec.ajaxswing.InProcessHttpServletRequest;
import com.creamtec.ajaxswing.RouterRequestFilter;
import com.creamtec.ajaxswing.ServletUtils;
import com.creamtec.ajaxswing.TemporaryFileRemover;
import com.creamtec.ajaxswing.core.AgentInitData;
import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentFactory;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.HttpResponseData;
import com.creamtec.ajaxswing.i18n.I18NKeys;
import com.creamtec.ajaxswing.i18n.I18NUtils;
import com.creamtec.ajaxswing.rendering.TemplateEngine;
import com.creamtec.ajaxswing.rendering.html.HTMLClientAgent;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxResponse;
import com.creamtec.ajaxswing.servlet.AjaxSwingServlet;
import com.creamtec.ajaxswing.servlet.AppDesc;
import com.creamtec.ajaxswing.v4.utils.ImageUtils;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.util.FontCalibration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public final class ServletHelper
implements AjaxSwingServlet {
    protected String sourceEncoding;
    protected ServletContext servletContext;
    protected int filteredRequestsAllowed = 29;
    protected int filteredRequestsDec = -1;
    protected RouterRequestFilter requestFilter;
    public FileUploadHandler fileUploadHandler;
    protected static Hashtable appDescs = new Hashtable();
    protected static ServletHelper instance;
    public static final String APP_NAME = "appName";
    public static final String PROPS_FILE_NAME = "propsFileName";
    private volatile Thread removeTempFileThread;
    protected static final Pattern calibrationDataPattern;

    protected ServletHelper(ServletContext servletContext) throws Exception {
        String requestFilterClass;
        this.servletContext = servletContext;
        AjaxSwingProperties defaultProps = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        String sourceEncoding = defaultProps.getProperty("router.characterEncoding");
        AppDesc.initLicense();
        if (sourceEncoding == null) {
            sourceEncoding = System.getProperty("file.encoding");
        }
        this.sourceEncoding = sourceEncoding;
        TraceMgr.trace((Object)this, (String)("Source encoding set to " + this.sourceEncoding), (int)4);
        if (!AjaxSwingSecurityManager.LIMIT_MODE) {
            this.filteredRequestsDec = 0;
        }
        if ((requestFilterClass = AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getProperty("router.requestFilterClass")) != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            TraceMgr.trace((Object)this, (String)("Loading request filter class " + requestFilterClass + " with class loader " + classLoader));
            Class<?> cls = classLoader.loadClass(requestFilterClass);
            Object requestFilter = cls.newInstance();
            if (requestFilter instanceof RouterRequestFilter) {
                this.requestFilter = (RouterRequestFilter)requestFilter;
            } else {
                TraceMgr.trace((Object)this, (String)("ERROR: request filter class " + requestFilter + " does not implement interface RouterRequestFilter"));
            }
        }
        this.removeTempFileThread = new TemporaryFileRemover(this, appDescs);
        if ("afterTime".equals(AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getProperty("agent.cleanupTempFiles", "session"))) {
            this.removeTempFileThread.setPriority(1);
            this.removeTempFileThread.start();
        }
    }

    public String getParameterValue(HttpServletRequest request, String name) throws Exception {
        String value = request.getParameter(name);
        return this.decodeValue(value);
    }

    public String[] getParameterValues(HttpServletRequest request, String name) throws Exception {
        String[] values = request.getParameterValues(name);
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.decodeValue(values[i]);
        }
        return values;
    }

    public String decodeValue(String value) throws Exception {
        if (value == null || value.length() == 0) {
            return value;
        }
        byte[] bytes = value.getBytes(this.sourceEncoding);
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException x) {
            TraceMgr.trace((Object)this, (String)("Failed to decode the value sent by the browser using encoding " + this.sourceEncoding + ". Specify the proper encoding in the application properties file using " + "router.characterEncoding"), (Throwable)x);
            return value;
        }
    }

    public void shutdown() {
        TraceMgr.trace((Object)this, (String)("shutting down applications, num = " + appDescs.size()), (int)3);
        if (this.removeTempFileThread != null && this.removeTempFileThread.isAlive()) {
            Thread temp = this.removeTempFileThread;
            this.removeTempFileThread = null;
            temp.interrupt();
        }
        this.shutdownAllAgents();
        ClientAgentFactory.getInstance().shutdown();
        AjaxSwingSecurityManager.setCheckExit((boolean)false);
        TraceMgr.trace((Object)this, (String)"shutdown complete", (int)3);
    }

    public void shutdownAllAgents() {
        for (AppDesc appDesc : appDescs.values()) {
            if (appDesc.isInProcess()) continue;
            Iterator agents = appDesc.getAgents();
            TraceMgr.trace((Object)this, (String)("shutdown, shutting down application " + appDesc.getAppName() + ", agents = " + appDesc.getAgentsCount()));
            while (agents.hasNext()) {
                TraceMgr.trace((Object)this, (String)"shutdown, shutting down next agent...");
                ClientAgentRemote agent = (ClientAgentRemote)agents.next();
                ServletHelper.shutdownAgent(appDesc, null, agent);
            }
        }
    }

    public void processHttpRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClientAgentRemote agent = null;
        AppDesc appDesc = null;
        if (this.getRequestFilter() != null && !this.getRequestFilter().preProcessRequest(request, response)) {
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        try {
            HttpRequestData requestData = new HttpRequestData();
            this.parseAppNameAndAction(request, requestData);
            appDesc = this.getAppDesc(request, requestData.getAppName());
            agent = this.getClientAgent(appDesc, request, requestData, response);
            String downloadFileName = request.getParameter("downloadFileName");
            if (agent != null && downloadFileName != null) {
                String csrfToken = request.getParameter("csrfToken");
                downloadFileName = new String(downloadFileName.getBytes("8859_1"), "UTF8");
                if (!csrfToken.equals(agent.getCsrfToken())) {
                    TraceMgr.trace((String)("CSRF Token missing or not equal for download request: " + csrfToken), (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                    response.sendError(403, "CSRF Token missing");
                    return;
                }
                if (agent.isDownloadAllowed(downloadFileName) && this.streamDownload(request, response, agent, downloadFileName = appDesc.getTempDirPath() + File.separatorChar + downloadFileName)) {
                    return;
                }
            }
            if (agent != null && agent.shouldChangeSessionId()) {
                request.changeSessionId();
                agent.setShouldChangeSessionId(false);
            }
            this.processRequestData(appDesc, request, requestData);
            if (requestData.isNewSession()) {
                request.changeSessionId();
                Object csrfTokenFromSession = this.getSessionAttribute(request.getSession(false), "csrfToken");
                Object csrfTokenFromRequest = request.getParameter("csrfToken");
                if (csrfTokenFromSession == null) {
                    TraceMgr.trace((String)"CSRF Token from session is missing, and generate new CSRF token for session", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                    csrfTokenFromRequest = csrfTokenFromSession = ServletHelper.createToken();
                }
                if (csrfTokenFromRequest == null) {
                    TraceMgr.trace((String)"CSRF Token missing on request", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                    response.sendError(403, "CSRF Token missing");
                    return;
                }
                if (!csrfTokenFromRequest.equals(csrfTokenFromSession)) {
                    TraceMgr.trace((String)("CSRF Token from session " + csrfTokenFromSession + " mismatch token from request " + csrfTokenFromRequest), (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                    response.sendError(403, "CSRF Token is wrong");
                    return;
                }
                requestData.getParams().put("csrfToken", csrfTokenFromRequest);
                this.initNewAgent(appDesc, agent, request, response, requestData);
            }
            if (!requestData.isCalibrateRequest()) {
                String fontCalibrationData = request.getParameter("FontCalibrationData");
                if (StringUtils.isNotBlank((CharSequence)fontCalibrationData)) {
                    if ("::".equals(fontCalibrationData)) {
                        TraceMgr.trace((Object)this, (String)"ERROR: request on /apps/FontCalibration doesn't get the response.It may couse the problems with text content displaying.", (int)1);
                    } else {
                        if (!calibrationDataPattern.matcher(fontCalibrationData).matches()) {
                            TraceMgr.trace((Object)this, (String)("Parameter FontCalibrationData doesn't match pattern.FontCalibrationData = " + fontCalibrationData), (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                            response.sendError(400, "Parameter FontCalibrationData has a wrong format");
                            return;
                        }
                        TraceMgr.trace((Object)this, (String)("FontCalibrationData = " + fontCalibrationData));
                        agent.setFontCalibrationData(fontCalibrationData);
                    }
                }
                this.doPocessHttpRequest(request, response, agent, appDesc, requestData);
            } else {
                if (!ClientAgent.isGraphicsEnvironmentPropertiesInstalled()) {
                    ClientAgent.installGraphicsEnvironmentProperties((AjaxSwingProperties)agent.getProps(), (Object)agent);
                }
                FontCalibration fontCalibration = new FontCalibration();
                String calibrationHTML = fontCalibration.getGeneratedHTML();
                response.getWriter().append(calibrationHTML);
            }
            this.configureResponse(request, response);
            this.filteredRequestsAllowed += this.filteredRequestsDec;
            if (this.requestFilter != null && this.filteredRequestsDec != 0) {
                TraceMgr.trace((String)("There are only [" + this.filteredRequestsAllowed + "] requests left to be filtered by " + this.requestFilter.getClass().getName()), (int)TraceMgr.DEFAULT_CUTOFF_LEVEL);
            }
            if (this.filteredRequestsAllowed == 0) {
                if (this.requestFilter != null) {
                    TraceMgr.trace((String)(this.requestFilter.getClass().getName() + " filter will be working anymore due to Free license limitations."));
                }
                this.requestFilter = null;
            }
        }
        catch (Throwable x) {
            try {
                this.handleRequestException(request, response, appDesc, agent, x);
            }
            catch (Exception x1) {
                throw new RuntimeException(x1);
            }
        }
    }

    protected void configureResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("X-UA-Compatible", "IE=edge");
    }

    protected void handleRequestException(HttpServletRequest request, HttpServletResponse response, AppDesc appDesc, ClientAgentRemote clientAgent, Throwable x) throws Exception {
        TraceMgr.trace((Object)this, (String)("Failed to process a request for session = " + request.getSession()), (Throwable)x, (int)1);
        String errorMessage = null;
        boolean productionMode = false;
        if (appDesc != null) {
            productionMode = appDesc.getProps().getBooleanProperty("agent.productionMode", true);
        } else {
            AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
            productionMode = props.getBooleanProperty("agent.productionMode", true);
        }
        if (!productionMode) {
            errorMessage = TraceMgr.getExceptionText((String)"Failed to process request", (Throwable)x);
            errorMessage = StringEscapeUtils.escapeHtml(errorMessage);
            if (x != null) {
                StringWriter wr = new StringWriter();
                x.printStackTrace(new PrintWriter(wr));
                errorMessage = errorMessage + "<pre>" + StringEscapeUtils.escapeHtml(wr.toString()) + "</pre>";
            }
        } else {
            errorMessage = "";
        }
        this.setSessionAttribute(request.getSession(), "ajaxswing.errorMessage", errorMessage);
        String submitURL = this.getSubmitURL(appDesc, request, response);
        this.setSessionAttribute(request.getSession(), "ajaxswing.submitURL", submitURL);
        String redirectURL = null;
        if (appDesc != null) {
            redirectURL = appDesc.getProps().getProperty("html.errorPageURL");
            if (redirectURL == null) {
                Locale definedLocale = null;
                if (clientAgent != null) {
                    definedLocale = clientAgent.getUserLocale();
                }
                if (definedLocale == null) {
                    definedLocale = I18NUtils.getApplicationLocale(appDesc.getProps(), request);
                }
                redirectURL = ServletUtils.getStandardPageURL(1, this.getThemeDocsURL(request, appDesc), appDesc.getProps(), definedLocale);
            }
        } else {
            redirectURL = ServletUtils.getStandardPageURL(1, this.getThemeDocsURL(request, appDesc), null, null);
        }
        HttpResponseData responseData = new HttpResponseData(3);
        responseData.setRedirectURL(redirectURL);
        responseData.setErrorMessage(errorMessage);
        this.forwardToURL(responseData, request, response, appDesc);
    }

    private void doPocessHttpRequest(HttpServletRequest request, HttpServletResponse response, ClientAgentRemote agent, AppDesc appDesc, HttpRequestData requestData) throws Exception {
        if (this.getRequestFilter() != null && !this.getRequestFilter().postProcessRequest(request, response, appDesc, agent, requestData)) {
            return;
        }
        if (agent != null) {
            String locale = request.getParameter(appDesc.getProps().getProperty("http.url.locale", "locale"));
            if (!requestData.isNewSession() && (requestData.isFastSubmit() || requestData.getParams().get("upload.localFile") != null)) {
                Object csrfToken = requestData.getParams().get("__csrfToken");
                if (!agent.getCsrfToken().equals(csrfToken)) {
                    TraceMgr.trace((String)("CSRF Token missing or not equal in doProcessHttpRequest: " + csrfToken), (int)TraceMgr.DEFAULT_WARNING_LEVEL);
                    response.sendError(403, "CSRF Token missing");
                    return;
                }
            }
            if (locale != null) {
                agent.setUserLocale(I18NUtils.createLocale(locale));
            }
            if (!this.delegateRequestToClientAgent(request, response, appDesc, agent, requestData)) {
                return;
            }
        } else if ("router.autoSubmit".equals(requestData.getAction()) || "ping".equals(requestData.getAction())) {
            TraceMgr.trace((Object)this, (String)"Autoupdate for expired session", (int)3);
            String submitURL = this.getSubmitURL(appDesc, request, response);
            this.setSessionAttribute(request.getSession(), "ajaxswing.submitURL", submitURL);
            String redirectURL = null;
            if (appDesc != null) {
                Locale applicationLocale = I18NUtils.getApplicationLocale(appDesc.getProps(), request);
                redirectURL = ServletUtils.getStandardPageURL(2, this.getThemeDocsURL(request, appDesc), appDesc.getProps(), applicationLocale);
                this.setSessionAttribute(request.getSession(), I18NKeys.MESSAGE_SESSION_CLOSED_TITLE.getKey(), I18NUtils.getMessage(I18NKeys.MESSAGE_SESSION_CLOSED_TITLE, applicationLocale));
                this.setSessionAttribute(request.getSession(), I18NKeys.MESSAGE_SESSION_CLOSED_TEXT.getKey(), I18NUtils.getMessage(I18NKeys.MESSAGE_SESSION_CLOSED_TEXT, applicationLocale));
                this.removeSessionAttribute(request.getSession(), appDesc.getAppName());
            } else {
                AjaxSwingProperties defaultProps = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
                Locale targetLocale = I18NUtils.getApplicationLocale((AppProperties)defaultProps, request);
                redirectURL = ServletUtils.getStandardPageURL(2, ServletHelper.getDocsURL(appDesc, request), (AppProperties)defaultProps, targetLocale);
            }
            HttpResponseData responseData = new HttpResponseData(3);
            responseData.setRedirectURL(redirectURL);
            this.forwardToURL(responseData, request, response, appDesc);
        } else {
            String initializationURL = appDesc.getProps().getProperty("html.initializationPageURL");
            if (TraceMgr.getCutoffLevel() >= 6) {
                TraceMgr.trace((Object)this, (String)("Initializing new client agent using URL " + initializationURL), (int)6);
            }
            if (initializationURL == null) {
                this.writeInitializingPage(request, response, appDesc, agent, requestData.getAppName());
            } else {
                HttpResponseData responseData = new HttpResponseData(3);
                responseData.setRedirectURL(initializationURL);
                this.forwardToURL(responseData, request, response, appDesc);
            }
        }
    }

    private void writeInitializingPage(HttpServletRequest request, HttpServletResponse response, AppDesc appDesc, ClientAgentRemote agent, String appName) throws Exception {
        Object csrfToken;
        String submitURL = this.getSubmitURL(appDesc, request, response);
        if (request.getQueryString() != null) {
            submitURL = submitURL + "?" + request.getQueryString().replace("\"", "%22");
        }
        if ((csrfToken = this.getSessionAttribute(request.getSession(false), "csrfToken")) == null || !(csrfToken instanceof String)) {
            csrfToken = ServletHelper.createToken();
        } else {
            TraceMgr.trace((String)"Reuse CSRF Token from session to reinitializtion page");
        }
        this.setSessionAttribute(request.getSession(false), "csrfToken", csrfToken);
        HashMap<String, Object> page = new HashMap<String, Object>();
        page.put("submitURL", submitURL);
        page.put("themeDocsURL", this.getThemeDocsURL(request, appDesc));
        page.put("docsURL", ServletHelper.getDocsURL(appDesc, request));
        page.put("i18nkeys", this.getAllMessages(request, appDesc, agent));
        page.put("csrfToken", csrfToken);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("request", request);
        root.put("page", page);
        root.put("props", appDesc.getProps());
        String templateName = appDesc.getProps().getProperty("html.template.initializing", "default-page/initializing.html");
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace((Object)this, (String)("Using initialization template " + templateName + " with submitURL " + submitURL), (int)6);
        }
        StringWriter writer = new StringWriter(2000);
        Template template = TemplateEngine.getInstance().getConfiguration().getTemplate(templateName);
        template.process(root, (Writer)writer);
        response.getWriter().println(writer.toString());
    }

    private static String createToken() {
        SecureRandom random = new SecureRandom();
        int length = 20;
        char[] chars = "0123456789QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm".toCharArray();
        StringBuilder token = new StringBuilder();
        while (length-- != 0) {
            token.append(chars[random.nextInt(chars.length)]);
        }
        return token.toString();
    }

    private Map<String, String> getAllMessages(HttpServletRequest request, AppDesc appDesc, ClientAgentRemote agent) throws RemoteException {
        Locale userLocale = null;
        String localeFromUrl = request.getParameter(appDesc.getProps().getProperty("http.url.locale", "locale"));
        userLocale = agent != null ? agent.getUserLocale() : (localeFromUrl != null ? I18NUtils.createLocale(localeFromUrl) : I18NUtils.getApplicationLocale(appDesc.getProps(), request));
        HashMap<String, String> i18nkeys = new HashMap<String, String>();
        for (I18NKeys key : I18NKeys.values()) {
            i18nkeys.put(key.getKey(), I18NUtils.getMessage(key, userLocale));
        }
        return i18nkeys;
    }

    protected void forwardToURL(HttpResponseData responseData, HttpServletRequest request, HttpServletResponse response, AppDesc appDesc) throws Exception {
        int slash;
        String targetURL = responseData.getRedirectURL();
        String themeDocsURL = this.getThemeDocsURL(request, appDesc);
        String currentURL = request.getRequestURL().toString();
        request.setAttribute("ajaxswing.submitURL", (Object)currentURL);
        this.setSessionAttribute(request.getSession(), "ajaxswing.submitURL", currentURL);
        request.setAttribute("ajaxswing.themeDocsURL", (Object)themeDocsURL);
        this.setSessionAttribute(request.getSession(), "ajaxswing.themeDocsURL", themeDocsURL);
        if (appDesc == null) {
            appDesc = this.getAppDesc(request, "default");
        }
        if (targetURL.startsWith("/") && (slash = currentURL.indexOf("//")) != -1 && (slash = currentURL.indexOf("/", slash + 2)) != -1) {
            targetURL = currentURL.substring(0, slash) + targetURL;
        }
        if (responseData.getStatus() == 3) {
            targetURL = targetURL.indexOf("?") >= 0 ? targetURL + "&" : targetURL + "?";
            targetURL = targetURL + "ajaxswing.submitURL=";
            targetURL = targetURL + currentURL;
            targetURL = targetURL + "&ajaxswing.themeDocsURL=";
            targetURL = targetURL + themeDocsURL;
            if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                targetURL = targetURL + "&" + request.getQueryString();
            }
        }
        targetURL = response.encodeRedirectURL(targetURL);
        boolean wasAjaxSubmit = "true".equals(request.getParameter("__FastSubmit"));
        String htmlPage = responseData.getHtmlPage();
        if (wasAjaxSubmit) {
            TraceMgr.trace((Object)this, (String)("Redirecting via Ajax to " + targetURL), (int)5);
            if (htmlPage.length() > 0) {
                response.getWriter().println(htmlPage);
            } else {
                AjaxResponse ajaxResponse = new AjaxResponse();
                ajaxResponse.setRedirectURL(targetURL);
                response.getWriter().println(new ObjectMapper().writeValueAsString((Object)ajaxResponse));
            }
        } else {
            TraceMgr.trace((Object)this, (String)("Redirecting via browser to " + targetURL), (int)5);
            response.sendRedirect(targetURL);
        }
    }

    protected static String getDocsURL(AppDesc appDesc, HttpServletRequest request) {
        String docsURL = null;
        if (appDesc != null) {
            docsURL = appDesc.getProps().getProperty("html.docsURL");
        }
        if (docsURL == null || docsURL.length() == 0) {
            docsURL = ServletHelper.getServerURL(request);
        }
        return docsURL;
    }

    protected String getThemeDocsURL(HttpServletRequest request, AppDesc appDesc) {
        String theme = "Light_docs";
        if (appDesc != null) {
            theme = appDesc.getProps().getProperty("html.theme") + "_docs";
        }
        return ServletHelper.getDocsURL(appDesc, request) + "/" + theme;
    }

    protected boolean delegateRequestToClientAgent(HttpServletRequest request, HttpServletResponse response, AppDesc appDesc, ClientAgentRemote agent, HttpRequestData data) throws Exception, AjaxSwingException, RemoteException, IOException {
        HttpResponseData responseData;
        HttpSession session = request.getSession();
        Integer sessionId = (Integer)this.getSessionAttribute(session, appDesc.getAppName());
        String keepSessionAlive = this.getParameterValue(request, "keepSessionAlive");
        if (!"false".equals(keepSessionAlive)) {
            appDesc.getSessionManager().actionPerformed((Object)sessionId);
        }
        try {
            responseData = agent.processHttpRequest(data);
        }
        catch (ConnectException e) {
            Thread.yield();
            responseData = agent.processHttpRequest(data);
            TraceMgr.trace((Object)this, (String)"Succeeded to reconnect to RMI", (int)3);
        }
        catch (UnmarshalException e) {
            TraceMgr.trace((Object)this, (String)"Unmarshalling failed", (int)4);
            throw e;
        }
        if (this.getRequestFilter() != null && !this.getRequestFilter().processResponse(request, response, appDesc, agent, data, responseData)) {
            return false;
        }
        if (responseData.getRedirectURL() != null) {
            TraceMgr.trace((Object)this, (String)("Redirecting to " + responseData.getRedirectURL()), (int)6);
            if (responseData.getErrorMessage() != null && !appDesc.getProps().getBooleanProperty("agent.productionMode", true)) {
                this.setSessionAttribute(session, "ajaxswing.errorMessage", responseData.getErrorMessage());
            }
            if (responseData.getSubmitURL() != null) {
                this.setSessionAttribute(session, "ajaxswing.submitURL", responseData.getSubmitURL());
            }
            this.copyResponseParameters(responseData, request);
            this.forwardToURL(responseData, request, response, appDesc);
        } else {
            response.getWriter().println(responseData.getHtmlPage());
        }
        if (responseData.getStatus() == 2) {
            TraceMgr.trace((Object)this, (String)"Client has exited, cleanup the session");
            this.removeSessionAttribute(session, appDesc.getAppName());
            request.changeSessionId();
            if (agent != null) {
                ServletHelper.shutdownAgent(appDesc, sessionId, agent);
            }
        }
        return true;
    }

    protected void copyResponseParameters(HttpResponseData responseData, HttpServletRequest request) {
        for (String key : responseData.getParams().keySet()) {
            request.setAttribute(key, responseData.getParams().get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean streamDownload(HttpServletRequest request, HttpServletResponse response, ClientAgentRemote agent, String fileName) throws Exception {
        boolean bl;
        block20: {
            File file;
            block17: {
                boolean bl2;
                block18: {
                    file = null;
                    try {
                        TraceMgr.trace((Object)this, (String)("Streaming file for download " + fileName), (int)1);
                        file = new File(fileName);
                        if (file.exists() && !file.isDirectory()) break block17;
                        if (!agent.getProps().getBooleanProperty("agent.productionMode", true)) {
                            throw new AjaxSwingException("Internal error in streamDownload, file doesn't exist or is directory: " + fileName);
                        }
                        TraceMgr.trace((Object)this, (String)"Internal error in streamDownload, file doesn't exist or is directory: ", (Throwable)new AjaxSwingException("Internal error in streamDownload, file doesn't exist: " + fileName), (int)1);
                        bl2 = false;
                        if (file == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            agent.denyDownload(file);
                        }
                        throw throwable;
                    }
                    agent.denyDownload(file);
                }
                return bl2;
            }
            int contentLength = (int)file.length();
            response.setContentType("application/octet-stream");
            String fileNameRaw = file.getName();
            if (request.getHeader("User-Agent").indexOf("MSIE") != -1 && fileNameRaw != null) {
                try {
                    fileNameRaw = URLEncoder.encode(fileNameRaw, "UTF-8").replaceAll("\\+", " ");
                }
                catch (UnsupportedEncodingException ex) {}
            }
            response.setHeader("Content-disposition", "attachment; filename=\"" + fileNameRaw + "\"");
            if (request.getHeader("User-Agent").indexOf("MSIE") != -1) {
                response.setHeader("pragma", "");
                response.setHeader("Cache-Control", "");
            } else {
                response.setHeader("Cache-Control", "max-age=600");
            }
            TraceMgr.trace((Object)this, (String)("Content length = " + contentLength), (int)6);
            if (contentLength == 0) {
                TraceMgr.trace((Object)this, (String)"Stream dummy value instead of an empty file to make sure download begins", (int)1);
                response.setContentLength(1);
                ServletOutputStream os = response.getOutputStream();
                os.write(32);
                os.close();
            } else {
                response.setContentLength(contentLength);
                ServletOutputStream outStream = null;
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    outStream = response.getOutputStream();
                    ServletHelper.copyInputToOutput(in, (OutputStream)outStream);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
            }
            bl = true;
            if (file == null) break block20;
            agent.denyDownload(file);
        }
        return bl;
    }

    public static long copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public String getSubmitURL(AppDesc appDesc, HttpServletRequest request, HttpServletResponse response) {
        String submitURL = null;
        if (request != null) {
            if (appDesc != null) {
                submitURL = appDesc.getProps().getProperty("html.submitURL");
            }
            if (submitURL == null) {
                submitURL = request.getRequestURL().toString();
            }
        }
        return submitURL;
    }

    public String getDocsRealPath(AppDesc appDesc, HttpServletRequest request) throws Exception {
        String path = appDesc.getProps().getProperty("html.docsRealPath");
        if (path == null) {
            path = this.servletContext.getRealPath("");
        }
        if (path == null) {
            TraceMgr.trace((Object)this, (String)"*** WARNING *** The path to the AjaxSwing documents within webserver public documents could not be automatically set. Use html.docsRealPath setting to provide the path explicitly", (int)3);
        } else {
            path = new File(path).getCanonicalPath();
        }
        return path;
    }

    public static String getServerURL(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer(100);
        String scheme = request.getScheme();
        int port = request.getServerPort();
        buf.append(scheme);
        buf.append("://");
        buf.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buf.append(':');
            buf.append(port);
        }
        try {
            if (request.getContextPath() != null && request.getContextPath().length() > 0) {
                buf.append(request.getContextPath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf.toString();
    }

    public void processRequestData(AppDesc appDesc, HttpServletRequest request, HttpRequestData requestData) throws Exception {
        String requestDataLevel;
        if (this.fileUploadHandler.isMultipartContent(request)) {
            this.fileUploadHandler.handleUpload(appDesc, request, requestData);
        } else {
            this.copyRequestParameters(request, requestData);
            this.copyRequestHeaders(request, requestData);
        }
        if (appDesc.evalRequests == 0) {
            throw new AjaxSwingException("Evaluation version is limited to the number of requests it can process. Please register to obtain the full-featured version. Visit us at http://creamtec.com to obtain more information. Thank you for using AjaxSwing!");
        }
        --appDesc.evalRequests;
        if (!(requestData.isNewSession() || "refresh".equals(requestData.getAction()) || "ping".equals(requestData.getAction()) || requestData.getParams().size() == 0)) {
            String id = (String)requestData.getParams().get("__RequestId");
            if (requestData.getParams().get("upload.localFile") != null) {
                id = "1";
            }
            if (!requestData.isFastSubmit()) {
                if (id == null) {
                    requestData.setAction("refresh");
                    String message = appDesc.getProps().getProperty("message.browser_state_resynchronized");
                    if (message != null) {
                        requestData.setErrorMessage(message);
                    }
                    TraceMgr.trace((Object)this, (String)"Invalid form submitted, no request id is found. Refreshing the page", (int)3);
                } else {
                    requestData.setRequestId(Long.parseLong(id));
                }
            }
        }
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace((Object)this, (String)("Request query string = " + request.getQueryString()), (int)6);
        }
        if (!(StringUtils.isEmpty((CharSequence)request.getQueryString()) || request.getQueryString().indexOf(38) == -1 && request.getQueryString().toUpperCase().indexOf("JSESSIONID") != -1)) {
            TraceMgr.trace((Object)this, (String)("Setting reloadPage=true because of query string parameters " + request.getQueryString()));
            requestData.setReloadPage(true);
        }
        if (!"none".equalsIgnoreCase(requestDataLevel = AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getProperty("router.httpRequestDataLevel", "none"))) {
            if (appDesc.isInProcess()) {
                requestData.setHttpRequest((Object)request);
            } else {
                requestData.setHttpRequest((Object)new InProcessHttpServletRequest(request, requestDataLevel));
            }
        }
    }

    private void copyRequestHeaders(HttpServletRequest request, HttpRequestData data) throws Exception {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            String value = null;
            if (!"Accept-Language".equalsIgnoreCase(name)) continue;
            value = request.getHeader(name);
            headersMap.put(name.toLowerCase(), value);
        }
        data.setHeaders(headersMap);
    }

    private void copyRequestParameters(HttpServletRequest request, HttpRequestData data) throws Exception {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String value = null;
            if (name.equals("__Action")) {
                value = request.getParameter(name);
                if (value != null && value.length() != 0) {
                    data.setAction(value);
                }
            } else if (name.startsWith("_List_")) {
                paramsMap.put(name, this.getParameterValues(request, name));
                value = "String[]";
            } else if (name.endsWith("[]")) {
                paramsMap.put(name, this.getParameterValues(request, name));
            } else {
                try {
                    value = this.getParameterValue(request, name);
                    paramsMap.put(name, value);
                }
                catch (ClassCastException ex) {
                    paramsMap.put(name, this.getParameterValues(request, name));
                    value = "String[]";
                }
            }
            if (TraceMgr.getCutoffLevel() < 6) continue;
            TraceMgr.trace((Object)this, (String)(" param = " + name + ", value = " + value), (int)6);
        }
        data.setParams(paramsMap);
    }

    public ClientAgentRemote getClientAgent(AppDesc appDesc, HttpServletRequest request, HttpRequestData requestData, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        Integer sessionId = (Integer)this.getSessionAttribute(session, appDesc.getAppName());
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace((Object)this, (String)("getClientAgent for session " + session + ", session id = " + sessionId));
        }
        ClientAgentRemote agent = null;
        if (sessionId != null) {
            agent = appDesc.getAgent((Object)sessionId);
        }
        if (agent == null) {
            if (request.getParameter("AjaxSwingInitData") == null) {
                return null;
            }
            if (requestData.getAction() != null && requestData.getAction().length() != 0) {
                throw new AjaxSwingException("Invalid initialization URL, only application name should be specified, remove additional parameters:" + requestData.getAction());
            }
            if (appDesc.getAgentsCount() >= AppDesc.CONNECTIONS_LIMIT) {
                throw new AjaxSwingException("The maximum allowed number of concurrent clients has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing", false);
            }
            if (AjaxSwingManager.getAjaxSwingSessionListener() != null) {
                AjaxSwingManager.getAjaxSwingSessionListener().beforeCreate();
            }
            if (appDesc.isInProcess()) {
                if (TraceMgr.getCutoffLevel() >= 3) {
                    TraceMgr.trace((Object)this, (String)("createNewAgent, creating a new client inProcess=true for app " + appDesc.getAppName() + ", cur agents = " + appDesc.getAgentsCount()), (int)3);
                }
                agent = this.createClientAgent(appDesc.getAppName());
            } else {
                if (TraceMgr.getCutoffLevel() >= 3) {
                    TraceMgr.trace((Object)this, (String)("createNewAgent, creating a new client inProcess=false for app " + appDesc.getAppName() + ", cur agents = " + appDesc.getAgentsCount()), (int)3);
                }
                String locale = null;
                if (appDesc.getProps().getBooleanProperty("agent.forceJvmLocale", Boolean.FALSE.booleanValue()) && StringUtils.isEmpty((CharSequence)(locale = request.getParameter(appDesc.getProps().getProperty("http.url.locale", "locale"))))) {
                    Locale targetLocale = I18NUtils.getApplicationLocale(appDesc.getProps(), request);
                    locale = targetLocale.toString();
                }
                if ((agent = ClientAgentFactory.getInstance().createNewAgent(appDesc.getAppName(), locale)) == null) {
                    throw new AjaxSwingException("Failed to create Client Agent");
                }
            }
            requestData.setNewSession(true);
            if (AjaxSwingManager.getAjaxSwingSessionListener() != null) {
                AjaxSwingManager.getAjaxSwingSessionListener().afterCreate(ServletHelper.getClientId(agent), agent);
            }
        } else {
            TraceMgr.trace((Object)this, (String)"Found existing agent");
            requestData.setNewSession(false);
        }
        return agent;
    }

    public ClientAgent createClientAgent(String appName) throws Exception {
        return new InProcessClientAgent(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAgent(AppDesc appDesc, Integer sessionId, ClientAgentRemote agent) {
        TraceMgr.trace(ServletHelper.class, (String)("shutdownAgent for appDesc " + appDesc + ", sessionId = " + sessionId), (int)4);
        Object object = ClientAgentFactory.getInstance().getLock();
        synchronized (object) {
            if (AjaxSwingManager.getAjaxSwingSessionListener() != null) {
                AjaxSwingManager.getAjaxSwingSessionListener().beforeDestroy(ServletHelper.getClientId(agent), agent);
            }
            if (appDesc != null && sessionId != null) {
                appDesc.removeAgent((Object)sessionId);
            }
            ClientAgentFactory.getInstance().shutdownAgent(agent, appDesc.getAppName());
            if (AjaxSwingManager.getAjaxSwingSessionListener() != null) {
                AjaxSwingManager.getAjaxSwingSessionListener().afterDestroy(ServletHelper.getClientId(agent), agent);
            }
            TraceMgr.trace(ServletHelper.class, (String)"shutdownAgent finished", (int)4);
            TraceMgr.newLine();
        }
    }

    void initNewAgent(AppDesc appDesc, ClientAgentRemote agent, HttpServletRequest request, HttpServletResponse response, HttpRequestData requestData) throws Exception {
        AgentInitData initData = this.getAgentInitData(appDesc, request, response);
        if (!StringUtils.isEmpty((CharSequence)initData.getLocale())) {
            agent.setUserLocale(I18NUtils.createLocale(initData.getLocale()));
        }
        if (agent.getUserLocale() == null) {
            Locale applicationLocale = I18NUtils.getApplicationLocale(appDesc.getProps(), request);
            agent.setUserLocale(applicationLocale);
            I18NUtils.reloadResourceBundles();
        }
        if (this.getSessionAttribute(request.getSession(), appDesc.getAppName()) != null) {
            TraceMgr.trace((String)"Session expired, starting a new one", (int)6);
        }
        Integer clientId = new Integer(ServletHelper.getClientId(agent));
        this.setSessionAttribute(request.getSession(), appDesc.getAppName(), clientId);
        appDesc.addAgent((Object)clientId, agent);
        initData.clientId = clientId;
        String ajaxswingInitData = request.getParameter("AjaxSwingInitData");
        TraceMgr.trace((Object)this, (String)("AjaxSwingInitData = " + ajaxswingInitData));
        String[] initParams = ajaxswingInitData.split(",");
        initData.clientWidth = Integer.parseInt(initParams[0]);
        initData.clientHeight = Integer.parseInt(initParams[1]);
        if (initParams.length > 2) {
            int offset2;
            int offsetNow;
            initData.gmtOffest = offsetNow = Integer.parseInt(initParams[2]);
            int offset1 = Integer.parseInt(initParams[3]);
            initData.gmtHasDaylight = offset1 != (offset2 = Integer.parseInt(initParams[4]));
            Date switch1 = new Date(Long.parseLong(initParams[5]));
            Date switch2 = new Date(Long.parseLong(initParams[6]));
            try {
                initData.gmtTimeZone = this.getTimezone(offsetNow * 60 * 1000, offset1 * 60 * 1000, offset2 * 60 * 1000, switch1, switch2);
            }
            catch (Exception ex) {
                TraceMgr.trace((String)"Failed to get host timezone", (Throwable)ex);
            }
        } else {
            try {
                initData.gmtOffest = TimeZone.getDefault().getOffset(new Date().getTime()) / 1000 / 60;
            }
            catch (Exception ex) {
                TraceMgr.trace((String)"Failed to get host timezone", (Throwable)ex);
            }
        }
        if (this.servletContext.getMajorVersion() >= 2 && this.servletContext.getMinorVersion() >= 2) {
            initData.servletContextPath = request.getContextPath();
        }
        agent.init(initData, requestData);
    }

    private TimeZone getTimezone(int offsetNow, int offsetWinter, int offsetSummer, Date switch1, Date switch2) {
        TimeZone result = TimeZone.getDefault();
        String[] zones1 = TimeZone.getAvailableIDs(offsetWinter);
        String[] zones2 = TimeZone.getAvailableIDs(offsetSummer);
        ArrayList<String> zones = new ArrayList<String>();
        zones.add(TimeZone.getDefault().getID());
        zones.addAll(Arrays.asList(zones1));
        zones.addAll(Arrays.asList(zones2));
        Calendar cals1 = Calendar.getInstance();
        Calendar cals2 = Calendar.getInstance();
        cals1.setTime(switch1);
        cals2.setTime(switch2);
        if (zones.size() == 1) {
            result = TimeZone.getTimeZone((String)zones.get(0));
        }
        if (zones.size() > 1) {
            result = TimeZone.getTimeZone((String)zones.get(0));
            for (int i = 0; i < zones.size(); ++i) {
                TimeZone temp = TimeZone.getTimeZone((String)zones.get(i));
                Date now = new Date();
                int year = Calendar.getInstance().get(1);
                Calendar cal1 = Calendar.getInstance();
                cal1.set(year, 1, 1);
                Calendar cal2 = Calendar.getInstance();
                cal2.set(year, 7, 1);
                if (temp.getOffset(cal1.getTimeInMillis()) != offsetWinter || temp.getOffset(cal2.getTimeInMillis()) != offsetSummer || temp.getOffset(now.getTime()) != offsetNow) continue;
                if (switch1.getTime() != switch2.getTime()) {
                    int s1offset1 = temp.getOffset(cals1.getTimeInMillis());
                    cals1.add(12, 5);
                    int s1offset2 = temp.getOffset(cals1.getTimeInMillis());
                    cals1.setTime(switch1);
                    int s2offset1 = temp.getOffset(cals2.getTimeInMillis());
                    cals2.add(12, 5);
                    int s2offset2 = temp.getOffset(cals2.getTimeInMillis());
                    cals2.setTime(switch2);
                    if (s1offset1 == s1offset2 || s2offset1 == s2offset2) continue;
                    result = temp;
                    break;
                }
                result = temp;
                break;
            }
        }
        return result;
    }

    public AgentInitData getAgentInitData(AppDesc appDesc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int browserID = 0;
        float version = 0.0f;
        String sVersion = null;
        try {
            String header = request.getHeader("User-Agent");
            TraceMgr.trace((Object)this, (String)("Browser User-Agent header: " + header), (int)4);
            TraceMgr.trace((Object)this, (String)("Remote address: " + request.getRemoteAddr()), (int)4);
            int start = -1;
            if (header != null) {
                start = header.indexOf("MSIE");
                if (start != -1) {
                    browserID = 2;
                    start += 5;
                } else {
                    start = header.indexOf("Mozilla");
                    if (start != -1) {
                        browserID = 1;
                        if (header.indexOf("Chrome", start += 8) != -1) {
                            browserID = 5;
                        } else if (header.indexOf("Safari", start) != -1) {
                            browserID = 4;
                        }
                    }
                }
            }
            if (start != -1) {
                int nChars = 0;
                while (Character.isDigit(header.charAt(start + nChars)) || header.charAt(start + nChars) == '.') {
                    ++nChars;
                }
                if (nChars != 0) {
                    sVersion = header.substring(start, start + nChars);
                    version = Float.parseFloat(sVersion);
                }
            }
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, (String)("Failed to detect the browser, User-Agent=" + request.getHeader("User-Agent")), (Throwable)x, (int)1);
        }
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace((Object)this, (String)("Browser detected as " + browserID + ", version = " + version));
        }
        AgentInitData initData = new AgentInitData(browserID, version, appDesc.isInProcess(), appDesc.agents.size());
        if (browserID == 1 && (double)version < 5.0) {
            Locale defaultApplLocale = I18NUtils.getApplicationLocale(appDesc.getProps(), request);
            initData.setErrorMessage(I18NUtils.getMessage(I18NKeys.MESSAGE_OLD_BROWSER, defaultApplLocale));
            initData.setErrorMessageTitle(I18NUtils.getMessage(I18NKeys.MESSAGE_INTERNAL_ERROR_TITLE, defaultApplLocale));
            initData.setErrorMessageAutoRefreshText(I18NUtils.getMessage(I18NKeys.MESSAGE_INTERNAL_ERROR_AUTOREFRESH, defaultApplLocale));
            initData.setErrorRefreshTime(appDesc.getProps().getIntProperty("router.internal_error.refreshTime", 5));
        }
        String submitURL = this.getSubmitURL(appDesc, request, response);
        initData.setURLs(response.encodeURL(submitURL), ServletHelper.getDocsURL(appDesc, request));
        initData.setWebappRealPath(this.getDocsRealPath(appDesc, request));
        String locale = request.getParameter(appDesc.getProps().getProperty("http.url.locale", "locale"));
        if (!StringUtils.isEmpty((CharSequence)locale)) {
            initData.setLocale(locale);
        }
        return initData;
    }

    public static int getClientId(ClientAgentRemote agent) {
        return System.identityHashCode(agent);
    }

    public AppDesc getAppDesc(HttpServletRequest request, String appName) throws Exception {
        AppDesc appDesc;
        if (TraceMgr.getCutoffLevel() >= 7) {
            TraceMgr.trace((Object)this, (String)("getAppDesc for app name = " + appName), (int)7);
        }
        if ((appDesc = (AppDesc)appDescs.get(appName)) == null) {
            appDesc = this.createAppDesc(appName, request);
        }
        return appDesc;
    }

    public void parseAppNameAndAction(HttpServletRequest request, HttpRequestData data) throws Exception {
        String servletPath = request.getServletPath();
        if (TraceMgr.getCutoffLevel() >= 7) {
            TraceMgr.trace((Object)this, (String)("parseAppNameAndAction, servletPath = " + servletPath), (int)7);
        }
        if (!this.processRouterMode(request, data)) {
            if (servletPath.startsWith("/servlet/") || servletPath.startsWith("/apps/")) {
                int appNameStart = servletPath.indexOf(47, 1);
                data.setAppName(servletPath.substring(appNameStart + 1));
            } else {
                data.setAppName(servletPath.substring(1));
            }
            String action = request.getPathInfo();
            if (action != null) {
                if (action.startsWith("/")) {
                    action = action.substring(1);
                }
                data.setAction(action);
            }
        }
        if (data.getAppName() == null || data.getAppName().trim().length() == 0) {
            throw new AjaxSwingException("Application name should be specified as part of the URL");
        }
    }

    public boolean processRouterMode(HttpServletRequest request, HttpRequestData data) throws Exception {
        if (request.getServletPath().indexOf(AjaxSwingRouter.class.getName()) != -1) {
            this.setDataFromPath(data, request.getPathInfo());
            return true;
        }
        if (request.getServletPath().equals("/apps")) {
            this.setDataFromPath(data, request.getPathInfo());
            return true;
        }
        return false;
    }

    public Object getSessionAttribute(HttpSession session, String name) throws Exception {
        if (this.servletContext.getMajorVersion() >= 2 && this.servletContext.getMinorVersion() >= 2) {
            return session.getAttribute(name);
        }
        return session.getValue(name);
    }

    public void setSessionAttribute(HttpSession session, String name, Object value) {
        if (this.servletContext.getMajorVersion() >= 2 && this.servletContext.getMinorVersion() >= 2) {
            session.setAttribute(name, value);
        } else {
            session.putValue(name, value);
        }
    }

    public void removeSessionAttribute(HttpSession session, String name) throws Exception {
        if (this.servletContext.getMajorVersion() >= 2 && this.servletContext.getMinorVersion() >= 2) {
            session.removeAttribute(name);
        } else {
            session.removeValue(name);
        }
    }

    public void setDataFromPath(HttpRequestData data, String path) throws Exception {
        if (path == null || path.length() == 0) {
            throw new AjaxSwingException("Incorrect URL passed, path info should be specified");
        }
        int appNameStart = path.indexOf(47) + 1;
        int appNameEnd = path.indexOf(47, appNameStart);
        if (appNameEnd == -1) {
            data.setAppName(path.substring(appNameStart));
        } else {
            data.setAppName(path.substring(appNameStart, appNameEnd));
            data.setAction(path.substring(appNameEnd + 1));
        }
    }

    public static String getListenerName(String appName) {
        return appName + "Listener";
    }

    protected AppDesc createAppDesc(String appName, HttpServletRequest request) throws Exception {
        TraceMgr.trace((Object)this, (String)("createAppDesc, appName = " + appName));
        if (appDescs.size() >= AppDesc.APPS_LIMIT) {
            throw new AjaxSwingException("The maximum allowed number of applications has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing", false);
        }
        appName = appName.toLowerCase();
        InProcessAppDesc appDesc = new InProcessAppDesc(appName);
        this.initTempDir(appDesc, request);
        String uploadDirPath = appDesc.getProps().getProperty("router.uploadDir", appDesc.tempDirPath);
        this.fileUploadHandler = new FileUploadHandler(uploadDirPath);
        appDescs.put(appName, appDesc);
        return appDesc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initTempDir(AppDesc appDesc, HttpServletRequest request) throws Exception {
        String dirPath = this.getDocsRealPath(appDesc, request);
        File tempDir = new File(dirPath, "temp");
        appDesc.tempDirPath = tempDir.getCanonicalPath();
        TraceMgr.trace((Object)this, (String)("Initializing temporary directory " + appDesc.tempDirPath + ", exists = " + tempDir.exists()));
        if (tempDir.exists()) {
            File[] files = tempDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    TraceMgr.trace((Object)this, (String)("Deleting file " + files[i]), (int)6);
                    if (files[i].isDirectory()) {
                        this.deleteDir(files[i]);
                        continue;
                    }
                    if (!ImageUtils.canDelete(files[i].getName())) continue;
                    files[i].delete();
                    continue;
                }
                catch (Exception x) {
                    TraceMgr.trace((Object)this, (String)("Failed to delete temporary file " + files[i]), (Throwable)x);
                }
            }
            return;
        } else {
            try {
                if (tempDir.mkdir()) return;
                TraceMgr.trace((Object)this, (String)("Failed to create temporary directory " + tempDir.getCanonicalPath()));
                return;
            }
            catch (Exception x) {
                TraceMgr.trace((Object)this, (String)("Failed to create temporary directory " + tempDir.getCanonicalPath()), (Throwable)x);
            }
        }
    }

    protected boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public RouterRequestFilter getRequestFilter() {
        return this.requestFilter;
    }

    public static ServletHelper getInstance(ServletContext servletContext) throws Exception {
        if (instance == null) {
            instance = new ServletHelper(servletContext);
        }
        return instance;
    }

    Thread getRemoveTemporaryFileThread() {
        return this.removeTempFileThread;
    }

    static {
        calibrationDataPattern = Pattern.compile("^(?>[\\w\\d]+?,\\d+\\.?\\d*,\\d+\\.?\\d*;)*::(?>[\\w\\d]+?,\\d+\\.?\\d*,\\d+\\.?\\d*;)*$");
    }

    public class InProcessAppDesc
    extends AppDesc {
        public InProcessAppDesc(String appName) throws Exception {
            super(appName);
        }

        public void sessionExpired(Object session) {
            TraceMgr.trace((Object)((Object)this), (String)("Session expired for " + this.appName));
            ServletHelper.shutdownAgent(this, (Integer)session, this.getAgent(session));
        }
    }

    public static class InProcessClientAgent
    extends HTMLClientAgent {
        public InProcessClientAgent(String appName) throws Exception {
            super(null, appName);
        }

        class ClientAgentDelegate
        extends HTMLClientAgent {
            public ClientAgentDelegate(String agentName, String appName) throws Exception {
                super(agentName, appName);
            }
        }
    }
}

