/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.laf;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.laf.AjaxSwingLightTheme;
import com.creamtec.ajaxswing.laf.AjaxSwingTheme;
import com.creamtec.ajaxswing.laf.ui.AjaxSwingButtonUI;
import com.creamtec.ajaxswing.laf.ui.AjaxSwingEditorPaneUI;
import com.creamtec.ajaxswing.laf.ui.AjaxSwingRootPaneUI;
import com.creamtec.ajaxswing.laf.ui.AjaxSwingScrollBarUI;
import com.creamtec.ajaxswing.laf.ui.AjaxSwingTabbedPaneUI;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.ImageIconUIResource;

public class AjaxSwingLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 1L;
    public static boolean LFChangeAllowed = false;
    public static final UIManager.LookAndFeelInfo LOOK_AND_FEEL_INFO = new UIManager.LookAndFeelInfo("AjaxSwing", AjaxSwingLookAndFeel.class.getName());
    private transient AjaxSwingTheme theme = new AjaxSwingLightTheme();

    public AjaxSwingTheme getTheme() {
        return this.theme;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.theme.installDefaults();
        AjaxSwingLookAndFeel.setCurrentTheme(this.theme);
    }

    @Override
    public void uninitialize() {
        if (!LFChangeAllowed) {
            throw new RuntimeException("Changing look and feel not allowed, use agent.allowLFChange=true");
        }
    }

    @Override
    public String getName() {
        return LOOK_AND_FEEL_INFO.getName();
    }

    @Override
    public String getDescription() {
        return "A slim look and feel based on Metal.";
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        try {
            Class cl = AjaxSwingTabbedPaneUI.class;
            table.put("TabbedPaneUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = AjaxSwingRootPaneUI.class;
            table.put("RootPaneUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = AjaxSwingButtonUI.class;
            table.put("ButtonUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = AjaxSwingScrollBarUI.class;
            table.put("ScrollBarUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = AjaxSwingEditorPaneUI.class;
            table.put("EditorPaneUI", cl.getName());
            table.put(cl.getName(), cl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
    }

    public static void install() {
        if (!Arrays.asList(UIManager.getInstalledLookAndFeels()).contains(LOOK_AND_FEEL_INFO)) {
            UIManager.installLookAndFeel(LOOK_AND_FEEL_INFO);
        }
    }

    static Icon getDisabledButtonIcon(Image image) {
        Object[] range = (Object[])UIManager.get("Button.disabledGrayRange");
        int min = 180;
        int max = 215;
        if (ClientAgent.getCurrentInstance().getProps().getBooleanProperty("laf.darkDisabledIcons", false)) {
            min -= 45;
            max -= 35;
        }
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), new DisabledButtonImageFilter(min, max));
        return new ImageIconUIResource(Toolkit.getDefaultToolkit().createImage(prod));
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon instanceof ImageIcon) {
            return AjaxSwingLookAndFeel.getDisabledButtonIcon(((ImageIcon)icon).getImage());
        }
        return super.getDisabledIcon(component, icon);
    }

    private static class DisabledButtonImageFilter
    extends RGBImageFilter {
        private float min;
        private float factor;

        DisabledButtonImageFilter(int min, int max) {
            this.canFilterIndexColorModel = true;
            this.min = min;
            this.factor = (float)(max - min) / 255.0f;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = Math.min(255, (int)((0.2125f * (float)(rgb >> 16 & 0xFF) + 0.7154f * (float)(rgb >> 8 & 0xFF) + 0.0721f * (float)(rgb & 0xFF) + 0.5f) * this.factor + this.min));
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private final Border normalBorder;
        private final Border focusBorder;

        MyListCellRenderer(Border normalBorder, Border focusBorder) {
            this.normalBorder = normalBorder;
            this.focusBorder = focusBorder;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setBorder(cellHasFocus ? this.focusBorder : this.normalBorder);
            return label;
        }

        public static class UIResource
        extends MyListCellRenderer
        implements javax.swing.plaf.UIResource {
            public UIResource(Border normalBorder, Border focusBorder) {
                super(normalBorder, focusBorder);
            }
        }
    }
}

