/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.gui.AjaxSwingToolkit;
import com.creamtec.ajaxswing.rendering.AbstractDocument;
import com.creamtec.ajaxswing.rendering.Document;
import com.creamtec.ajaxswing.rendering.RenderContext;
import com.creamtec.ajaxswing.rendering.TemplateEngine;
import com.creamtec.ajaxswing.rendering.html.HTMLPageRenderer;
import com.creamtec.ajaxswing.v4.render.SnapshotRenderer;
import com.creamtec.core.TraceMgr;
import freemarker.template.Template;
import java.awt.Component;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class HTMLPage
extends AbstractDocument {
    private StringBuilder body;
    private StringBuilder header;
    private StringBuilder windowFooter;
    private StringBuilder headerScript;
    private StringBuilder tooltipHtml;
    private String onLoadFunctionBody = "";
    private boolean useOnLoad = true;
    protected int previousPageLength = 10000;
    protected Hashtable themeDocsStampURLTable = new Hashtable();
    private int snapshotIndex = 0;
    private Component v4RootComponent;

    public HTMLPage() {
        TraceMgr.trace((Object)((Object)this), (String)"constructor");
        this.body = new StringBuilder(600);
        this.windowFooter = new StringBuilder(100);
        this.header = new StringBuilder(400);
        this.headerScript = new StringBuilder(400);
    }

    public HTMLPage(HTMLPage page) {
        if (page.getClientAgent() != null) {
            this.setClientAgent(page.getClientAgent());
        }
    }

    public HTMLPageRenderer getPageRenderer() {
        return (HTMLPageRenderer)this.getDocumentRenderer();
    }

    public void setRenderContext(RenderContext context) {
        this.context = context;
    }

    public StringBuilder getBody() {
        return this.body;
    }

    public StringBuilder getWindowFooter() {
        return this.windowFooter;
    }

    public void clearWindowFooter() {
        this.windowFooter = new StringBuilder();
    }

    public StringBuilder getHeader() {
        return this.header;
    }

    public StringBuilder getHeaderScript() {
        return this.headerScript;
    }

    public String toString() {
        HashMap<String, HTMLPage> root = new HashMap<String, HTMLPage>();
        root.put("page", this);
        root.put("agent", (HTMLPage)this.getClientAgent());
        try {
            String templateName = this.getClientAgent().getProps().getProperty("html.template.page", "default-page/page.html");
            Template template = TemplateEngine.getInstance().getConfiguration().getTemplate(templateName);
            StringWriter writer = new StringWriter(this.body.length() + this.header.length() + this.headerScript.length() + 100);
            template.process(root, (Writer)writer);
            String output = writer.toString();
            AjaxSwingSecurityManager.assertUnbrokenEdition((String)output);
            return output;
        }
        catch (Exception e) {
            throw new AjaxSwingException("Failed to process page template", (Throwable)e);
        }
    }

    public String getCssClass() {
        return "";
    }

    public String getSubmitURL() {
        return this.getClientAgent().getInitData().submitURL;
    }

    public static String generateName(Object obj) {
        return NameUtils.getComponentName((Object)obj);
    }

    public void reset(boolean complete) {
        TraceMgr.trace((Object)((Object)this), (String)("Reset, complete = " + complete), (int)6);
        super.reset(complete);
        this.setChanged();
        this.notifyObservers((Object)this);
        this.clear();
        if (complete) {
            this.getRenderContext().reset();
            this.getProps().clear();
        }
        this.getClientAgent().getPageRenderer().initializeDocument((Document)this);
    }

    protected void clear() {
        this.body = new StringBuilder();
        this.windowFooter = new StringBuilder();
        this.header = new StringBuilder();
        this.headerScript = new StringBuilder();
        this.onLoadFunctionBody = "";
        this.useOnLoad = true;
    }

    public static String getComponentName(MenuBar comp) {
        String name = HTMLPage.generateName(comp);
        return name;
    }

    public String getComponentName(Component comp) {
        String name = HTMLPage.generateName(comp);
        return name;
    }

    public String getImageUrl(Icon icon, Component component) {
        Image image;
        String url = null;
        if (icon instanceof ImageIcon && (url = AjaxSwingToolkit.getImageUrl((Image)(image = ((ImageIcon)icon).getImage()))) == null) {
            url = AjaxSwingToolkit.getImageFileName((Image)image);
        }
        if (url == null) {
            url = AjaxSwingToolkit.getIconFileName((Icon)icon, (Component)component);
        }
        if (url == null) {
            if (TraceMgr.getCutoffLevel() >= 6) {
                TraceMgr.trace((Object)((Object)this), (String)("Failed to find source for icon " + icon), (int)6);
            }
            if (icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
                SnapshotRenderer snapshotRenderer = SnapshotRenderer.getInstance();
                BufferedImage iconImage = snapshotRenderer.generateIconImage(this, component, icon);
                String imageName = snapshotRenderer.generateIconImageFile(this, iconImage, false);
                StringBuffer iconUrl = new StringBuffer(50);
                iconUrl.append(this.getDocsURL());
                iconUrl.append("/temp/");
                iconUrl.append(imageName);
                iconUrl.append("?a=");
                iconUrl.append((int)(Math.random() * 10000.0));
                url = iconUrl.toString();
            } else {
                TraceMgr.trace((Object)((Object)this), (String)("*** WARNING: unable to generate icon image due to invalid size: " + icon.getIconWidth() + "x" + icon.getIconHeight()), (int)3);
                url = "invalidIconSize";
            }
            return url;
        }
        if (url.startsWith("http://")) {
            return url;
        }
        return this.getThemeDocsURL() + this.cleanupImageUrl(url);
    }

    public String getImageUrl(Image image) {
        String url = AjaxSwingToolkit.getImageUrl((Image)image);
        if (url == null) {
            url = AjaxSwingToolkit.getImageFileName((Image)image);
        }
        if (url == null) {
            TraceMgr.trace((Object)((Object)this), (String)("*** WARNING: failed to find source for image " + image.getClass().getName()), (int)3);
            url = "java/Inform.gif";
        }
        if (url.startsWith("http://")) {
            return url;
        }
        return this.getThemeDocsURL() + this.cleanupImageUrl(url);
    }

    public String cleanupImageUrl(String url) {
        if (TraceMgr.getCutoffLevel() >= 10) {
            TraceMgr.trace((Object)((Object)this), (String)("CleanupImageUrl " + url), (int)10);
        }
        if (url == null || url.length() == 0) {
            TraceMgr.trace((Object)((Object)this), (String)"*** WARNING - empty URL", (int)3);
            return url;
        }
        if (url.startsWith("jar:")) {
            int i = url.indexOf(33);
            if (i != -1) {
                url = url.substring(++i);
            } else {
                TraceMgr.trace((Object)((Object)this), (String)("***WARNING - unexpected URL " + url), (int)1);
            }
        } else if (url.startsWith(".")) {
            int n;
            for (n = 0; url.charAt(n) == '.' || url.charAt(n) == '/' || url.charAt(n) == '\\' && n < url.length(); ++n) {
            }
            url = url.substring(n);
        } else if (url.charAt(0) == '/' || url.charAt(0) == '\\' || url.indexOf(58) != -1) {
            int n;
            for (n = url.length() - 1; n > 0 && url.charAt(n) != '/' && url.charAt(n) != '\\'; --n) {
            }
            url = url.substring(n);
        }
        if (url.indexOf(92) != -1) {
            url = url.replace('\\', '/');
        }
        if (url.length() > 0 && url.charAt(0) != '/') {
            return "/images/" + url;
        }
        return "/images" + url;
    }

    public String getTempFileURL(String fileName) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getDocsURL());
        buffer.append("/temp/");
        buffer.append(fileName);
        buffer.append("?a=");
        buffer.append((int)(Math.random() * 10000.0));
        return buffer.toString();
    }

    public void appendOnLoadScriptBody(String onLoadFunctionBody) {
        this.onLoadFunctionBody = this.onLoadFunctionBody + onLoadFunctionBody;
    }

    public String getOnLoadScriptBody() {
        return this.onLoadFunctionBody;
    }

    public void setUseOnLoad(boolean useOnLoad) {
        this.useOnLoad = useOnLoad;
    }

    public void beforeRender() {
        super.beforeRender();
        this.body.ensureCapacity(this.previousPageLength);
    }

    public void afterRender() {
        super.afterRender();
        this.previousPageLength = this.body.length();
        this.clear();
    }

    public void appendWindowFooter() {
        this.body.append(this.getWindowFooter().toString());
        this.clearWindowFooter();
    }

    public String getThemeDocsStampURL(String name) {
        return this.getDocsStampURL("/" + this.getThemeName() + "_docs" + name);
    }

    public String getDocsStampURL(String name) {
        Object result = this.themeDocsStampURLTable.get(name);
        if (result != null) {
            return (String)result;
        }
        result = this.getDocsURL() + name;
        File file = new File(this.getClientAgent().getInitData().getWebappRealPath() + name);
        if (file.exists()) {
            result = this.getDocsURL() + name + "?v=" + file.lastModified();
        }
        this.themeDocsStampURLTable.put(name, result);
        return (String)result;
    }

    public void appendHeaderScript(String script) {
        this.headerScript.append(script);
    }

    public int getSnapshotImageIndex() {
        return this.snapshotIndex;
    }

    public void incSnapshotIndex() {
        ++this.snapshotIndex;
    }

    public int getNextComponentNameIndex(Object obj) {
        return 0;
    }

    public void setV4RootComponent(Component v4RootComponent) {
        this.v4RootComponent = v4RootComponent;
    }

    public Component getV4RootComponent() {
        return this.v4RootComponent;
    }
}

