/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html.positioned;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxComponentState;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxComponentStateComparator;
import com.creamtec.ajaxswing.rendering.html.positioned.AjaxResponse;
import com.creamtec.ajaxswing.rendering.html.positioned.ComponentHash;
import com.creamtec.ajaxswing.rendering.html.positioned.ComponentState;
import com.creamtec.ajaxswing.rendering.html.positioned.PageInterval;
import com.creamtec.ajaxswing.v4.utils.ComponentUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import javax.swing.SwingHelper;
import javax.swing.SwingUtilities;
import org.codehaus.jackson.map.ObjectMapper;

public class AjaxPage
extends HTMLPage {
    public static final int MAX_TIME_FOR_WRITE_FILE = 600000;
    protected HashMap<String, ComponentHash> previousComponentHashes = new HashMap();
    protected HashMap<String, ComponentHash> componentHashes = new HashMap();
    protected HashMap<String, AjaxComponentState> componentStates = new HashMap();
    protected HashMap<Component, Boolean> componentDirtyStates = new HashMap();
    protected Stack<AjaxComponentState> componentStatesStack = new Stack();
    protected boolean partialUpdateAvailable;
    protected ObjectMapper jsonSerializer = new ObjectMapper();
    protected AjaxResponse ajaxResponse;

    public HashMap<String, ComponentHash> getPreviousComponentHashes() {
        return this.previousComponentHashes;
    }

    public void setPreviousComponentHashes(HashMap<String, ComponentHash> previousComponentHashes) {
        this.previousComponentHashes = previousComponentHashes;
    }

    public void setAjaxResponse(AjaxResponse ajaxResponse) {
        this.ajaxResponse = ajaxResponse;
    }

    public void startInterval(Object component) {
        this.startInterval(component, "");
    }

    public void startInterval(Object component, String namePostfix) {
        if (!this.componentStatesStack.isEmpty()) {
            AjaxComponentState parentState = this.componentStatesStack.peek();
            PageInterval lastInterval = parentState.getLastInterval();
            if (lastInterval.output == null) {
                lastInterval.output = this.getBody();
            }
            lastInterval.end = lastInterval.output.length();
        }
        AjaxComponentState ajaxState = new AjaxComponentState(component, this, namePostfix);
        ajaxState.startInterval(this);
        this.componentStatesStack.push(ajaxState);
        ComponentHash oldHash = this.getPreviousComponentHashes().get(ajaxState.getState().getComponentId());
        ajaxState.partialUpdateAllowed = this.isPartialUpdateAllowed();
        if (oldHash == null) {
            this.setPartialUpdateAllowed(false);
        }
        if (component instanceof JDialog) {
            AjaxSwingProperties.setClientProperty((Component)((JDialog)component).getLayeredPane(), (String)"componentParentId", (Object)ajaxState.getState().getComponentId());
        }
    }

    public void endInterval(Object component) {
        AjaxComponentState ajaxState = this.componentStatesStack.pop();
        ajaxState.endInterval(this);
        AjaxComponentState parentState = null;
        if (!this.componentStatesStack.isEmpty()) {
            parentState = this.componentStatesStack.peek();
            parentState.startInterval(this);
        }
        if (!ajaxState.ignoreThisState()) {
            boolean partialUpdateAllowed;
            ComponentHash oldHash = this.getPreviousComponentHashes().get(ajaxState.getState().getComponentId());
            ajaxState.computeHash(this);
            Integer windowHash = new Integer(this.getRenderContext().getWindow() != null ? this.getRenderContext().getWindow().hashCode() : 0);
            ComponentHash componentHash = new ComponentHash(ajaxState.getState().getParentId(), ajaxState.getHash(), windowHash);
            this.getComponentHashes().put(ajaxState.getState().getComponentId(), componentHash);
            boolean bl = partialUpdateAllowed = ajaxState.partialUpdateAllowed && ajaxState.getPageIntervals().size() > 0;
            if (!partialUpdateAllowed && parentState != null && parentState.hasIntervals() && ajaxState.hasIntervals() && parentState.getLastInterval().output != ajaxState.getLastInterval().output) {
                partialUpdateAllowed = true;
            }
            if (partialUpdateAllowed) {
                this.determineAjaxAction(component, ajaxState, oldHash);
            }
        }
        this.setPartialUpdateAllowed(ajaxState.partialUpdateAllowed);
    }

    protected void determineAjaxAction(Object component, AjaxComponentState ajaxState, ComponentHash oldHash) {
        AjaxComponentState actionableState = null;
        if (oldHash != null) {
            if (this.shouldUpdateComponent(ajaxState.getHash(), oldHash.hash, component)) {
                ajaxState.getState().setAction(3);
                if (this.isPartialUpdateAllowed()) {
                    actionableState = ajaxState;
                }
            }
        } else {
            ajaxState.getState().setAction(2);
            actionableState = ajaxState;
        }
        if (actionableState != null) {
            this.setComponentHtml(actionableState);
            this.getComponentStates().put(ajaxState.getState().getComponentId(), actionableState);
        }
        if (TraceMgr.getCutoffLevel() > 9) {
            TraceMgr.trace((Object)((Object)this), (String)("Component state for " + ajaxState.getState().getComponentId() + " is " + ComponentState.getActionDescription(ajaxState.getState().getAction())), (int)10);
        }
    }

    protected boolean shouldUpdateComponent(int newHash, int oldHash, Object component) {
        boolean shouldUpdateComponent = newHash != oldHash;
        Boolean dirtyState = this.getComponentDirtyStates().get(component);
        return dirtyState != null ? dirtyState : shouldUpdateComponent;
    }

    protected void setComponentHtml(AjaxComponentState actionableState) {
        int start = actionableState.getFirstInterval().start;
        int end = actionableState.getLastInterval().end;
        StringBuilder output = actionableState.getLastInterval().output;
        actionableState.getState().setHtml(output.substring(start, end));
    }

    public ComponentState[] getActionableComponentStates() {
        LinkedHashMap<String, ComponentState> deletedStates = new LinkedHashMap<String, ComponentState>();
        TraceMgr.trace((Object)((Object)this), (String)("Previous components size = " + this.getPreviousComponentHashes().size()), (int)9);
        for (String key : this.getPreviousComponentHashes().keySet()) {
            ComponentHash value;
            ComponentHash previousValue = this.getPreviousComponentHashes().get(key);
            if (this.getRenderContext().wasWindowBlocked(previousValue.windowHash) || (value = this.getComponentHashes().get(key)) != null) continue;
            ComponentState state = new ComponentState(key);
            state.setAction(1);
            deletedStates.put(key, state);
        }
        ArrayList<AjaxComponentState> actionableAjaxStates = new ArrayList<AjaxComponentState>();
        for (AjaxComponentState ajaxState : this.getComponentStates().values()) {
            if (ajaxState.component instanceof Window) {
                actionableAjaxStates.add(ajaxState);
                continue;
            }
            if (!(ajaxState.component instanceof Component) || this.parentStateChanged(ajaxState, this.getComponentStates())) continue;
            actionableAjaxStates.add(ajaxState);
        }
        ArrayList<ComponentState> actionableStates = new ArrayList<ComponentState>(actionableAjaxStates.size());
        for (ComponentState state : deletedStates.values()) {
            if (this.deletedParentStateChanged(state.getComponentId(), deletedStates)) continue;
            actionableStates.add(state);
        }
        this.appendActionableAjaxStates(actionableStates, actionableAjaxStates);
        TraceMgr.trace((Object)((Object)this), (String)("Actionable components size = " + actionableStates.size()), (int)5);
        ComponentState[] array = new ComponentState[actionableStates.size()];
        actionableStates.toArray(array);
        return array;
    }

    protected void appendActionableAjaxStates(List<ComponentState> actionableStates, List<AjaxComponentState> actionableAjaxStates) {
        Collections.sort(actionableAjaxStates, new AjaxComponentStateComparator());
        ArrayList<ComponentState> moreActionableStates = new ArrayList<ComponentState>(actionableAjaxStates.size());
        for (int i = 0; i < actionableAjaxStates.size(); ++i) {
            AjaxComponentState ajaxState = actionableAjaxStates.get(i);
            moreActionableStates.add(ajaxState.getState());
        }
        actionableStates.addAll(moreActionableStates);
    }

    protected boolean parentStateChanged(AjaxComponentState ajaxState, Map<String, AjaxComponentState> componentStates) {
        Component component = (Component)ajaxState.component;
        while (component.getParent() != null) {
            String parentId = NameUtils.getComponentName((Object)(component = component.getParent()));
            if (!componentStates.containsKey(parentId)) continue;
            return true;
        }
        return ajaxState.state.getParentId() != null && componentStates.containsKey(ajaxState.state.getParentId());
    }

    protected boolean deletedParentStateChanged(String id, Map<String, ComponentState> deletedStates) {
        ComponentHash hash = this.getPreviousComponentHashes().get(id);
        while (hash != null) {
            if (hash.parentId == null) {
                return false;
            }
            if (deletedStates.containsKey(hash.parentId)) {
                return true;
            }
            if (this.getComponentStates().containsKey(hash.parentId)) {
                return true;
            }
            hash = this.getPreviousComponentHashes().get(hash.parentId);
        }
        return false;
    }

    @Override
    public void beforeRender() {
        super.beforeRender();
        this.partialUpdateAvailable = this.isPartialUpdateAllowed() ? this.getPreviousComponentHashes().size() != 0 : false;
    }

    @Override
    public void afterRender() {
        super.afterRender();
        if (this.getRenderContext().blockedWindows.size() > 0) {
            HashMap<String, ComponentHash> map = new HashMap<String, ComponentHash>();
            for (String key : this.getPreviousComponentHashes().keySet()) {
                ComponentHash hash = this.getPreviousComponentHashes().get(key);
                if (!this.getRenderContext().blockedWindows.containsKey(hash.windowHash)) continue;
                map.put(key, hash);
            }
            map.putAll((Map)this.getComponentHashes().clone());
            this.setPreviousComponentHashes(map);
        } else {
            this.setPreviousComponentHashes((HashMap)this.getComponentHashes().clone());
        }
        this.getComponentDirtyStates().clear();
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace((Object)((Object)this), (String)("Saved hashes for future comparison size = " + this.getPreviousComponentHashes().size()));
        }
    }

    public HashMap<String, ComponentHash> getComponentHashes() {
        return this.componentHashes;
    }

    public void setComponentHashes(HashMap<String, ComponentHash> componentHashes) {
        this.componentHashes = componentHashes;
    }

    public HashMap<String, AjaxComponentState> getComponentStates() {
        return this.componentStates;
    }

    public AjaxComponentState peekComponentState() {
        return this.componentStatesStack.peek();
    }

    public void setComponentStates(HashMap<String, AjaxComponentState> componentStates) {
        this.componentStates = componentStates;
    }

    @Override
    public String toString() {
        if (this.partialUpdateAvailable) {
            try {
                TraceMgr.trace((Object)((Object)this), (String)"Returning partial update", (int)6);
                this.ajaxResponse.setActionableComponentStates(this.getActionableComponentStates());
                this.ajaxResponse.setClientHeigth(this.getClientAgent().getInitData().clientHeight);
                this.ajaxResponse.setClientWidth(this.getClientAgent().getInitData().clientWidth);
                this.ajaxResponse.setUpdateInterval(this.getClientAgent().getUpdateBrowserInterval());
                this.ajaxResponse.setRedirectURL(this.getRedirectURL());
                ClientAgent agent = ClientAgent.getCurrentInstance();
                if (agent.getAppendJavaScript() != null) {
                    this.ajaxResponse.setScript(this.ajaxResponse.getScript() + agent.getAppendJavaScript());
                    agent.clearAppendJavaScript();
                }
                if (agent.getUrlForOpenInNewTab() != null) {
                    this.ajaxResponse.setUrlForOpenInNewTab(agent.getUrlForOpenInNewTab());
                    agent.clearUrlForOpenInNewTab();
                }
                this.responseProcessActiveWindow(this.ajaxResponse);
                this.responseProcessDownload(this.ajaxResponse);
                String jsonResponse = this.jsonSerializer.writeValueAsString((Object)this.ajaxResponse);
                return jsonResponse;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        TraceMgr.trace((Object)((Object)this), (String)"Returning full HTML page", (int)6);
        ClientAgent agent = ClientAgent.getCurrentInstance();
        if (agent.getAppendJavaScript() != null) {
            this.getBody().append("<script type=\"text/javascript\">");
            this.getBody().append(agent.getAppendJavaScript());
            if (agent.getUrlForOpenInNewTab() != null) {
                agent.appendJavaScript("\nopen(\"" + agent.getUrlForOpenInNewTab() + "\");\n");
                agent.clearUrlForOpenInNewTab();
            }
            this.getBody().append("</script>");
            agent.clearAppendJavaScript();
        }
        return super.toString();
    }

    protected void responseProcessActiveWindow(AjaxResponse ajaxResponse) {
        Component focusedComponent;
        Container activeWindow = ComponentUtils.getActiveWindow();
        if (activeWindow != null) {
            ajaxResponse.setActiveWindowId(activeWindow == null ? null : NameUtils.getComponentName((Object)activeWindow));
            if (TraceMgr.getCutoffLevel() >= 9) {
                TraceMgr.trace((Object)((Object)this), (String)("Active window id = " + NameUtils.getComponentName((Object)activeWindow)));
            }
        }
        if ((focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(focusedComponent, activeWindow) && focusedComponent.isVisible()) {
            ajaxResponse.setFocusedComponentId(NameUtils.getComponentName((Object)focusedComponent));
            if (TraceMgr.getCutoffLevel() >= 9) {
                TraceMgr.trace((Object)((Object)this), (String)("Focused component id = " + NameUtils.getComponentName((Object)focusedComponent)));
            }
        }
    }

    private String getFileTitle(String name) {
        int iLastDot;
        int iLastSlash = name.lastIndexOf(47);
        if (iLastSlash < 0) {
            iLastSlash = name.lastIndexOf(92);
        }
        if ((iLastDot = name.lastIndexOf(46)) < 0) {
            iLastDot = name.length();
        }
        return name.substring(iLastSlash + 1, iLastDot);
    }

    protected void responseProcessDownload(AjaxResponse ajaxResponse) {
        Map downloadFileNames = this.getClientAgent().getDownloadFileNames();
        if (downloadFileNames != null && !downloadFileNames.isEmpty()) {
            for (String downloadFileName : downloadFileNames.keySet()) {
                String downloadFileURL;
                File downloadFile = new File(downloadFileName);
                if (downloadFile.isDirectory()) {
                    String zippedContentFileName = this.zipDirectoryForDownload(downloadFile);
                    if (zippedContentFileName == null) {
                        TraceMgr.trace((String)"Directory download unsuccessful - no content", (int)2);
                        this.getClientAgent().removeDownloadFileName(downloadFileName);
                        this.getClientAgent().denyDownload(downloadFile);
                        continue;
                    }
                    Long folderTimeCreation = (Long)downloadFileNames.get(downloadFileName);
                    downloadFileNames.remove(downloadFileName);
                    downloadFileNames.put(zippedContentFileName, folderTimeCreation);
                    downloadFileName = zippedContentFileName;
                    downloadFile = new File(zippedContentFileName);
                }
                if (!downloadFile.exists()) {
                    TraceMgr.trace((String)("File doesn't ready for download " + downloadFileName), (int)5);
                    if (System.currentTimeMillis() - (Long)this.getClientAgent().getDownloadFileNames().get(downloadFileName) <= 600000L) continue;
                    TraceMgr.trace((String)("File doesn't ready for download more then 10 minutes, deny it " + downloadFileName), (int)2);
                    this.getClientAgent().removeDownloadFileName(downloadFileName);
                    this.getClientAgent().denyDownload(downloadFile);
                    continue;
                }
                String shortFileName = this.getClientAgent().getShortFileName(downloadFileName);
                try {
                    downloadFileURL = this.getSubmitURL() + "?downloadFileName=" + URLEncoder.encode(shortFileName, "UTF-8").replaceAll("\\+", "%20");
                }
                catch (UnsupportedEncodingException ex) {
                    downloadFileURL = this.getSubmitURL() + "?downloadFileName=" + shortFileName;
                    TraceMgr.trace((String)"Failed to encode url", (Throwable)ex);
                }
                if (TraceMgr.getCutoffLevel() >= 5) {
                    TraceMgr.trace((Object)((Object)this), (String)("Added file to downloadFileURLs in response " + downloadFileURL), (int)5);
                }
                ajaxResponse.addDownloadFileURL(downloadFileURL);
                this.getClientAgent().allowDownload(shortFileName);
                this.getClientAgent().removeDownloadFileName(downloadFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zipDirectoryForDownload(File downloadFile) {
        String fileToDownload = null;
        try {
            File dir = downloadFile;
            File[] content = dir.listFiles();
            if (content.length == 1) {
                File outFile = new File(downloadFile.getParentFile(), content[0].getName());
                fileToDownload = outFile.getPath();
                content[0].renameTo(outFile);
            } else if (content.length > 1) {
                String zipName = this.getFileTitle(content[0].getName());
                boolean sameTitle = true;
                for (int i = 1; i < content.length; ++i) {
                    if (zipName.equals(this.getFileTitle(content[i].getName()))) continue;
                    sameTitle = false;
                    break;
                }
                if (!sameTitle) {
                    zipName = downloadFile.getName();
                }
                fileToDownload = new File(downloadFile.getParentFile(), downloadFile.getName() + "_" + zipName + ".zip").getPath();
                FileOutputStream os = new FileOutputStream(fileToDownload);
                ZipOutputStream zo = new ZipOutputStream(new BufferedOutputStream(os));
                int BUFFER = 65536;
                byte[] data = new byte[BUFFER];
                for (File file : content) {
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    BufferedInputStream origin = null;
                    try {
                        int count;
                        zo.putNextEntry(zipEntry);
                        FileInputStream fi = new FileInputStream(file);
                        origin = new BufferedInputStream(fi, BUFFER);
                        while ((count = origin.read(data, 0, BUFFER)) != -1) {
                            zo.write(data, 0, count);
                        }
                    }
                    finally {
                        if (origin != null) {
                            try {
                                origin.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    zo.closeEntry();
                }
                zo.close();
            }
            for (File file : content) {
                file.delete();
            }
            downloadFile.getParentFile().delete();
        }
        catch (Exception e) {
            TraceMgr.trace((String)"Zipping to download failed", (Throwable)e);
        }
        return fileToDownload;
    }

    @Override
    public void reset(boolean complete) {
        super.reset(complete);
        this.componentHashes.clear();
        this.componentStates.clear();
        this.componentStatesStack.clear();
        this.componentDirtyStates.clear();
        this.setPartialUpdateAllowed(true);
        this.setAjaxResponse(new AjaxResponse());
    }

    public void setClientAgent(ClientAgent agent) {
        super.setClientAgent(agent);
    }

    public ObjectMapper getJsonSerializer() {
        return this.jsonSerializer;
    }

    public void setJsonSerializer(ObjectMapper jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public HashMap<Component, Boolean> getComponentDirtyStates() {
        return this.componentDirtyStates;
    }

    public void setComponentDirtyStates(HashMap<Component, Boolean> componentDirtyStates_) {
        this.componentDirtyStates = componentDirtyStates_;
    }

    public void setComponentDirty(Component component, boolean dirty) {
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace((Object)((Object)this), (String)("Setting component " + NameUtils.getComponentName((Object)component) + " dirty = " + dirty), (int)6);
        }
        if (dirty) {
            if (SwingHelper.isRecursivelyVisible((Component)component)) {
                this.getComponentDirtyStates().put(component, dirty);
            }
        } else {
            this.getComponentDirtyStates().put(component, dirty);
        }
    }

    public boolean isComponentDirty(Component component) {
        return Boolean.TRUE.equals(this.getComponentDirtyStates().get(component));
    }

    public void setRedirectURL(String url) {
        super.setRedirectURL(url);
        if (this.isPartialUpdateAllowed()) {
            this.partialUpdateAvailable = true;
        }
    }
}

