/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.ui;

import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.gui.VersionHelper;
import com.creamtec.ajaxswing.ui.AboutDialog;
import com.creamtec.ajaxswing.ui.AppWizard;
import com.creamtec.ajaxswing.ui.SplashScreen;
import com.creamtec.ajaxswing.ui.WebServerManager;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class AjaxSwingConsole
extends JFrame {
    Icon icnAppWizard = new ImageIcon("images/AppWizard.gif");
    Icon icnStartServer = new ImageIcon("images/StartServer.gif");
    Icon icnStopServer = new ImageIcon("images/StopServer.gif");
    Icon icnAjaxSwingDemo = new ImageIcon("images/AjaxSwingDemo.gif");
    int viewMenuItemCount = 0;
    JScrollPane scrPane = new JScrollPane();
    JEditorPane edpBody = new JEditorPane();
    JMenuBar mnbMain = new JMenuBar();
    JMenu mnuFile = new JMenu();
    JMenuItem mniExit = new JMenuItem();
    JMenu mnuHelp = new JMenu();
    JRadioButtonMenuItem rbtSetup = new JRadioButtonMenuItem();
    JRadioButtonMenuItem rbtLicense = new JRadioButtonMenuItem();
    JMenu mnuTools = new JMenu();
    JMenuItem mniAbout = new JMenuItem();
    JMenuItem mniAppWizard = new JMenuItem();
    ButtonGroup viewGroup = new ButtonGroup();
    JToolBar toolBar = new JToolBar();
    JButton btnWizard = new JButton();
    JMenuItem mniStartWebserver = new JMenuItem();
    JMenuItem mniStopWebserver = new JMenuItem();
    JLabel statusBar = new JLabel();
    WebServerManager webServerManager;
    protected JButton btnStartServer = new JButton();
    protected JButton btnStopServer = new JButton();
    protected JButton btnPreview = new JButton();
    protected JMenuItem mniDemoApp = new JMenuItem();
    protected JMenu mnuView = new JMenu();
    ActionListener viewAppListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AjaxSwingConsole.this.viewApp("http://localhost:8040/ajaxswing/apps/" + e.getActionCommand());
        }
    };

    public AjaxSwingConsole() throws Exception {
        try {
            this.jbInit();
            this.viewGroup.add(this.rbtLicense);
            this.viewGroup.add(this.rbtSetup);
            Image icon = Toolkit.getDefaultToolkit().getImage("images/AjaxSwing.gif");
            if (icon != null) {
                this.setIconImage(icon);
            }
            this.reloadViewMenu();
            this.webServerManager = new WebServerManager(this);
            this.updateWebServerRunningUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        block4: {
            String javaHome = System.getProperty("env.JAVA_HOME");
            if (javaHome == null || javaHome.length() == 0) {
                JOptionPane.showMessageDialog(null, "<html>JAVA_HOME environment variable should be set to point to JDK installation directory.<br>Built-in web server may fail.</html>", "Warning", 2);
            }
            TraceMgr.setLoadSettings((boolean)false);
            try {
                VersionHelper.init((boolean)false);
            }
            catch (SecurityException securityException) {
            }
            catch (Exception x) {
                String message = "<html>" + x.getMessage() + "</html>";
                if (JOptionPane.showConfirmDialog(null, message, "Do you want to continue?", 0) == 0) break block4;
                System.exit(1);
            }
        }
        final SplashScreen splash = AjaxSwingConsole.showSplashScreen();
        AjaxSwingConsole console = new AjaxSwingConsole();
        console.setSize(800, 600);
        console.displayFile(".." + File.separator + "license.txt");
        console.setVisible(true);
        AjaxSwingConsole.reshowSplashScreen(splash);
        splash.addFocusListener(new FocusAdapter(){
            int skipTimes = 1;

            @Override
            public void focusLost(FocusEvent e) {
                if (this.skipTimes-- > 0) {
                    splash.toFront();
                    splash.requestFocus();
                } else {
                    splash.dispose();
                }
            }
        });
    }

    public static void reshowSplashScreen(final SplashScreen splash) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splash.lblStatus.setText("Ready. Click outside of this window to dismiss it");
                splash.toFront();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        splash.dispose();
                    }
                }.start();
            }
        });
    }

    static SplashScreen showSplashScreen() {
        final SplashScreen splash = new SplashScreen("AjaxSwing Console");
        splash.setLocationRelativeTo(null);
        splash.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                splash.dispose();
            }
        });
        splash.setVisible(true);
        return splash;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.mnbMain);
        this.setTitle("AjaxSwing Console");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AjaxSwingConsole.this.this_windowClosed(e);
            }
        });
        this.edpBody.setText("jEditorPane1");
        this.edpBody.setEditable(false);
        this.mnuFile.setText("File");
        this.mniExit.setText("Exit");
        this.mniExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.mniExit_actionPerformed(e);
            }
        });
        this.mniStopWebserver.setEnabled(false);
        this.mniStopWebserver.setActionCommand("StopServer");
        this.mnuHelp.setText("Help");
        this.rbtSetup.setText("Setup and Application Configuration instructions");
        this.rbtSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.rbtSetup_actionPerformed(e);
            }
        });
        this.rbtLicense.setSelected(true);
        this.rbtLicense.setText("License Agreement");
        this.rbtLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.rbtLicense_actionPerformed(e);
            }
        });
        this.mnuTools.setText("Tools");
        this.mniAbout.setText("About...");
        this.mniAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.mniAbout_actionPerformed(e);
            }
        });
        this.mniAppWizard.setText("Application Wizard...");
        this.mniAppWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.mniAppWizard_actionPerformed(e);
            }
        });
        this.btnWizard.setIcon(this.icnAppWizard);
        this.btnWizard.setText("App Wizard");
        this.btnWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.btnWizard_actionPerformed(e);
            }
        });
        this.mniStartWebserver.setActionCommand("StartServer");
        this.mniStartWebserver.setText("Start Web Server");
        this.mniStartWebserver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.mniStartWebserver_actionPerformed(e);
            }
        });
        this.mniStopWebserver.setText("Stop Web Server");
        this.mniStopWebserver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.mniStopWebserver_actionPerformed(e);
            }
        });
        this.statusBar.setIconTextGap(10);
        this.statusBar.setText("Ready");
        this.btnStartServer.setActionCommand("StartServer");
        this.btnStartServer.setIcon(this.icnStartServer);
        this.btnStartServer.setText("Start Server");
        this.btnStartServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.btnStartServer_actionPerformed(e);
            }
        });
        this.btnStopServer.setEnabled(false);
        this.btnStopServer.setActionCommand("StopServer");
        this.btnStopServer.setIcon(this.icnStopServer);
        this.btnStopServer.setText("Stop Server");
        this.btnStopServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.btnStopServer_actionPerformed(e);
            }
        });
        this.btnPreview.setActionCommand("AjaxSwingDemo");
        this.btnPreview.setIcon(this.icnAjaxSwingDemo);
        this.btnPreview.setText("AjaxSwingDemo");
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingConsole.this.btnPreview_actionPerformed(e);
            }
        });
        this.toolBar.setEnabled(false);
        this.mnuView.setText("View");
        this.getContentPane().add((Component)this.scrPane, "Center");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.toolBar.add((Component)this.btnWizard, null);
        this.toolBar.add((Component)this.btnStartServer, null);
        this.toolBar.add((Component)this.btnStopServer, null);
        this.toolBar.add((Component)this.btnPreview, null);
        this.scrPane.getViewport().add((Component)this.edpBody, null);
        this.mnbMain.add(this.mnuFile);
        this.mnbMain.add(this.mnuTools);
        this.mnbMain.add(this.mnuView);
        this.mnbMain.add(this.mnuHelp);
        this.mnuFile.add(this.mniExit);
        this.mnuHelp.add(this.rbtSetup);
        this.mnuHelp.add(this.rbtLicense);
        this.mnuHelp.addSeparator();
        this.mnuHelp.add(this.mniAbout);
        this.mnuTools.add(this.mniAppWizard);
        this.mnuTools.addSeparator();
        this.mnuTools.add(this.mniStartWebserver);
        this.mnuTools.add(this.mniStopWebserver);
    }

    private void displayFile(String fileName) {
        try {
            URL url = null;
            String prefix = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator");
            url = new URL(prefix + fileName);
            this.edpBody.setPage(url);
        }
        catch (Exception x) {
            x.printStackTrace();
            this.edpBody.setText("Error displaying document - " + x.getMessage());
        }
    }

    void exit() {
        System.exit(0);
    }

    void mniExit_actionPerformed(ActionEvent e) {
        this.exit();
    }

    void mniAbout_actionPerformed(ActionEvent e) {
        AboutDialog dlg = new AboutDialog();
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
    }

    void rbtSetup_actionPerformed(ActionEvent e) {
        try {
            this.edpBody.setPage("http://creamtec.com/products/ajaxswing/doc/setup.html");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    void rbtLicense_actionPerformed(ActionEvent e) {
        this.displayFile(".." + File.separator + "license.txt");
    }

    void this_windowClosed(WindowEvent e) {
        this.exit();
    }

    void mniAppWizard_actionPerformed(ActionEvent e) {
        AppWizard wiz = new AppWizard(this);
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        wiz.setLocation(scr.width / 2 - wiz.getWidth() / 2, scr.height / 2 - wiz.getHeight() / 2);
        wiz.setVisible(true);
        if (wiz.committed) {
            this.reloadViewMenu();
        }
    }

    void btnWizard_actionPerformed(ActionEvent e) {
        this.mniAppWizard_actionPerformed(e);
    }

    void mniStartWebserver_actionPerformed(ActionEvent e) {
        this.webServerManager.startWebServer();
        this.updateWebServerRunningUI();
    }

    void mniStopWebserver_actionPerformed(ActionEvent e) {
        this.webServerManager.stopWebServer();
        this.updateWebServerRunningUI();
    }

    public void showStatus(String msg) {
        this.statusBar.setText(msg);
        this.statusBar.paintImmediately(0, 0, this.statusBar.getWidth(), this.statusBar.getHeight());
    }

    public void updateWebServerRunningUI() {
        boolean running = this.webServerManager.webServerRunning;
        this.mniStopWebserver.setEnabled(running);
        this.btnStopServer.setEnabled(running);
        this.mniStartWebserver.setEnabled(!running);
        this.btnStartServer.setEnabled(!running);
    }

    void btnStartServer_actionPerformed(ActionEvent e) {
        this.mniStartWebserver_actionPerformed(e);
    }

    void btnStopServer_actionPerformed(ActionEvent e) {
        this.mniStopWebserver_actionPerformed(e);
    }

    void btnPreview_actionPerformed(ActionEvent e) {
        this.viewApp("http://localhost:8040/ajaxswing/apps/SwingSet2");
    }

    void viewApp(String appURL) {
        try {
            this.mniStartWebserver_actionPerformed(null);
            if (!this.webServerManager.isServerRunning()) {
                return;
            }
            this.showStatus("Running browser...");
            Process process = null;
            if (this.webServerManager.windows) {
                process = Runtime.getRuntime().exec("..\\bin\\previewapp.bat " + appURL);
                process.waitFor();
            } else {
                process = Runtime.getRuntime().exec("firefox " + appURL);
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)("Failed to view application " + appURL), (Throwable)x);
            JOptionPane.showMessageDialog(this, TraceMgr.getExceptionText((String)"Failed to run the browser", (Throwable)x), "Error", 0);
        }
        this.showStatus("Ready");
    }

    void reloadViewMenu() {
        if (this.viewMenuItemCount == 0) {
            this.viewMenuItemCount = this.mnuView.getItemCount();
        } else {
            for (int i = this.mnuView.getItemCount() - 1; i >= this.viewMenuItemCount; --i) {
                this.mnuView.remove(i);
            }
        }
        String[] apps = AjaxSwingConsole.getAppsList();
        for (int i = 0; i < apps.length; ++i) {
            JMenuItem item = new JMenuItem(apps[i]);
            item.addActionListener(this.viewAppListener);
            this.mnuView.add(item);
        }
    }

    public static String[] getAppsList() {
        File confDir = new File(Utilities.getConfDir());
        String[] files = confDir.list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accept(File dir, String name) {
                if (name.indexOf(".properties") == -1) {
                    return false;
                }
                if (name.equals("default.properties")) {
                    return false;
                }
                RandomAccessFile file = null;
                try {
                    file = new RandomAccessFile(new File(dir, name), "rw");
                    String header = file.readLine();
                    if (header != null && header.indexOf("AjaxSwing properties") != -1) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                return false;
            }
        });
        if (files == null) {
            JOptionPane.showMessageDialog(null, "No properties files found in configuration directory " + Utilities.getConfDir(), "Configuration error", 0);
            return new String[0];
        }
        String[] apps = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            apps[i] = files[i].substring(0, files[i].indexOf(46));
        }
        return apps;
    }

    public static String getEditionString() {
        String version = AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_PRO ? "Professional" : (AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_ENT ? "Enterprise" : (AjaxSwingSecurityManager.EDITION_TYPE == AjaxSwingSecurityManager.EDITION_UNL ? "Unlimited" : "Standard"));
        return version + " Edition, version " + VersionHelper.getAjaxSwingVersion();
    }

    static {
        if (Utilities.getRootDir() == null) {
            String dirPath = System.getProperty("user.dir");
            dirPath = dirPath + File.separatorChar + "..";
            Utilities.setRootDir((String)dirPath);
            TraceMgr.trace(AjaxSwingConsole.class, (String)("conf dir = " + Utilities.getConfDir()));
        }
    }
}

