/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.AbstractRenderingGraphics;
import com.creamtec.ajaxswing.v4.ComponentGraphics;
import com.creamtec.ajaxswing.v4.utils.ComponentUtils;
import com.creamtec.ajaxswing.v4.utils.FontUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;

public class RenderingGraphics
extends AbstractRenderingGraphics {
    private static double MAX_WORD_SPACING = 1.5;
    private static double MAX_LETTER_SPACING = 1.0;

    public RenderingGraphics(HTMLPage page) {
        super(page);
    }

    @Override
    public void draw(Shape s) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r = (RoundRectangle2D)s;
            this.drawRoundRect((int)r.getMinX(), (int)r.getMinY(), (int)r.getWidth(), (int)r.getHeight(), (int)r.getArcWidth(), (int)r.getArcHeight());
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawArc(int x, int y, int width, int height, int startAngle, int arcAngle)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawGlyphVector(GlyphVector g, float x, float y)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.drawImage((Image)img, x, y, null);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawImage(Image img, AffineTransform xform, ImageObserver obs)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, observer, "background-color:rgb(" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue() + ");");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, observer, "", null);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer, String additionalStyles) {
        return this.drawImage(img, x, y, observer, additionalStyles, null);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer, String additionalStyles, String additionalClass) {
        boolean useImg;
        if (this.clip != null && this.clip.isEmpty()) {
            return true;
        }
        if (img == null) {
            return true;
        }
        String url = this.getImageUrl(img);
        if (url == null) {
            return true;
        }
        String clipCss = "";
        Rectangle imgRect = new Rectangle();
        imgRect.width = img.getWidth(observer);
        imgRect.height = img.getHeight(observer);
        boolean bl = useImg = imgRect.width == -1;
        if (observer instanceof JButton && ComponentUtils.isTitledPane((Object)((JButton)observer).getParent())) {
            useImg = true;
            additionalStyles = "width:19px;height:19px;";
        }
        if (additionalStyles != null && additionalStyles.length() > 2) {
            useImg = true;
        }
        if (this.clip != null) {
            imgRect.x = x;
            imgRect.y = y;
            imgRect.width = imgRect.width == -1 ? 32 : imgRect.width;
            int n = imgRect.height = imgRect.height == -1 ? 32 : imgRect.height;
            if (!this.clip.contains(imgRect)) {
                if (!this.clip.intersects(imgRect)) {
                    return true;
                }
                clipCss = "clip:rect(" + (this.clip.y - imgRect.y) + "px, " + (this.clip.x + this.clip.width - imgRect.x) + "px, " + (this.clip.y + this.clip.height - imgRect.y) + "px, " + (this.clip.x - imgRect.x) + "px);";
            }
        }
        String css = "htmlImage";
        if (additionalClass != null && additionalClass.length() > 0) {
            css = css + " " + additionalClass;
        }
        if (url.endsWith("ajaxswing/laf/icons/button.gif")) {
            css = "buttonBackground htmlImage";
            useImg = false;
        }
        if (useImg) {
            this.append("<img class=\"");
            this.append(css);
            this.append("\" style=\"position:absolute;left:");
        } else {
            this.append("<div class=\"");
            this.append(css);
            this.append("\" style=\"position:absolute;left:");
        }
        this.append(this.getTranslateX() + x);
        this.append("px;top:");
        this.append(this.getTranslateY() + y);
        this.append("px;");
        this.append(clipCss);
        this.append(";");
        if (useImg) {
            this.append(additionalStyles);
            this.append("\"");
            this.append(" src=\"");
            this.append(url);
            this.append("\" >");
        } else {
            this.append(";width:");
            this.append(imgRect.width);
            this.append("px;height:");
            this.append(imgRect.height);
            this.append("px;");
            this.append(additionalStyles);
            this.append("background-image:url('");
            this.append(url);
            this.append("');background-repeat:no-repeat\" >");
            this.append("</div>");
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, observer, "width:" + width + "px;height:" + height + "px;" + "background-color:rgb(" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue() + ");");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, observer, "width:" + width + "px;height:" + height + "px;");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer, String additionalClass) {
        return this.drawImage(img, x, y, observer, "width:" + width + "px;height:" + height + "px;", additionalClass);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        img = this.getImagePart(img, sx1, sy1, sx2, sy2, observer);
        return this.drawImage(img, dx1, dy1, observer, "width:" + (dx2 - dx1) + "px;height:" + (dy2 - dy1) + "px;");
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        img = this.getImagePart(img, sx1, sy1, sx2, sy2, observer);
        return this.drawImage(img, dx1, dy1, observer, "width:" + (dx2 - dx1) + "px;height:" + (dy2 - dy1) + "px;");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine(x1, y1, x2, y2, false, ComponentGraphics.LinePlace.NONE);
    }

    public void drawResizableCorner(int x, int y, String direction) {
        this.append("<div class=\"corner\" style=\"position:absolute;left:");
        this.append(x);
        this.append("px;top:");
        this.append(y);
        this.append("px;width:1px;height:1px;background-color:#");
        this.appendHexColor(this.getColor());
        this.append(";cursor:");
        this.append(direction);
        this.append("-resize;\"></div>");
    }

    public void drawResizableLeftTopCorner(int x, int y) {
        this.drawResizableCorner(x, y, "nw");
    }

    public void drawResizableRightTopCorner(int x, int y) {
        this.drawResizableCorner(x, y, "ne");
    }

    public void drawResizableLeftBottomCorner(int x, int y) {
        this.drawResizableCorner(x, y, "sw");
    }

    public void drawResizableRightBottomCorner(int x, int y) {
        this.drawResizableCorner(x, y, "se");
    }

    public void drawLine(int x1, int y1, int x2, int y2, Boolean paintResizable, ComponentGraphics.LinePlace linePlace) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        if (x1 == x2 || x2 + x1 == -1) {
            if (this.clip != null) {
                int clipTop = this.clip.y;
                int clipBottom = this.clip.y + this.clip.height;
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                }
                if (y1 < clipTop) {
                    y1 = clipTop;
                }
                if (y2 > clipBottom) {
                    y2 = clipBottom;
                }
                if (this.clip.x > x1 || this.clip.x + this.clip.width < x1) {
                    return;
                }
            }
            int top = this.getTranslateY() + Math.min(y1, y2);
            int left = this.getTranslateX() + x1;
            int height = Math.abs(y1 - y2) + 1;
            if (height > this.clip.height) {
                height = this.clip.height;
            }
            boolean corneredFlag = false;
            if (paintResizable.booleanValue() && height > 1) {
                switch (linePlace) {
                    case LEFT: {
                        this.drawResizableLeftTopCorner(left, top);
                        break;
                    }
                    case RIGHT: {
                        this.drawResizableRightTopCorner(left, top);
                    }
                }
                ++top;
                height -= 2;
                corneredFlag = true;
            }
            this.append("<div class=\"vl\" style=\"position:absolute;left:");
            this.append(left);
            this.append("px;top:");
            this.append(top);
            this.append("px;width:1px;height:");
            this.append(height);
            this.append("px;background-color:#");
            this.appendHexColor(this.getColor());
            this.append(paintResizable != false ? ";cursor:e-resize" : "");
            this.append("\"></div>");
            if (paintResizable.booleanValue() && corneredFlag) {
                --top;
                height += 2;
                switch (linePlace) {
                    case LEFT: {
                        this.drawResizableLeftBottomCorner(left, top + height - 1);
                        break;
                    }
                    case RIGHT: {
                        this.drawResizableRightBottomCorner(left, top + height - 1);
                    }
                }
            }
        } else if (y2 == y1 || y2 + y1 == -1) {
            if (this.clipShape != null && this.clipShape instanceof Path2D && y1 < 10) {
                try {
                    Path2D path = (Path2D)this.clipShape;
                    this.clipShape.contains(x1, y1, 1.0, 1.0);
                    Area clipArea = new Area(this.clipShape);
                    clipArea.intersect(new Area(new Rectangle(x1 + this.getTranslateX(), y1 + this.getTranslateY(), Math.abs(x1 - x2), 1)));
                    PathIterator i = clipArea.getPathIterator(null);
                    this.clipShape = null;
                    double[] coords = new double[6];
                    Point from = null;
                    while (!i.isDone()) {
                        i.currentSegment(coords);
                        if (coords[1] == (double)this.getTranslateY() || coords[1] == (double)(this.getTranslateY() + y1)) {
                            if (from == null) {
                                from = new Point((int)(coords[0] - (double)this.getTranslateX()), (int)(coords[1] - (double)this.getTranslateY()));
                            } else {
                                this.drawLine(from.x, from.y, (int)(coords[0] - (double)this.getTranslateX()), (int)(coords[1] - (double)this.getTranslateY()));
                                from = null;
                                i.next();
                            }
                        }
                        i.next();
                    }
                    this.clipShape = path;
                    return;
                }
                catch (Exception path) {}
            } else if (this.clip != null) {
                int clipLeft = this.clip.x;
                int clipRight = this.clip.x + this.clip.width;
                if (x1 > x2) {
                    int tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                if (x1 < clipLeft) {
                    x1 = clipLeft;
                }
                if (x2 > clipRight) {
                    x2 = clipRight;
                }
                if (this.clip.y > y1 || this.clip.y + this.clip.height < y1) {
                    return;
                }
            }
            int top = this.getTranslateY() + y1;
            int left = this.getTranslateX() + Math.min(x1, x2);
            int width = Math.abs(x1 - x2) + 1;
            if (width > this.clip.width) {
                width = this.clip.width;
            }
            boolean corneredFlag = false;
            if (paintResizable.booleanValue() && width > 1) {
                switch (linePlace) {
                    case TOP: {
                        this.drawResizableLeftTopCorner(left, top);
                        break;
                    }
                    case BOTTOM: {
                        this.drawResizableLeftBottomCorner(left, top);
                    }
                }
                ++left;
                width -= 2;
                corneredFlag = true;
            }
            this.append("<div class=\"hl\" style=\"position:absolute;top:");
            this.append(top);
            this.append("px;left:");
            this.append(left);
            this.append("px;height:1px;width:");
            this.append(width);
            this.append("px;background-color:#");
            this.appendHexColor(this.getColor());
            this.append(paintResizable != false ? ";cursor:n-resize" : "");
            this.append("\"></div>");
            if (paintResizable.booleanValue() && corneredFlag) {
                --left;
                width += 2;
                switch (linePlace) {
                    case TOP: {
                        this.drawResizableRightTopCorner(left + width - 1, top);
                        break;
                    }
                    case BOTTOM: {
                        this.drawResizableRightBottomCorner(left + width - 1, top);
                    }
                }
            }
        } else {
            this.append("<div style=\"position:absolute;left:");
            boolean rev = false;
            if (x2 > x1) {
                ++x2;
                --y2;
            }
            if (y2 <= y1) {
                ++y1;
                ++y2;
            }
            String dir = "left";
            if (y1 > y2 && x2 < x1) {
                rev = true;
                dir = "right";
            }
            if (y1 < y2 && x2 < x1) {
                x1 += 2;
                ++y1;
                y2 += 3;
            }
            if (y1 < y2 && x1 < x2) {
                x1 += 2;
                x2 += 0;
                y1 += 2;
                y2 += 2;
                rev = true;
                dir = "right";
            }
            String cdir = "bottom";
            if (!rev) {
                cdir = "right";
            }
            this.append(this.getTranslateX() + Math.min(x1, x2) - 1);
            this.append("px;top:");
            this.append(this.getTranslateY() + Math.min(y1, y2) - 1);
            this.append("px\">");
            this.append("<div style=\"position:absolute;left:0px;top:0px;height:0px;border-" + dir + "-color:transparent;border-style:solid;border-width: ");
            this.append(!rev ? Math.abs(y1 - y2) : 0);
            this.append("px ");
            this.append(Math.abs(x1 - x2));
            this.append("px ");
            this.append(rev ? Math.abs(y1 - y2) : 0);
            this.append("px ");
            this.append(0);
            this.append("px;border-" + cdir + "-color:#");
            this.appendHexColor(this.getColor());
            if (!rev) {
                this.append(";border-top-color: transparent;");
            }
            this.append("\"></div>");
            this.append("<div style=\"position:absolute;left:0px;top:0px;height:0px;border-" + dir + "-color:transparent;border-style:solid;border-width: ");
            this.append(!rev ? Math.abs(y1 - y2) : 0);
            this.append("px ");
            this.append(Math.abs(x1 - x2));
            this.append("px ");
            this.append(rev ? Math.abs(y1 - y2) : 0);
            this.append("px ");
            this.append(0);
            this.append("px;border-" + cdir + "-color:#");
            this.appendHexColor(this.diagonalBackground);
            if (!rev) {
                this.append(";border-top-color: transparent;");
            }
            this.append(";left:");
            if (rev) {
                this.append("-");
            }
            this.append("1px;\"></div>");
            this.append("</div>");
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawOval(int x, int y, int width, int height)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawPolyline(int[] xPoints, int[] yPoints, int nPoints)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawPolyline(int[] xPoints, int[] yPoints, int nPoints)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.drawRect(x, y, width, height, "");
    }

    public void drawRect(int x, int y, int width, int height, String additionalStyles) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        boolean disableLeft = false;
        boolean disableTop = false;
        boolean disableRight = false;
        boolean disableBottom = false;
        if (this.clip != null) {
            int absY;
            int absX;
            int clipLeft = this.clip.x;
            int clipRight = this.clip.x + this.clip.width;
            int clipTop = this.clip.y;
            int clipBottom = this.clip.y + this.clip.height;
            if (x < clipLeft) {
                disableLeft = true;
            }
            if (y < clipTop) {
                disableTop = true;
            }
            if ((absX = Math.abs(x)) + width > clipRight) {
                disableRight = true;
            }
            if ((absY = Math.abs(y)) + height > clipBottom) {
                disableBottom = true;
            }
            if (disableLeft) {
                width -= clipLeft - absX;
                x = clipLeft;
            }
            if (disableTop) {
                height -= clipTop - absY;
                y = clipTop;
            }
            if (disableRight) {
                width = clipRight - absX;
            }
            if (disableBottom) {
                height = clipBottom - absY;
            }
        }
        Boolean paintResizable = false;
        if (additionalStyles != null && additionalStyles.equals("paintResizable")) {
            paintResizable = true;
            additionalStyles = null;
        }
        if (additionalStyles == null || additionalStyles.length() == 0) {
            if (!disableTop) {
                this.drawLine(x, y, x + width, y, paintResizable, ComponentGraphics.LinePlace.TOP);
            }
            if (!disableLeft) {
                this.drawLine(x, y, x, y + height, paintResizable, ComponentGraphics.LinePlace.LEFT);
            }
            if (!disableBottom) {
                this.drawLine(x, y + height, x + width, y + height, paintResizable, ComponentGraphics.LinePlace.BOTTOM);
            }
            if (!disableRight) {
                this.drawLine(x + width, y, x + width, y + height, paintResizable, ComponentGraphics.LinePlace.RIGHT);
            }
        } else {
            this.fillRect(x, y, width, height, "background-color:transparent;border-style:solid;border-width:1px;border-color:rgb(" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue() + ");" + additionalStyles);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawRenderableImage(RenderableImage img, AffineTransform xform)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: drawRenderedImage(RenderedImage img, AffineTransform xform)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        this.drawRect(x, y, width, height, "border-radius:" + arcWidth + "px;");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.drawString(iterator, (int)x, (int)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (iterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(iterator.first());
        while (iterator.getIndex() < iterator.getEndIndex() - 1) {
            sb.append(iterator.next());
        }
        Map<AttributedCharacterIterator.Attribute, Object> oldGraphicsProperties = this.applyTextAttributes(iterator.getAttributes());
        this.drawString(sb.toString(), x, y);
        this.applyTextAttributes(oldGraphicsProperties);
    }

    private Map<AttributedCharacterIterator.Attribute, Object> applyTextAttributes(Map<AttributedCharacterIterator.Attribute, Object> attMap) {
        HashMap<AttributedCharacterIterator.Attribute, Object> applyedMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        for (AttributedCharacterIterator.Attribute attributeKey : attMap.keySet()) {
            Serializable oldVal = null;
            Object attributeVal = attMap.get(attributeKey);
            if (attributeVal == null) continue;
            if (attributeKey == TextAttribute.FOREGROUND) {
                oldVal = this.getColor();
                this.setColor((Color)attributeVal);
            } else if (attributeKey == TextAttribute.FONT) {
                oldVal = this.getFont();
                this.setFont((Font)attributeVal);
            }
            if (oldVal == null) continue;
            applyedMap.put(attributeKey, oldVal);
        }
        return applyedMap;
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.drawString(str, (int)x, (int)y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 2);
    }

    public void drawString(String str, int x, int y, String additionalClass) {
        this.drawString(str, x, y, 2, additionalClass);
    }

    public void drawString(String str, int x, int y, int hAlign) {
        this.drawString(str, x, y, 2, null);
    }

    public void drawString(String str, int x, int y, int hAlign, String additionalClass) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        Rectangle bounds = new Rectangle();
        bounds.x = x;
        bounds.y = y - metrics.getAscent();
        bounds.width = metrics.stringWidth(str);
        bounds.height = metrics.getHeight();
        if (this.clip != null && !this.clip.contains(bounds) && !this.clip.intersects(bounds)) {
            return;
        }
        this.append("<div class=\"htmlString");
        if (additionalClass != null && additionalClass.length() > 0) {
            this.append(" ");
            this.append(additionalClass);
        }
        this.append("\" style=\"position:absolute;left:");
        this.append(this.getTranslateX() + bounds.x);
        this.append("px;top:");
        this.append(this.getTranslateY() + bounds.y);
        this.append("px;width:");
        this.append(bounds.width);
        this.append("px;white-space:nowrap;");
        this.append("text-align:");
        switch (hAlign) {
            case 4: {
                this.append("right");
                break;
            }
            default: {
                this.append("left");
            }
        }
        this.append(";");
        this.appendFontStyle(this.getFont());
        this.appendFontCalibration(str, bounds.width, this.getFont());
        this.append(";color:#");
        this.appendHexColor(this.getColor());
        if (this.clip != null && !this.clip.contains(bounds)) {
            this.append(";clip:rect(" + (this.clip.y - bounds.y) + "px, " + (this.clip.x + this.clip.width - bounds.x) + "px, " + (this.clip.y + this.clip.height - bounds.y) + "px, " + (this.clip.x - bounds.x) + "px);");
        }
        this.append("\">");
        if (str != null && str.length() > 6 && str.substring(0, 6).equalsIgnoreCase("<html>")) {
            str = "&lt;" + str.substring(1);
        }
        if (this.underlineCharAt == null) {
            this.appendText(str);
        } else {
            int index = this.underlineCharAt;
            if (index >= 0 && index < str.length()) {
                this.appendText(str.substring(0, index));
                this.append("<u>" + str.charAt(index) + "</u>");
                this.appendText(str.substring(index + 1));
            } else {
                this.appendText(str);
            }
        }
        this.append("</div>");
    }

    private void appendFontCalibration(String str, int width, Font font) {
        int spaces;
        if (str.length() < 3) {
            return;
        }
        Double coef = ClientAgent.getCurrentInstance().getFontCalibrationData(FontUtils.getFontName(font), font.getSize(), this.hasManyCapitalLetters(str));
        if (coef == 1.0) {
            return;
        }
        int uiWidth = (int)Math.ceil((double)width * coef);
        int diffInPx = uiWidth - width;
        double pixelsAdjustedByWordSpacing = (double)diffInPx * 1.0 / (double)(spaces = str.length() - str.replace(" ", "").length()) + 0.01;
        if (pixelsAdjustedByWordSpacing <= MAX_WORD_SPACING) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.append(";word-spacing:-");
            this.append(df.format(pixelsAdjustedByWordSpacing));
            this.append("px");
        } else {
            double pixelsAdjustedByLetterSpacing = (double)diffInPx * 1.0 / (double)str.length() + 0.01;
            if (pixelsAdjustedByLetterSpacing > MAX_LETTER_SPACING) {
                pixelsAdjustedByLetterSpacing = MAX_LETTER_SPACING;
            }
            DecimalFormat df = new DecimalFormat("#.##");
            this.append(";letter-spacing:-");
            this.append(df.format(pixelsAdjustedByLetterSpacing));
            this.append("px");
        }
    }

    private boolean hasManyCapitalLetters(String str) {
        int count = 0;
        for (int k = 0; k < str.length(); ++k) {
            if (!Character.isUpperCase(str.charAt(k))) continue;
            ++count;
        }
        return str.length() - count < count;
    }

    @Override
    public void fill(Shape s) {
        RectangularShape r;
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        if (s instanceof RoundRectangle2D) {
            r = (RoundRectangle2D)s;
            this.fillRoundRect((int)r.getMinX(), (int)r.getMinY(), (int)r.getWidth(), (int)r.getHeight(), (int)((RoundRectangle2D)r).getArcWidth(), (int)((RoundRectangle2D)r).getArcHeight());
        }
        if (s instanceof Path2D) {
            Rectangle rect;
            if (s instanceof GeneralPath) {
                rect = s.getBounds();
                this.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            } else {
                rect = s.getBounds();
                this.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        }
        if (s instanceof Rectangle2D) {
            r = (Rectangle2D)s;
            this.fillRect((int)r.getMinX(), (int)r.getMinY(), (int)r.getWidth(), (int)r.getHeight());
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        TraceMgr.trace((Object)this, (String)"AjaxSwing NOT IMPLEMENTED: fillArc(int x, int y, int width, int height, int startAngle, int arcAngle)", (int)TraceMgr.DEFAULT_WARNING_LEVEL);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fillRoundRect(x, y, width, height, width / 2, height / 2);
    }

    @Override
    public void fillPolygon(int[] x, int[] y, int points) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        if (points == 3 && x.length == 3 && y.length == 3) {
            if (y[0] == y[2]) {
                this.fillTriangleVertical(y[0], y[1], x);
                return;
            }
            if (y[0] == y[1]) {
                this.fillTriangleVertical(y[0], y[2], x);
                return;
            }
        }
        if (this.verticalRotate && points == 4) {
            int xDiffInner = x[points - 1] - x[1];
            int xDiffOuter = x[points - 2] - x[0];
            x[points - 2] = x[0];
            x[points - 1] = x[1];
            y[points - 1] = y[2] + xDiffInner;
            y[points - 2] = y[1] + xDiffOuter;
            if (this.compensateY) {
                this.translateY -= y[points - 1];
            }
        } else if (!this.correctDrawPosition) {
            if (this.translateX - this.offset >= x[points - 1]) {
                this.translateXCompensation += x[points - 1];
                this.translateX -= x[points - 1];
            } else {
                this.offset += this.translateX;
            }
        }
        for (int i = 1; i < points; ++i) {
            this.drawLine(x[i - 1], y[i - 1], x[i], y[i]);
        }
        if (x[0] != x[points - 1] || y[0] != y[points - 1]) {
            this.drawLine(x[0], y[0], x[points - 1], y[points - 1]);
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fillRect(x, y, width, height, "");
    }

    public void fillRect(int x, int y, int width, int height, String additionalStyles) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        if (this.clip != null) {
            Rectangle rect = new Rectangle(x, y, width, height);
            if ((rect = rect.intersection(this.clip)).isEmpty()) {
                return;
            }
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        this.append("<div style=\"position:absolute;top:");
        this.append(this.getTranslateY() + y);
        this.append("px;left:");
        this.append(this.getTranslateX() + x);
        this.append("px;height:");
        this.append(height);
        this.append("px;width:");
        this.append(width);
        this.append("px;");
        Paint paint = this.getPaint();
        if (paint != null && paint.getClass().getName().startsWith("com.incors")) {
            this.append("background-color:#");
            this.appendHexColor(Color.WHITE);
        } else if (paint != null && paint instanceof Color) {
            this.append("background-color:#");
            this.appendHexColor((Color)paint);
            if (width > 2 && height > 2) {
                this.diagonalBackground = (Color)paint;
            }
        } else if (paint != null) {
            if (width > 0 && height > 0) {
                this.append("background:transparent url(");
                String imageUrl = this.getCachedPaint(paint);
                if (imageUrl == null) {
                    Rectangle userBounds = new Rectangle(x, y, width, height);
                    PaintContext pc = paint.createContext(ColorModel.getRGBdefault(), userBounds, userBounds, new AffineTransform(), this.getRenderingHints());
                    Raster r = pc.getRaster(x, y, width, height);
                    BufferedImage img = new BufferedImage(pc.getColorModel(), (WritableRaster)r, true, null);
                    imageUrl = this.getImageUrl(img);
                }
                this.append(imageUrl);
                this.append(") repeat 0 0;");
            }
        } else {
            this.append("background-color:#");
            this.appendHexColor(this.rewriteColor(this.getColor()));
            if (width > 2 && height > 2) {
                this.diagonalBackground = this.rewriteColor(this.getColor());
            }
        }
        this.append(";");
        this.append(additionalStyles);
        this.append("\"></div>");
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRect(x, y, width, height, "border-radius:" + arcWidth + "px;");
    }

    public void fillTriangleVertical(int y, int y1, int[] xt) {
        if (this.clip != null && this.clip.isEmpty()) {
            return;
        }
        int dy = Math.abs(y1 - y);
        int py = y > y1 ? -1 : 1;
        int mdx = Math.max(Math.abs(xt[0] - xt[1]), Math.abs(xt[0] - xt[2]));
        int sx = Math.min(xt[0], Math.min(xt[1], xt[2]));
        int i = 0;
        int dx = 0;
        while (y != y1) {
            if (i > 0) {
                dx = (int)((double)mdx / 2.0 * (double)((float)(i + 1) / (float)dy));
            }
            this.drawLine(sx + dx, y, sx + mdx - dx, y);
            y += py;
            ++i;
        }
    }
}

