/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4.utils;

import com.creamtec.ajaxswing.gui.AjaxSwingImage;
import com.creamtec.ajaxswing.gui.AjaxSwingToolkit;
import com.creamtec.ajaxswing.gui.AjaxSwingVolatileImage;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.render.SnapshotRenderer;
import com.creamtec.core.TraceMgr;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.WeakHashMap;

public class ImageUtils {
    static WeakHashMap<Image, String> imageUrls = new WeakHashMap();
    static WeakHashMap<Object, String> rasterUrls = new WeakHashMap();
    private HTMLPage page = null;

    public static boolean canDelete(String fileName) {
        Iterator<String> i = imageUrls.values().iterator();
        while (i.hasNext()) {
            if (!i.next().contains(fileName)) continue;
            return false;
        }
        return true;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL source, File destination) throws IOException {
        try (InputStream input = source.openStream();
             FileOutputStream output = new FileOutputStream(destination);){
            ImageUtils.copy(input, output);
        }
    }

    public ImageUtils(HTMLPage page) {
        this.page = page;
    }

    public Image getImagePart(Image img, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if ("swingset2".equals(this.page.getClientAgent().getAppName())) {
            return img;
        }
        if (img instanceof AjaxSwingVolatileImage) {
            img = ((AjaxSwingVolatileImage)img).getSnapshot();
        }
        if (img instanceof AjaxSwingImage) {
            img = ((AjaxSwingImage)img).getBufferedImage();
        }
        if (img instanceof BufferedImage) {
            int w = sx2 - sx1;
            int h = sy2 - sy1;
            if (Math.abs(w - img.getWidth(observer)) > 2 || Math.abs(h - img.getHeight(observer)) > 2) {
                img = ((BufferedImage)img).getSubimage(sx1, sy1, w, h);
            }
        }
        return img;
    }

    public String getImageUrl(Image image, boolean keepUntilRestart) {
        String url = imageUrls.get(image);
        if (url != null) {
            return url;
        }
        if (url == null) {
            AjaxSwingToolkit.getImageUrl((Image)image);
        }
        if (url == null) {
            url = AjaxSwingToolkit.getImageFileName((Image)image);
        }
        if (url != null && !url.startsWith("http://")) {
            if (url.startsWith("jar:file:/")) {
                this.extractImage(url);
            } else {
                try {
                    String dest;
                    File destination;
                    File file = new File(url);
                    if (file.exists() && !(destination = new File(dest = this.page.getClientAgent().getInitData().getWebappRealPath() + File.separatorChar + this.page.getThemeName() + "_docs" + File.separator + "images", file.getName())).exists()) {
                        destination.createNewFile();
                        ImageUtils.copy(new FileInputStream(file), new FileOutputStream(destination));
                    }
                }
                catch (Exception ex) {
                    TraceMgr.trace((String)"WARN: Failed to extract image", (Throwable)ex);
                }
            }
            String cleanupImageUrl = this.page.cleanupImageUrl(url);
            if (url.startsWith(this.page.getClientAgent().getInitData().getTempDirPath())) {
                if (cleanupImageUrl.startsWith("/images/")) {
                    cleanupImageUrl = cleanupImageUrl.substring(8);
                }
                url = this.page.getTempFileURL(cleanupImageUrl);
                imageUrls.put(image, url);
            } else {
                url = this.page.getThemeDocsURL() + cleanupImageUrl;
                imageUrls.put(image, url);
            }
        }
        if (url == null && image instanceof BufferedImage) {
            Integer key = this.calcImageHashCode((BufferedImage)image);
            if (key != null && (url = rasterUrls.get(key)) != null) {
                return url;
            }
            SnapshotRenderer snapshotRenderer = SnapshotRenderer.getInstance();
            String imageName = snapshotRenderer.generateIconImageFile(this.page, (BufferedImage)image, keepUntilRestart);
            url = this.page.getDocsURL() + "/temp/" + imageName;
            if (key != null) {
                rasterUrls.put(key, url);
            }
            imageUrls.put(image, url);
        }
        if (url == null && image instanceof AjaxSwingImage) {
            url = this.getImageUrl(((AjaxSwingImage)image).getBufferedImage(), false);
            imageUrls.put(image, url);
        }
        if (url == null && image instanceof AjaxSwingVolatileImage) {
            AjaxSwingVolatileImage img = (AjaxSwingVolatileImage)image;
            url = this.getImageUrl(img.getSnapshot(), false);
            imageUrls.put(image, url);
        }
        return url;
    }

    private Integer calcImageHashCode(BufferedImage image) {
        DataBuffer buffer = image.getRaster().getDataBuffer();
        if (buffer instanceof DataBufferInt) {
            DataBufferInt data = (DataBufferInt)buffer;
            Integer newHash = 0;
            for (int i = 0; i < data.getNumBanks(); ++i) {
                newHash = newHash + Arrays.hashCode(data.getData(i));
            }
            return newHash;
        }
        if (buffer instanceof DataBufferByte) {
            DataBufferByte data = (DataBufferByte)buffer;
            Integer newHash = 0;
            for (int i = 0; i < data.getNumBanks(); ++i) {
                newHash = newHash + Arrays.hashCode(data.getData(i));
            }
            return newHash;
        }
        return null;
    }

    private void extractImage(String url) {
        try {
            URL u = new URL(url);
            String fileName = u.getFile();
            fileName = fileName.substring(fileName.lastIndexOf(".jar!") + 5);
            fileName = this.page.getClientAgent().getInitData().getWebappRealPath() + File.separatorChar + this.page.getThemeName() + "_docs" + File.separator + "images" + fileName;
            File destination = new File(fileName);
            if (!destination.exists()) {
                destination.getParentFile().mkdirs();
                destination.createNewFile();
                ImageUtils.copyURLToFile(u, destination);
            }
        }
        catch (Exception ex) {
            TraceMgr.trace((String)"WARN: Failed to extract image from jar", (Throwable)ex);
        }
    }
}

