/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.AjaxSwingRegistryManager;
import com.creamtec.ajaxswing.core.JVMFactoryRemote;
import com.creamtec.ajaxswing.core.JVMProcessContext;
import com.creamtec.ajaxswing.core.JVMProcessRemote;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.rmi.NotBoundException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JVMFactory
extends UnicastRemoteObject
implements JVMFactoryRemote {
    protected Map appToJVMListMap = new HashMap();
    protected int jvmWaitTimeout;
    protected Registry registry;
    protected int registryPort;

    public JVMFactory() throws Exception {
        TraceMgr.trace(this, "Creating JVM factory");
        AjaxSwingProperties defaultProps = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        this.jvmWaitTimeout = defaultProps.getIntProperty("router.agentWaitTimeout", 60) * 1000;
        int registryPort = defaultProps.getIntProperty("router.registryPort", 8045);
        int portRange = defaultProps.getIntProperty("router.registryPortRange", 10);
        this.initRegistry(registryPort, portRange);
    }

    public void initRegistry(int registryPort, int portRange) throws Exception {
        this.registry = AjaxSwingRegistryManager.getRegistry(registryPort, portRange);
        this.registryPort = AjaxSwingRegistryManager.getActivePort();
        this.registry.rebind("creamtec/ajaxswing/JVMFactory", this);
    }

    public synchronized JVMProcessContext getAvailableJVM(String appName, String locale) throws Exception {
        JVMProcessContext foundJVM = this.findFreeJVM(appName, locale);
        if (foundJVM == null) {
            foundJVM = this.launchJVM(appName, locale);
            List jvms = this.getAppJvms(appName);
            if (!jvms.contains(foundJVM) && foundJVM != null) {
                jvms.add(foundJVM);
            }
        }
        foundJVM.locale = locale;
        return foundJVM;
    }

    public JVMProcessContext findFreeJVM(String appName, String locale) throws Exception {
        JVMProcessContext foundJVM = null;
        AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties(appName);
        int clientsPerJVM = props.getIntProperty("router.clientsPerJVM", 10);
        int retireJVMAfterClients = props.getIntProperty("router.retireJVMAfterClients", 100);
        List jvms = this.getAppJvms(appName);
        for (int i = 0; i < jvms.size(); ++i) {
            JVMProcessContext jvmContext = (JVMProcessContext)jvms.get(i);
            if (jvmContext.locale != null && !jvmContext.locale.equals(locale) || jvmContext.clientsExecuted >= retireJVMAfterClients || jvmContext.clientInitializing || clientsPerJVM != 0 && jvmContext.clientsCount >= clientsPerJVM) continue;
            foundJVM = jvmContext;
            break;
        }
        return foundJVM;
    }

    public List getAppJvms(String appName) {
        ArrayList jvms = (ArrayList)this.appToJVMListMap.get(appName);
        if (jvms == null) {
            jvms = new ArrayList();
            this.appToJVMListMap.put(appName, jvms);
        }
        return jvms;
    }

    public JVMProcessContext launchJVM(String appName, String locale) throws Exception {
        return this.waitForJVM(appName, this.execJVMProcess(appName), locale);
    }

    public String execJVMProcess(String appName) throws Exception {
        String cmdLine = null;
        String[] cmdParams = new String[4];
        if (System.getProperty("os.name").indexOf("indows") != -1) {
            cmdParams[0] = cmdLine = Utilities.getFullPath("bin\\clientAgent.bat");
            cmdLine = "\"" + cmdLine + "\"";
        } else {
            cmdParams[0] = cmdLine = Utilities.getFullPath("bin/clientAgent.sh");
        }
        cmdLine = cmdLine + " " + appName;
        cmdParams[1] = appName;
        cmdLine = cmdLine + " " + this.registryPort;
        cmdParams[2] = String.valueOf(this.registryPort);
        String curTime = String.valueOf(System.currentTimeMillis());
        int idLength = Math.min(8, curTime.length());
        String uniqId = curTime.substring(curTime.length() - idLength);
        cmdLine = cmdLine + " " + uniqId;
        cmdParams[3] = uniqId;
        TraceMgr.trace(this, "cmdLine [" + uniqId + "] = " + cmdLine);
        Process agentProcess = Runtime.getRuntime().exec(cmdParams);
        Thread.currentThread();
        Thread.sleep(1L);
        try {
            int exitValue = agentProcess.exitValue();
            TraceMgr.trace((Object)this, "Process exit value [" + uniqId + "] = " + exitValue, 6);
            if (exitValue != 0) {
                throw new AjaxSwingException("Failed to start client agent process using command line <br>" + cmdLine + "<br>(process exited with value " + exitValue + ")<p>Check the installation and persmissions on files and make sure AJAXSWING_HOME is set." + "<br>You can also turn on the tracing and examine the log file for details.");
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        return uniqId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JVMProcessContext waitForJVM(String appName, String clientAgentId, String locale) throws Exception {
        TraceMgr.trace(this, "waiting for JVM agent to become available for app " + appName + " [" + clientAgentId + "]");
        JVMProcessContext jvm = null;
        try {
            List appJvms;
            List list = appJvms = this.getAppJvms(appName);
            synchronized (list) {
                appJvms.wait(this.jvmWaitTimeout);
            }
        }
        catch (Exception x) {
            TraceMgr.trace(this, "waitForJVM interrupted");
        }
        jvm = this.findFreeJVM(appName, locale);
        if (jvm == null) {
            TraceMgr.trace((Object)this, "Timed out while waiting for a new JVM process for application " + appName + " [" + clientAgentId + "]", 3);
            String errorMessage = "Timed out while waiting for a new JVM process. Possible reasons are:<ul><li> Application classes are not not found<li> JAVA_HOME environment variable is not set correctly (see AjaxSwing/bin/setEnv.bat)<li> AJAXSWING_HOME environment variable is not set correctly (see AjaxSwing/bin/setEnv.bat)<li> System configuration prevents AjaxSwing Router from launching agent process<li> The timeout value for router.agentWaitTimeout in default.properties is too low</ul>Check AjaxSwing log files for application errors.<br>Double check that you have made your classes available to AjaxSwing and that you can run AjaxSwing/bin/clientagent[.bat] with correct parameters manually<br>" + String.format("Check out both %s_%s.log and %s_%s.out for more details.", appName, clientAgentId, appName, clientAgentId);
            TraceMgr.trace(this, "WARN: Timed out while waiting for a new JVM process", (Throwable)new AjaxSwingException(errorMessage), TraceMgr.DEFAULT_WARNING_LEVEL);
            throw new RuntimeException("Timed out while waiting for a new JVM process for [" + appName + "] clienId #" + clientAgentId);
        }
        TraceMgr.trace(this, "found available JVM");
        return jvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerJVM(String appName, JVMProcessRemote jvmProcess) throws Exception {
        List jvms;
        TraceMgr.trace(this, "Registering a new JVM for application " + appName);
        List list = jvms = this.getAppJvms(appName);
        synchronized (list) {
            JVMProcessContext jvmContext = new JVMProcessContext();
            jvmContext.jvmProcess = jvmProcess;
            jvms.add(jvmContext);
            jvms.notifyAll();
        }
    }

    public void shutdownJVM(JVMProcessContext jvmContext, String appName) {
        TraceMgr.trace(this, "Shutting down JVM, agents = " + jvmContext.clientsCount);
        List jvms = this.getAppJvms(appName);
        jvms.remove(jvmContext);
        try {
            jvmContext.jvmProcess.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterJVM(JVMProcessContext jvmContext, String appName) {
        TraceMgr.trace(this, "Unregistering JVM for app " + appName);
        List jvms = this.getAppJvms(appName);
        jvms.remove(jvmContext);
    }

    public void shutdown() {
        for (String appName : this.appToJVMListMap.keySet()) {
            List jvms = this.getAppJvms(appName);
            TraceMgr.trace(this, "Shutting down application " + appName);
            while (jvms.size() > 0) {
                JVMProcessContext jvmContext = (JVMProcessContext)jvms.get(0);
                this.shutdownJVM(jvmContext, appName);
            }
        }
        TraceMgr.trace((Object)this, "All JVMs shutdown", 3);
        try {
            this.registry.unbind("creamtec/ajaxswing/JVMFactory");
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NotBoundException nbe) {
            TraceMgr.trace(this, "WARN: Failed to unbind JVMFactory", (Throwable)nbe, TraceMgr.DEFAULT_WARNING_LEVEL);
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, "Failed to unbind JVMFactory", (Throwable)x);
        }
        AjaxSwingRegistryManager.shutdownRegistry();
    }

    @Override
    public void ping() {
    }
}

