/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentManager;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class AjaxSwingRepaintManager
extends RepaintManager {
    protected ClientAgent agent;
    protected List<JComponent> invalidatedComponenets = null;
    private Rectangle emptyRectangle = new Rectangle(0, 0, 0, 0);

    public AjaxSwingRepaintManager(ClientAgent agent) {
        TraceMgr.trace(this, "constructor");
        this.agent = agent;
        this.invalidatedComponenets = new ArrayList<JComponent>(50);
    }

    public ClientAgent getAgent() {
        return this.agent;
    }

    public void shutdown() {
        this.agent = null;
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
    }

    public synchronized JComponent[] getInvalidatedComponents() {
        JComponent[] components = this.invalidatedComponenets.toArray(new JComponent[0]);
        this.invalidatedComponenets.clear();
        return components;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent invalidComponent) {
        if (this.getAgent() != null && this.getAgent().getProps() != null) {
            boolean updateOnRepaint;
            if (TraceMgr.getCutoffLevel() >= 9) {
                TraceMgr.trace((Object)this, "addInvalidComponent " + NameUtils.getComponentName(invalidComponent), 9);
            }
            if ((updateOnRepaint = this.getAgent().getProps().getBooleanProperty("agent.monitorAsynchronousUpdates.updateOnRepaint", true)) && !this.getAgent().isRequestActive()) {
                this.getAgent().setUpdateBrowser(true);
            }
        } else {
            TraceMgr.trace((Object)this, "WARN: null agent in repaint manager, " + this.getAgent(), 4);
        }
    }

    @Override
    public Rectangle getDirtyRegion(JComponent component) {
        return this.emptyRectangle;
    }

    @Override
    public boolean isCompletelyDirty(JComponent component) {
        return false;
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        return super.isDoubleBufferingEnabled();
    }

    @Override
    public void markCompletelyClean(JComponent component) {
        TraceMgr.trace((Object)this, "markCompletelyClean", 10);
    }

    @Override
    public void markCompletelyDirty(JComponent component) {
        TraceMgr.trace((Object)this, "markCompletelyDirty", 10);
    }

    @Override
    public void paintDirtyRegions() {
        ClientAgentManager.setMyAgent(Thread.currentThread(), this.agent);
    }

    @Override
    public synchronized void removeInvalidComponent(JComponent component) {
        TraceMgr.trace((Object)this, "removeInvalidComponent", 9);
    }

    @Override
    public void validateInvalidComponents() {
        TraceMgr.trace((Object)this, "validateInvalidComponents", 9);
    }
}

