/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.gui.AjaxSwingGraphicsConfig;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import sun.awt.image.PublicManageable;
import sun.awt.image.SurfaceManager;

public class AjaxSwingVolatileImage
extends VolatileImage
implements PublicManageable {
    protected AjaxSwingGraphicsConfig graphicsConfig;
    protected BufferedImage image;
    protected ImageCapabilities imageCapabilities;

    public AjaxSwingVolatileImage(AjaxSwingGraphicsConfig graphicsConfig, int w, int h) {
        this.graphicsConfig = graphicsConfig;
        this.image = graphicsConfig.createCompatibleImage(w, h);
        this.initSurfaceManager();
    }

    public AjaxSwingVolatileImage(AjaxSwingGraphicsConfig graphicsConfig, int w, int h, int transparency) {
        this.graphicsConfig = graphicsConfig;
        this.image = graphicsConfig.createCompatibleImage(w, h, transparency);
        this.initSurfaceManager();
    }

    protected void initSurfaceManager() {
        SurfaceManager surfaceManager = SurfaceManager.getManager(this.image);
        SurfaceManager.setManager(this, surfaceManager);
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.image.getProperty(name, observer);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.image.getHeight(observer);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.image.getWidth(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    @Override
    public boolean contentsLost() {
        return false;
    }

    @Override
    public int validate(GraphicsConfiguration gc) {
        return 0;
    }

    @Override
    public BufferedImage getSnapshot() {
        return this.image;
    }

    @Override
    public ImageCapabilities getCapabilities() {
        if (this.imageCapabilities == null) {
            this.imageCapabilities = new ImageCapabilities(false);
        }
        return this.imageCapabilities;
    }

    public SurfaceManager getSurfaceManager() {
        return SurfaceManager.getManager(this.image);
    }
}

