/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.core.TraceMgr;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.ValidateEvent;
import java.awt.WaitEvent;
import java.awt.event.AjaxSwingDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;

public class SchedulingEventQueue
extends EventQueue {
    private final Map<AWTEvent, AWTEvent> eventSchedule = new HashMap<AWTEvent, AWTEvent>();
    private int processing = 0;
    private boolean blocked = false;
    private boolean processingFileDownload;
    private EventQueue pushedQueue = null;

    public void scheduleEvent(AWTEvent event, AWTEvent dependentEvent) {
        this.eventSchedule.put(dependentEvent, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchEvent(AWTEvent event) {
        try {
            if (event instanceof AjaxSwingDragEvent) {
                AjaxSwingDragEvent e = (AjaxSwingDragEvent)event;
                Point convertPoint = null;
                try {
                    convertPoint = SwingUtilities.convertPoint((Component)event.getSource(), e.getX(), e.getY(), null);
                }
                catch (Error error) {
                    // empty catch block
                }
                if (e.getStartLocation() != null && e.getStartLocation() != convertPoint) {
                    e.setX(e.getX() - (convertPoint.x - e.getStartLocation().x));
                    e.setY(e.getY() - (convertPoint.y - e.getStartLocation().y));
                }
            }
            if (event instanceof MouseEvent || event instanceof KeyEvent) {
                ++this.processing;
            }
            if (!(event instanceof WaitEvent)) {
                if (event instanceof ValidateEvent) {
                    if (event.getSource() instanceof Component) {
                        ((Component)event.getSource()).validate();
                    }
                } else {
                    super.dispatchEvent(event);
                }
            }
            if (event instanceof MouseEvent || event instanceof KeyEvent) {
                --this.processing;
                if (this.processing < 0) {
                    this.processing = 0;
                }
            }
        }
        finally {
            AWTEvent scheduledEvent = this.eventSchedule.remove(event);
            if (scheduledEvent != null) {
                this.postEvent(scheduledEvent);
            }
        }
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        this.processing = 0;
        return super.getNextEvent();
    }

    public boolean isEmpty() {
        boolean r = this.eventSchedule.isEmpty() && this.processing == 0;
        return r;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean b) {
        if (b) {
            Iterator<Map.Entry<AWTEvent, AWTEvent>> i = this.eventSchedule.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<AWTEvent, AWTEvent> e = i.next();
                if (!(e.getValue() instanceof WaitEvent)) continue;
                i.remove();
            }
            this.eventSchedule.clear();
            this.processing = 0;
        }
        this.blocked = b;
    }

    public boolean isProcessingFileDownload() {
        return this.processingFileDownload;
    }

    public void setProcessingFileDownload(boolean processingFileDownload) {
        this.processingFileDownload = processingFileDownload;
    }

    public void clearEvents() {
        this.eventSchedule.clear();
        this.processing = 0;
    }

    @Override
    public void push(EventQueue newEventQueue) {
        TraceMgr.trace("Intercepted replace EvenQueue with " + newEventQueue, 1);
        this.pushedQueue = newEventQueue;
    }
}

