/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.core.TraceMgr;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.AWTHelper;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.NativeEmulator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sun.awt.CausedFocusEvent;
import sun.java2d.pipe.Region;

public class AjaxSwingComponentPeer
implements ComponentPeer {
    protected Component target;
    protected JComponent delegate;
    protected BufferedImage image;

    public AjaxSwingComponentPeer(Component target) {
        TraceMgr.trace((Object)this, "constructor", 6);
        this.target = target;
        this.delegate = this.createDelegate();
        this.image = (BufferedImage)this.createImage(1, 1);
    }

    public JComponent createDelegate() {
        try {
            return new JPanel();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setDelegateComponent(JComponent delegate) {
        this.delegate = delegate;
    }

    public JComponent getDelegateComponent() {
        return this.delegate;
    }

    @Override
    public void setVisible(boolean b) {
        TraceMgr.trace((Object)this, "setVisible = " + b, 6);
        if (b) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.delegate.setEnabled(b);
    }

    @Override
    public void paint(Graphics g) {
        TraceMgr.trace((Object)this, "paint", 10);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        TraceMgr.trace((Object)this, "repaint", 10);
    }

    @Override
    public void print(Graphics g) {
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 3);
    }

    @Override
    public void handleEvent(AWTEvent e) {
        TraceMgr.trace((Object)this, "handleEvent " + e, 10);
    }

    @Override
    public Point getLocationOnScreen() {
        Point pt = new Point();
        for (Component c = this.target; c != null; c = c.getParent()) {
            pt.x += c.getX();
            pt.y += c.getY();
            if (c instanceof Window) break;
        }
        return pt;
    }

    @Override
    public Dimension getPreferredSize() {
        TraceMgr.trace((Object)this, "getPreferredSize", 10);
        return this.delegate.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        TraceMgr.trace((Object)this, "getMinimumSize", 10);
        return this.delegate.getMinimumSize();
    }

    @Override
    public ColorModel getColorModel() {
        TraceMgr.trace((Object)this, "getColorModel", 6);
        return this.getToolkit().getColorModel();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public synchronized Graphics getGraphics() {
        Graphics2D g = this.image.createGraphics();
        return g;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        TraceMgr.trace((Object)this, "getFontMetrics", 6);
        return this.getToolkit().getFontMetrics(font);
    }

    @Override
    public void dispose() {
        TraceMgr.trace(this, "dispose");
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setFont(Font font) {
        this.delegate.setFont(font);
    }

    public void setCursor(Cursor cursor) {
    }

    public void requestFocus() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Image createImage(ImageProducer producer) {
        TraceMgr.trace((Object)this, "createImage, producer", 6);
        return this.getToolkit().createImage(producer);
    }

    @Override
    public Image createImage(int width, int height) {
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace((Object)this, "createImage, w = " + width + ", h = " + height, 6);
        }
        return new BufferedImage(width, height, 1);
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().prepareImage(img, w, h, o);
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().checkImage(img, w, h, o);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        TraceMgr.trace((Object)this, "show", 6);
    }

    public void hide() {
        TraceMgr.trace((Object)this, "hide", 6);
    }

    public void enable() {
        TraceMgr.trace((Object)this, "enable", 6);
    }

    public void disable() {
        TraceMgr.trace((Object)this, "disable", 6);
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void updateCursorImmediately() {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        AWTHelper.setGlobalFocusOwner(lightweightChild);
        return true;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        return null;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    public void flip(BufferCapabilities.FlipContents flipAction) {
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
    }

    public JComponent getDelegate() {
        return this.delegate;
    }

    public void setDelegate(JComponent delegate) {
        this.delegate = delegate;
    }

    public Image getImage() {
        return this.image;
    }

    public Component getTarget() {
        return this.target;
    }

    public void setTarget(Component target) {
        this.target = target;
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(this.target.getX(), this.target.getY(), this.target.getWidth(), this.target.getHeight());
    }

    public Rectangle getBounds() {
        return this.getDelegateComponent().getBounds();
    }

    @Override
    public void setBounds(int x, int y, int w, int h, int mode) {
        TraceMgr.trace((Object)this, "setBounds", 10);
        this.getDelegateComponent().setBounds(this.target.getX(), this.target.getY(), this.target.getWidth(), this.target.getHeight());
    }

    @Override
    public void layout() {
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void reparent(ContainerPeer containerpeer) {
    }

    public boolean requestFocus(final Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        if (SwingUtilities.isEventDispatchThread()) {
            NativeEmulator.emulateFocusNative(lightweightChild);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeEmulator.emulateFocusNative(lightweightChild);
                }
            });
        }
        return true;
    }

    @Override
    public void applyShape(Region shape) {
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        return false;
    }

    @Override
    public void setZOrder(ComponentPeer above) {
    }

    public GraphicsConfiguration getAppropriateGraphicsConfiguration(GraphicsConfiguration gc) {
        return gc;
    }
}

