/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.AjaxSwingDragSourceContextPeer;
import java.awt.dnd.AjaxSwingDropTargetContextPeer;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

public class AjaxSwigV4DragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final long serialVersionUID = -3527844310018033570L;
    protected static int motionThreshold;
    protected static final int ButtonMask = 7168;
    private AjaxSwingDragSourceContextPeer ajaxSwingDragSourceContextPeer;
    private AjaxSwingDropTargetContextPeer ajaxSwingDropTargetContextPeer;

    public AjaxSwigV4DragGestureRecognizer(DragSource paramDragSource, Component paramComponent, int paramInt, DragGestureListener paramDragGestureListener) {
        super(paramDragSource, paramComponent, paramInt, paramDragGestureListener);
    }

    public AjaxSwigV4DragGestureRecognizer(DragSource paramDragSource, Component paramComponent, int paramInt) {
        this(paramDragSource, paramComponent, paramInt, null);
    }

    public AjaxSwigV4DragGestureRecognizer(DragSource paramDragSource, Component paramComponent) {
        this(paramDragSource, paramComponent, 0);
    }

    public AjaxSwigV4DragGestureRecognizer(DragSource paramDragSource) {
        this(paramDragSource, null);
    }

    public int mapDragOperationFromModifiers(MouseEvent paramMouseEvent) {
        int i = paramMouseEvent.getModifiersEx();
        int j = i & 0x1C00;
        if (j != 1024 && j != 2048 && j != 4096) {
            return 0;
        }
        return SunDragSourceContextPeer.convertModifiersToDropAction(i, this.getSourceActions());
    }

    @Override
    public void mousePressed(MouseEvent paramMouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(paramMouseEvent) == 0) {
            return;
        }
        try {
            motionThreshold = DragSource.getDragThreshold();
        }
        catch (Exception localException) {
            motionThreshold = 5;
        }
        this.appendEvent(paramMouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent paramMouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseEntered(MouseEvent paramMouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseExited(MouseEvent paramMouseEvent) {
        int i;
        if (!this.events.isEmpty() && (i = this.mapDragOperationFromModifiers(paramMouseEvent)) == 0) {
            this.events.clear();
        }
    }

    @Override
    public void mouseDragged(MouseEvent paramMouseEvent) {
        if (!this.events.isEmpty()) {
            int i = this.mapDragOperationFromModifiers(paramMouseEvent);
            if (i == 0) {
                return;
            }
            MouseEvent localMouseEvent = (MouseEvent)this.events.get(0);
            Point localPoint1 = localMouseEvent.getPoint();
            Point localPoint2 = paramMouseEvent.getPoint();
            int j = Math.abs(localPoint1.x - localPoint2.x);
            int k = Math.abs(localPoint1.y - localPoint2.y);
            if (j > motionThreshold || k > motionThreshold) {
                this.fireDragGestureRecognized(i, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(paramMouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent paramMouseEvent) {
    }

    public void setSourcePeer(AjaxSwingDragSourceContextPeer ajaxSwingDragSourceContextPeer) {
        this.ajaxSwingDragSourceContextPeer = ajaxSwingDragSourceContextPeer;
    }

    public AjaxSwingDragSourceContextPeer getAjaxSwingDragSourceContextPeer() {
        return this.ajaxSwingDragSourceContextPeer;
    }

    public AjaxSwingDropTargetContextPeer getAjaxSwingDropTargetContextPeer() {
        return this.ajaxSwingDropTargetContextPeer;
    }

    public void setAjaxSwingDropTargetContextPeer(AjaxSwingDropTargetContextPeer ajaxSwingDropTargetContextPeer) {
        this.ajaxSwingDropTargetContextPeer = ajaxSwingDropTargetContextPeer;
    }
}

