/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.GetPropertyAction;

public abstract class GraphicsEnvironment {
    private static GraphicsEnvironment localEnv;
    private static Boolean headless;
    private static Boolean defaultHeadless;

    protected GraphicsEnvironment() {
    }

    public static synchronized GraphicsEnvironment getLocalGraphicsEnvironment() {
        if (localEnv == null) {
            localEnv = GraphicsEnvironment.createGE();
        }
        return localEnv;
    }

    private static GraphicsEnvironment createGE() {
        GraphicsEnvironment ge;
        String nm = AccessController.doPrivileged(new GetPropertyAction("java.awt.graphicsenv", null));
        try {
            Class<?> geCls;
            try {
                geCls = Class.forName(nm);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                geCls = Class.forName(nm, true, cl);
            }
            ge = (GraphicsEnvironment)geCls.newInstance();
            if (GraphicsEnvironment.isHeadless()) {
                ge = new HeadlessGraphicsEnvironment(ge);
            }
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not find class: " + nm);
        }
        catch (InstantiationException e) {
            throw new Error("Could not instantiate Graphics Environment: " + nm);
        }
        catch (IllegalAccessException e) {
            throw new Error("Could not access Graphics Environment: " + nm);
        }
        return ge;
    }

    public static boolean isHeadless() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        String callerName = null;
        if (stackTrace.length > 3) {
            callerName = stackTrace[3].getClassName() + "." + stackTrace[3].getMethodName();
        }
        if ("java.awt.Toolkit.getDefaultToolkit".equals(callerName)) {
            return false;
        }
        String[] listOfExcludes = new String[]{"javax.swing.PopupFactory.getPopup", "java.applet.Applet.<init>", "java.applet.Applet.readObject", "java.awt.Window.init", "java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment", "java.awt.GraphicsEnvironment.createGE", "java.awt.Component.getMousePosition", "java.awt.Container.getMousePosition", "java.awt.Desktop.getDesktop", "java.awt.MouseInfo.getNumberOfButtons", "java.awt.Robot.<init>", "java.awt.MouseInfo.getPointerInfo", "java.awt.SplashScreen.getSplashScreen", "java.awt.SystemTray.getSystemTray", "java.awt.TrayIcon.<init>", "java.awt.dnd.DragSource.<init>", "java.awt.dnd.DragSource.<clinit>", "java.awt.dnd.DragSource.load", "java.awt.dnd.DragSource.getDefaultDragSource", "java.awt.dnd.DropTarget.<init>", "java.beans.Beans.<clinit>", "javax.print.ServiceUI.printDialog", "javax.swing.JColorChooser.setDragEnabled", "javax.swing.JFileChooser.setDragEnabled", "javax.swing.JList.setDragEnabled", "javax.swing.JTable.setDragEnabled", "javax.swing.JTable.print", "sun.print.RasterPrinterJob.printDialog", "javax.swing.JTree.setDragEnabled", "javax.swing.text.JTextComponent.print", "javax.swing.text.JTextComponent.setDragEnabled", "java.beans.ThreadGroupContext.isGuiAvailable"};
        for (int i = 0; i < listOfExcludes.length; ++i) {
            if (!listOfExcludes[i].equals(stackTrace[1].getClassName() + "." + stackTrace[1].getMethodName())) continue;
            return false;
        }
        return GraphicsEnvironment.getHeadlessProperty();
    }

    static String getHeadlessMessage() {
        if (headless == null) {
            GraphicsEnvironment.getHeadlessProperty();
        }
        return defaultHeadless != Boolean.TRUE ? null : "\nNo X11 DISPLAY variable was set, but this program performed an operation which requires it.";
    }

    private static boolean getHeadlessProperty() {
        if (headless == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String nm = System.getProperty("java.awt.headless");
                    if (nm == null) {
                        if (System.getProperty("javaplugin.version") != null) {
                            headless = (defaultHeadless = Boolean.FALSE);
                        } else {
                            String osName = System.getProperty("os.name");
                            if (osName.contains("OS X") && "sun.awt.HToolkit".equals(System.getProperty("awt.toolkit"))) {
                                headless = (defaultHeadless = Boolean.TRUE);
                            } else {
                                headless = (defaultHeadless = ("Linux".equals(osName) || "SunOS".equals(osName) || "FreeBSD".equals(osName) || "NetBSD".equals(osName) || "OpenBSD".equals(osName)) && System.getenv("DISPLAY") == null);
                            }
                        }
                    } else if (nm.equals("true")) {
                        headless = Boolean.TRUE;
                    } else {
                        headless = Boolean.FALSE;
                    }
                    return null;
                }
            });
        }
        return headless;
    }

    static void checkHeadless() throws HeadlessException {
    }

    public boolean isHeadlessInstance() {
        return GraphicsEnvironment.getHeadlessProperty();
    }

    public abstract GraphicsDevice[] getScreenDevices() throws HeadlessException;

    public abstract GraphicsDevice getDefaultScreenDevice() throws HeadlessException;

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);

    public boolean registerFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font cannot be null.");
        }
        FontManager fm = FontManagerFactory.getInstance();
        return fm.registerFont(font);
    }

    public void preferLocaleFonts() {
        FontManager fm = FontManagerFactory.getInstance();
        fm.preferLocaleFonts();
    }

    public void preferProportionalFonts() {
        FontManager fm = FontManagerFactory.getInstance();
        fm.preferProportionalFonts();
    }

    public Point getCenterPoint() throws HeadlessException {
        Rectangle usableBounds = SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
        return new Point(usableBounds.width / 2 + usableBounds.x, usableBounds.height / 2 + usableBounds.y);
    }

    public Rectangle getMaximumWindowBounds() throws HeadlessException {
        return SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
    }
}

