/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.gui.SchedulingEventQueue;
import com.creamtec.ajaxswing.v4.utils.ComponentUtils;
import com.creamtec.core.TraceMgr;
import java.awt.AWTEvent;
import java.awt.AWTHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.ValidateEvent;
import java.awt.WaitEvent;
import java.awt.Window;
import java.awt.dnd.AjaxSwingDndSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AjaxSwingDragEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingHelper;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class NativeEmulator {
    private static final int AJS_WHEEL_SCROLL_DELTA = 50;

    public static void mouseRightClick(Component source, Point startPoint) {
        NativeEmulator.mouseRightClick(source, startPoint, 0);
    }

    public static void mouseRightClick(Component source, Point startPoint, int modifiersEx) {
        Component deepest = null;
        if (source instanceof Container) {
            deepest = NativeEmulator.getEventTarget(source, startPoint);
        }
        if (deepest == null) {
            deepest = source;
        }
        if (deepest != source) {
            startPoint = SwingUtilities.convertPoint(source, startPoint, deepest);
        }
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        int modifiers = 4 | modifiersEx;
        MouseEvent pressed = new MouseEvent(deepest, 501, System.currentTimeMillis(), modifiers, startPoint.x, startPoint.y, 1, true, 3);
        MouseEvent released = new MouseEvent(deepest, 502, System.currentTimeMillis(), modifiers, startPoint.x, startPoint.y, 1, true, 3);
        MouseEvent clicked = new MouseEvent(deepest, 500, System.currentTimeMillis(), modifiers, startPoint.x, startPoint.y, 1, true, 3);
        WaitEvent waited = new WaitEvent(deepest);
        eventQueue.scheduleEvent(waited, clicked);
        eventQueue.scheduleEvent(clicked, released);
        eventQueue.scheduleEvent(released, pressed);
        eventQueue.postEvent(pressed);
        NativeEmulator.waitEventProcessed(eventQueue);
    }

    public static void mouseLeftClick(Component source, Point startPoint, int clickCount) {
        NativeEmulator.mouseLeftClick(source, startPoint, clickCount, 0);
    }

    public static void mouseLeftClick(Component source, Point startPoint, int clickCount, int modifiersEx) {
        Container active = ComponentUtils.getActiveWindow();
        if (source instanceof Window && !source.isVisible()) {
            TraceMgr.trace("Ignore mouse" + (clickCount == 2 ? "Double" : "") + "LeftClick for[" + source.getClass().getName() + "] because window is not visible", TraceMgr.DEFAULT_TRACE_LEVEL);
            return;
        }
        if (active instanceof Dialog && ((Dialog)active).isModal() && source != active) {
            TraceMgr.trace("Ignore mouse" + (clickCount == 2 ? "Double" : "") + "LeftClick for[" + source.getClass().getName() + "] because there is another modal dialog", TraceMgr.DEFAULT_TRACE_LEVEL);
            return;
        }
        Component deepest = NativeEmulator.getDeepest(source, startPoint);
        Point clickPoint = NativeEmulator.agjustStartPoint(source, startPoint, deepest);
        NativeEmulator.jMenuItemHack(deepest);
        NativeEmulator.emulateWindowFocusIfNeeded(deepest);
        TraceMgr.trace("Mose left click on: " + deepest, 10);
        int modifiers = 0x10 | modifiersEx;
        long emulatedEventTime = System.currentTimeMillis();
        MouseEvent entered = new MouseEvent(deepest, 504, emulatedEventTime, modifiers, clickPoint.x, clickPoint.y, clickCount, false, 1);
        MouseEvent pressed = new MouseEvent(deepest, 501, emulatedEventTime += 1000L, modifiers, clickPoint.x, clickPoint.y, clickCount, false, 1);
        MouseEvent released = new MouseEvent(deepest, 502, emulatedEventTime += 100L, modifiers, clickPoint.x, clickPoint.y, clickCount, false, 1);
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        if (deepest instanceof JMenu && !((JMenu)deepest).isTopLevelMenu()) {
            eventQueue.scheduleEvent(pressed, entered);
            eventQueue.postEvent(entered);
        } else {
            eventQueue.scheduleEvent(pressed, entered);
            eventQueue.scheduleEvent(released, pressed);
            eventQueue.postEvent(entered);
        }
        NativeEmulator.waitEventProcessed(eventQueue);
        Component deepest_afterPressedReleased = NativeEmulator.getDeepest(source, startPoint);
        clickPoint = NativeEmulator.agjustStartPoint(source, startPoint, deepest_afterPressedReleased);
        NativeEmulator.jMenuItemHack(deepest);
        if (deepest == deepest_afterPressedReleased) {
            MouseEvent clicked = new MouseEvent(deepest_afterPressedReleased, 500, emulatedEventTime += 100L, modifiers, clickPoint.x, clickPoint.y, clickCount, false, 1);
            eventQueue.postEvent(clicked);
            NativeEmulator.waitEventProcessed(eventQueue);
        }
        if (deepest instanceof JMenu) {
            JMenu menu = (JMenu)deepest;
            ((JMenu)deepest).setDelay(0);
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            JPopupMenu popup = menu.getPopupMenu();
            if (popup != null) {
                MenuElement[] newPath = new MenuElement[path.length + 1];
                System.arraycopy(path, 0, newPath, 0, path.length);
                newPath[path.length] = popup;
                msm.setSelectedPath(newPath);
            }
        }
    }

    public static void waitEventProcessed(SchedulingEventQueue eventQueue) {
        long time = System.currentTimeMillis();
        while (!eventQueue.isEmpty() && !eventQueue.isBlocked()) {
            try {
                Thread.sleep(1L);
                if (System.currentTimeMillis() - time <= 45000L) continue;
                TraceMgr.trace("EventProcessed skip after 45s", 2);
                eventQueue.clearEvents();
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        while (eventQueue.isProcessingFileDownload()) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
        if (eventQueue.isBlocked()) {
            eventQueue.setBlocked(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void jMenuItemHack(Component deepest) {
        if (deepest instanceof JMenuItem && deepest.getParent() instanceof JMenu) {
            ((JMenu)deepest.getParent()).setDelay(0);
        }
    }

    private static Component getDeepest(Component source, Point startPoint) {
        Component deepest = null;
        if (source instanceof Container) {
            deepest = NativeEmulator.getEventTarget(source, startPoint);
        }
        if (deepest == null) {
            deepest = source;
        }
        return deepest;
    }

    private static Point agjustStartPoint(Component source, Point startPoint, Component targetComponent) {
        if (targetComponent != source) {
            return SwingUtilities.convertPoint(source, startPoint, targetComponent).getLocation();
        }
        return startPoint.getLocation();
    }

    private static void emulateWindowFocusIfNeeded(Component component) {
        Window window = null;
        window = ComponentUtils.isWindow(component) ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window != null && !window.isFocused() && !SwingHelper.isAPopupHeavyWeightWindow(window)) {
            NativeEmulator.emulateFocus(window);
        }
    }

    private static Component getEventTarget(Component source, Point startPoint) {
        Point startPoint2;
        Component target = ((Container)source).getMouseEventTarget(startPoint.x, startPoint.y, true);
        Component deepest = SwingUtilities.getDeepestComponentAt(source, startPoint.x, startPoint.y);
        Container layer = SwingUtilities.getAncestorOfClass(JPopupMenu.class, deepest);
        if (target == null) {
            if ((deepest = NativeEmulator.getEventTargetCheckOverlap(deepest, source, startPoint)) != null) {
                startPoint2 = SwingUtilities.convertPoint(source, startPoint, deepest);
                target = ((Container)deepest).getMouseEventTarget(startPoint2.x, startPoint2.y, true);
            }
            if (target == null) {
                target = deepest;
            }
        }
        if (target != source || target instanceof JFrame) {
            // empty if block
        }
        if (layer != null) {
            startPoint2 = SwingUtilities.convertPoint(source, startPoint, layer);
            target = layer.getMouseEventTarget(startPoint2.x, startPoint2.y, true);
            if (target == null) {
                target = deepest;
            }
        }
        return target;
    }

    private static Component getEventTargetCheckOverlap(Component deepest, Component source, Point startPoint) {
        try {
            if (deepest.getMouseListeners().length == 0) {
                Container parent = deepest.getParent();
                if (parent instanceof JTabbedPane) {
                    Component tabComponent = ((JTabbedPane)parent).getSelectedComponent();
                    parent = tabComponent instanceof Container ? (Container)tabComponent : tabComponent.getParent();
                }
                Point parentPoint = SwingUtilities.convertPoint(source, startPoint, parent);
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component retarget = parent.getComponent(i);
                    Point retargetPoint = SwingUtilities.convertPoint(parent, parentPoint, retarget);
                    if (retarget == deepest || !SwingUtilities.getLocalBounds(retarget).contains(retargetPoint)) continue;
                    return retarget;
                }
            }
        }
        catch (Exception ex) {
            return deepest;
        }
        return deepest;
    }

    public static void mouseDragAndDrop(Component source, Component target, Point startPoint, Point targetPoint, int middlePoints) {
        Component deepest = null;
        if (source instanceof Container) {
            deepest = NativeEmulator.getEventTarget(source, startPoint);
        }
        if (deepest == null) {
            deepest = source;
        }
        if (deepest instanceof JTextComponent) {
            // empty if block
        }
        if (deepest != source) {
            startPoint = SwingUtilities.convertPoint(source, startPoint, deepest);
            targetPoint = SwingUtilities.convertPoint(source, targetPoint, deepest);
        }
        middlePoints = Math.max(Math.abs(targetPoint.y - startPoint.y), Math.abs(targetPoint.x - startPoint.x));
        middlePoints = Math.min(Math.max(1, middlePoints / 3), 30);
        float dx = (float)(targetPoint.x - startPoint.x) / (float)middlePoints;
        float dy = (float)(targetPoint.y - startPoint.y) / (float)middlePoints;
        MouseEvent pressed = new MouseEvent(deepest, 501, System.currentTimeMillis(), 16, startPoint.x, startPoint.y, 1, false, 1);
        MouseEvent dragged = new MouseEvent(deepest, 506, System.currentTimeMillis(), 16, startPoint.x, startPoint.y, 1, false, 1);
        AjaxSwingDragEvent dragged2 = new AjaxSwingDragEvent(deepest, 506, System.currentTimeMillis(), 16, targetPoint.x, targetPoint.y, 1, false, 1);
        AjaxSwingDragEvent released = new AjaxSwingDragEvent(deepest, 502, System.currentTimeMillis(), 16, targetPoint.x, targetPoint.y, 1, false, 1);
        WaitEvent waited = new WaitEvent(deepest);
        ValidateEvent validate = new ValidateEvent(deepest.getParent() == null ? deepest : (deepest.getParent().getParent() == null ? deepest.getParent() : deepest.getParent().getParent()));
        Point targetConvert = null;
        try {
            targetConvert = SwingUtilities.convertPoint(deepest, targetPoint.x, targetPoint.y, null);
        }
        catch (Error ex) {
            TraceMgr.trace("WARN: Failed to get convertPoint in drag", ex, TraceMgr.DEFAULT_WARNING_LEVEL);
        }
        dragged2.setStartLocation(targetConvert);
        released.setStartLocation(targetConvert);
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        eventQueue.scheduleEvent(waited, released);
        eventQueue.scheduleEvent(released, validate);
        eventQueue.scheduleEvent(validate, dragged2);
        if (middlePoints > 0) {
            Point startLocation = null;
            try {
                startLocation = SwingUtilities.convertPoint(deepest, startPoint.x, startPoint.y, null);
            }
            catch (Error error) {
                // empty catch block
            }
            MouseEvent previousEvent = dragged;
            for (int i = 1; i < middlePoints; ++i) {
                AjaxSwingDragEvent event = new AjaxSwingDragEvent(deepest, 506, System.currentTimeMillis(), 16, (int)((float)startPoint.x + dx * (float)i), (int)((float)startPoint.y + dy * (float)i), 1, false, 1);
                event.setStartLocation(startLocation);
                eventQueue.scheduleEvent(event, previousEvent);
                previousEvent = event;
                try {
                    startLocation = SwingUtilities.convertPoint((Component)event.getSource(), event.getX(), event.getY(), null);
                    continue;
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            eventQueue.scheduleEvent(dragged2, previousEvent);
        } else {
            eventQueue.scheduleEvent(dragged2, dragged);
        }
        eventQueue.scheduleEvent(dragged, pressed);
        int trackBeforeLength = 4;
        int stepLength = 2;
        int moveBeforePoints = Math.max(2, trackBeforeLength / stepLength);
        MouseEvent previousEvent = pressed;
        for (int i = 0; i <= moveBeforePoints; ++i) {
            MouseEvent event = new MouseEvent(deepest, 503, System.currentTimeMillis(), 0, startPoint.x - i * stepLength, startPoint.y - i * stepLength, 1, false, 0);
            eventQueue.scheduleEvent(previousEvent, event);
            previousEvent = event;
        }
        eventQueue.postEvent(previousEvent);
        NativeEmulator.waitEventProcessed(eventQueue);
        try {
            AjaxSwingDndSupport.doDragAndDrop(deepest, deepest, startPoint, targetPoint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void keypress(Component comp, int modifiers, int keyCode) {
        NativeEmulator.keypress(comp, modifiers, keyCode, (char)keyCode, 1);
    }

    public static void keypress(Component comp, int modifiers, int keyCode, char keyChar, int location) {
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        KeyEvent pressed = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, keyCode, keyChar, location);
        KeyEvent released = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, keyCode, keyChar, location);
        KeyEvent clicked = new KeyEvent(comp, 400, System.currentTimeMillis(), modifiers, 0, keyChar);
        WaitEvent waited = new WaitEvent(comp);
        LinkedList<AWTEvent> eventsList = new LinkedList<AWTEvent>();
        eventsList.add(waited);
        if (pressed.isShiftDown()) {
            KeyEvent releasedShift = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, 16, '\uffff', location);
            eventsList.add(releasedShift);
        }
        if (pressed.isAltDown()) {
            KeyEvent releasedAlt = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, 18, '\uffff', location);
            eventsList.add(releasedAlt);
        }
        if (pressed.isAltGraphDown()) {
            KeyEvent releasedAltGraph = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, 65406, '\uffff', location);
            eventsList.add(releasedAltGraph);
        }
        if (pressed.isControlDown()) {
            KeyEvent releasedCtrl = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, 17, '\uffff', location);
            eventsList.add(releasedCtrl);
        }
        eventsList.add(released);
        eventsList.add(clicked);
        eventsList.add(pressed);
        if (pressed.isControlDown()) {
            KeyEvent pressedCtrl = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, 17, '\uffff', location);
            eventsList.add(pressedCtrl);
        }
        if (pressed.isAltDown()) {
            KeyEvent pressedAlt = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, 18, '\uffff', location);
            eventsList.add(pressedAlt);
        }
        if (pressed.isAltGraphDown()) {
            KeyEvent pressedAltGraph = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, 65406, '\uffff', location);
            eventsList.add(pressedAltGraph);
        }
        if (pressed.isShiftDown()) {
            KeyEvent pressedShift = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, 16, '\uffff', location);
            eventsList.add(pressedShift);
        }
        for (int i = 0; i < eventsList.size() - 1; ++i) {
            eventQueue.scheduleEvent((AWTEvent)eventsList.get(i), (AWTEvent)eventsList.get(i + 1));
        }
        eventQueue.postEvent((AWTEvent)eventsList.get(eventsList.size() - 1));
        NativeEmulator.waitEventProcessed(eventQueue);
    }

    public static void keytype(Component comp, int modifiers, int keyCode, char keyChar) {
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        KeyEvent pressed = new KeyEvent(comp, 401, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        KeyEvent released = new KeyEvent(comp, 402, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        KeyEvent clicked = new KeyEvent(comp, 400, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        WaitEvent waited = new WaitEvent(comp);
        eventQueue.scheduleEvent(waited, released);
        eventQueue.scheduleEvent(released, clicked);
        eventQueue.scheduleEvent(clicked, pressed);
        eventQueue.postEvent(pressed);
        NativeEmulator.waitEventProcessed(eventQueue);
    }

    public static void emulateEnter(JTextField comp, int modifiers, int keyCode) {
        String actionPerformedPropertyName = "actionPerformed";
        ActionListener actionPerformedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JTextField)e.getSource()).putClientProperty("actionPerformed", true);
            }
        };
        comp.addActionListener(actionPerformedListener);
        NativeEmulator.keypress(comp, modifiers, keyCode);
        comp.removeActionListener(actionPerformedListener);
        Boolean isActionPerformed = (Boolean)comp.getClientProperty("actionPerformed");
        if (isActionPerformed != null && isActionPerformed.booleanValue()) {
            return;
        }
        NativeEmulator.actionPerformed(comp, keyCode);
    }

    public static void emulateWindowFocus(Component comp, Window lastWindow) {
        ComponentEvent event;
        if (comp instanceof Window && !SwingHelper.isAPopupHeavyWeightWindow((Window)comp)) {
            if (lastWindow != null && comp != lastWindow) {
                WindowEvent lostEvent = new WindowEvent(lastWindow, 208);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(lostEvent);
            }
            event = new WindowEvent((Window)comp, 207);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
        }
        event = new FocusEvent(comp, 1004);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
        if (comp instanceof Window) {
            try {
                if (!Boolean.TRUE.equals(ClientAgent.getCurrentInstance().getSession().get("clientAgent.mainInvoke"))) {
                    Component newdest;
                    Component dest;
                    Component start = dest = ((Window)comp).getFocusTraversalPolicy().getDefaultComponent((Window)comp);
                    while (dest instanceof JPanel && (newdest = ((Window)comp).getFocusTraversalPolicy().getComponentAfter((Container)dest, dest)) != dest && newdest != start) {
                        dest = newdest;
                    }
                    if (comp == KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner()) {
                        event = new FocusEvent(dest, 1004);
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalFocusOwner(dest);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void emulateFocus(Component comp) {
        NativeEmulator.emulateFocus(comp, null);
    }

    public static void emulateFocus(Component comp, ClientAgent agent) {
        if (comp instanceof Window) {
            if (agent == null) {
                agent = ClientAgent.getCurrentInstance();
            }
            Window lastWindow = null;
            try {
                lastWindow = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (lastWindow == null) {
                    lastWindow = (Window)ComponentUtils.getActiveWindow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (comp == lastWindow) {
                return;
            }
            if (lastWindow != null && comp != lastWindow) {
                WindowEvent lostEvent = new WindowEvent(lastWindow, 208);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(lostEvent);
            }
            WindowEvent event = new WindowEvent((Window)comp, 207);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
        } else {
            Window window = SwingUtilities.getWindowAncestor(comp);
            if (window != null && !window.isFocused()) {
                NativeEmulator.emulateFocus(window);
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalFocusOwner(comp);
        }
    }

    public static void emulateFocusLost(Component comp) {
        FocusEvent event = new FocusEvent(comp, 1005);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
    }

    public static void waitEventThread(Component comp) {
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        WaitEvent waited1 = new WaitEvent(comp);
        WaitEvent waited2 = new WaitEvent(comp);
        eventQueue.scheduleEvent(waited1, waited2);
        eventQueue.postEvent(waited2);
        NativeEmulator.waitEventProcessed(eventQueue);
    }

    public static void emulateWindowHide(Window window) {
        try {
            List windows;
            int i;
            JLayeredPane layers;
            JRootPane pane = SwingUtilities.getRootPane(window);
            if (pane != null && (layers = pane.getLayeredPane()) != null) {
                for (i = 0; i < layers.getComponentCount(); ++i) {
                    if (!(layers.getComponent(i) instanceof JPopupMenu)) continue;
                    layers.getComponent(i).setVisible(false);
                }
            }
            if ((windows = ClientAgent.getCurrentInstance().getUIManager().getWindows()) != null) {
                for (i = 0; i < windows.size(); ++i) {
                    if (!(windows.get(i) instanceof JPopupMenu)) continue;
                    ((JPopupMenu)windows.get(i)).setVisible(false);
                }
            }
        }
        catch (Throwable ex) {
            TraceMgr.trace(ex, "WANR: failed to hide popups on window hide");
        }
    }

    public static void emulateFrameFocus(JInternalFrame comp) {
        Window window = SwingUtilities.getWindowAncestor(comp);
        try {
            Component newdest;
            Component dest;
            Component start = dest = window.getFocusTraversalPolicy().getComponentAfter(comp, comp);
            while (dest instanceof JPanel && (newdest = comp.getFocusTraversalPolicy().getComponentAfter((Container)dest, dest)) != dest && newdest != start) {
                dest = newdest;
            }
            if (comp == KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner()) {
                FocusEvent event = new FocusEvent(dest, 1004);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalFocusOwner(dest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void emulateFocusNative(Component dest) {
        Caret caret;
        FocusEvent event = new FocusEvent(dest, 1004);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(event);
        AWTHelper.setGlobalFocusOwner(dest);
        if (dest instanceof JTextComponent && (caret = ((JTextComponent)dest).getCaret()) != null) {
            caret.setVisible(false);
        }
    }

    public static void mouseWheel(Component source, Point startPoint, int wheelValue, int modifiers) {
        Component deepest = null;
        if (source instanceof Container) {
            deepest = NativeEmulator.getEventTarget(source, startPoint);
        }
        if (deepest == null) {
            deepest = source;
        }
        if (deepest != source) {
            startPoint = SwingUtilities.convertPoint(source, startPoint, deepest);
        }
        SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
        for (int i = 0; i < Math.abs(wheelValue / 50); ++i) {
            MouseWheelEvent wheel = new MouseWheelEvent(deepest, 507, System.currentTimeMillis(), modifiers, startPoint.x, startPoint.y, 0, false, 0, 50, Integer.signum(wheelValue) * -1);
            WaitEvent waited = new WaitEvent(deepest);
            eventQueue.scheduleEvent(waited, wheel);
            eventQueue.postEvent(wheel);
        }
        NativeEmulator.waitEventProcessed(eventQueue);
    }

    public static void typeText(Component comp, String text, String oldText) {
        comp.requestFocus();
        Caret c = ((JTextComponent)comp).getCaret();
        if (c != null) {
            c.setDot(0);
            c.setVisible(false);
        }
        if (text.length() == 0 && oldText != null && oldText.length() > 0) {
            for (int i = 0; i < oldText.length(); ++i) {
                int keyCode = 127;
                int modifiers = 0;
                NativeEmulator.keypress(comp, modifiers, keyCode);
            }
            ((JTextComponent)comp).setText("");
        } else {
            ((JTextComponent)comp).setText("");
            for (int i = 0; i < text.length(); ++i) {
                char keyChar = text.charAt(i);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyChar);
                int keyCode = keyStroke.getKeyCode();
                int modifiers = keyStroke.getModifiers();
                if ('\t' == keyChar || keyChar == '\n') {
                    try {
                        final char finalChar = keyChar;
                        final Component finalComp = comp;
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)finalComp).replaceSelection(String.valueOf(finalChar));
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                NativeEmulator.keytype(comp, modifiers, keyCode, keyChar);
            }
        }
    }

    public static void actionPerformed(Component comp, int keyCode) {
        try {
            JTextField tf = (JTextField)comp;
            ActionListener[] list = tf.getActionListeners();
            String keyText = KeyEvent.getKeyText(keyCode);
            ActionEvent actionEvent = new ActionEvent(tf, 1001, keyText);
            for (int i = 0; i < list.length; ++i) {
                list[i].actionPerformed(actionEvent);
            }
        }
        catch (Exception ex) {
            TraceMgr.trace(ex, "Failed to emulate action performed on textfield");
        }
    }

    public static void emulateMouseEnter(Component comp, Point point) {
        if (comp instanceof JMenu) {
            ((JMenu)comp).setDelay(0);
        }
        ClientAgent.getCurrentInstance().getSchedulingEventQueue().postEvent(NativeEmulator.createMouseEnterEvent(comp, point));
    }

    private static MouseEvent createMouseEnterEvent(Component comp, Point point) {
        return new MouseEvent(comp, 504, System.currentTimeMillis(), 0, point.x, point.y, 0, false, 0);
    }
}

