/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import com.creamtec.ajaxswing.core.AjaxSwingUnderlineCharAtHint;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.font.FontDesignMetrics;
import sun.font.FontUtilities;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.ProxyPrintGraphics;
import sun.swing.ImageIconUIResource;
import sun.swing.PrintColorUIResource;
import sun.swing.StringUIClientPropertyKey;

public class SwingUtilities2 {
    public static final Object LAF_STATE_KEY = new StringBuffer("LookAndFeel State");
    public static final Object MENU_SELECTION_MANAGER_LISTENER_KEY = new StringBuffer("MenuSelectionManager listener key");
    private static LSBCacheEntry[] fontCache;
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static LSBCacheEntry searchKey;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    public static final FontRenderContext DEFAULT_FRC;
    public static final Object AA_TEXT_PROPERTY_KEY;
    public static final String IMPLIED_CR = "CR";
    private static final StringBuilder SKIP_CLICK_COUNT;
    public static final Object COMPONENT_UI_PROPERTY_KEY;
    public static final StringUIClientPropertyKey BASICMENUITEMUI_MAX_TEXT_OFFSET;
    private static Field inputEvent_CanAccessSystemClipboard_Field;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock;
    private static char[] charsBuffer;

    private static int syncCharsBuffer(String paramString) {
        int i = paramString.length();
        if (charsBuffer == null || charsBuffer.length < i) {
            charsBuffer = paramString.toCharArray();
        } else {
            paramString.getChars(0, i, charsBuffer, 0);
        }
        return i;
    }

    public static final boolean isComplexLayout(char[] paramArrayOfChar, int paramInt1, int paramInt2) {
        return FontUtilities.isComplexText(paramArrayOfChar, paramInt1, paramInt2);
    }

    public static AATextInfo drawTextAntialiased(JComponent paramJComponent) {
        if (paramJComponent != null) {
            return (AATextInfo)paramJComponent.getClientProperty(AA_TEXT_PROPERTY_KEY);
        }
        return null;
    }

    public static int getLeftSideBearing(JComponent paramJComponent, FontMetrics paramFontMetrics, String paramString) {
        if (paramString == null || paramString.length() == 0) {
            return 0;
        }
        return SwingUtilities2.getLeftSideBearing(paramJComponent, paramFontMetrics, paramString.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(JComponent paramJComponent, FontMetrics paramFontMetrics, char paramChar) {
        char i = paramChar;
        if (i < 'X' && i >= 'W') {
            Object localObject1 = null;
            FontRenderContext localFontRenderContext = SwingUtilities2.getFontRenderContext(paramJComponent, paramFontMetrics);
            Font localFont = paramFontMetrics.getFont();
            Class<SwingUtilities2> clazz = SwingUtilities2.class;
            synchronized (SwingUtilities2.class) {
                LSBCacheEntry localObject2 = null;
                if (searchKey == null) {
                    searchKey = new LSBCacheEntry(localFontRenderContext, localFont);
                } else {
                    searchKey.reset(localFontRenderContext, localFont);
                }
                for (LSBCacheEntry localLSBCacheEntry : fontCache) {
                    if (!searchKey.equals(localLSBCacheEntry)) continue;
                    localObject2 = localLSBCacheEntry;
                    break;
                }
                if (localObject2 == null) {
                    localObject2 = searchKey;
                    SwingUtilities2.fontCache[SwingUtilities2.nextIndex] = searchKey;
                    searchKey = null;
                    nextIndex = (nextIndex + 1) % 6;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return localObject2.getLeftSideBearing(paramChar);
            }
        }
        return 0;
    }

    public static FontMetrics getFontMetrics(JComponent paramJComponent, Graphics paramGraphics) {
        return SwingUtilities2.getFontMetrics(paramJComponent, paramGraphics, paramGraphics.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent paramJComponent, Graphics paramGraphics, Font paramFont) {
        if (paramJComponent != null) {
            return paramJComponent.getFontMetrics(paramFont);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(paramFont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stringWidth(JComponent paramJComponent, FontMetrics paramFontMetrics, String paramString) {
        boolean bool;
        if (paramString == null || paramString.equals("")) {
            return 0;
        }
        boolean bl = bool = paramJComponent != null && paramJComponent.getClientProperty(TextAttribute.NUMERIC_SHAPING) != null;
        if (bool) {
            Object object = charsBufferLock;
            synchronized (object) {
                int i = SwingUtilities2.syncCharsBuffer(paramString);
                bool = SwingUtilities2.isComplexLayout(charsBuffer, 0, i);
            }
        }
        if (bool) {
            TextLayout objTxtLayout = SwingUtilities2.createTextLayout(paramJComponent, paramString, paramFontMetrics.getFont(), paramFontMetrics.getFontRenderContext());
            return (int)objTxtLayout.getAdvance();
        }
        int result = paramFontMetrics.stringWidth(paramString);
        return result;
    }

    public static String clipStringIfNecessary(JComponent paramJComponent, FontMetrics paramFontMetrics, String paramString, int paramInt) {
        if (paramString == null || paramString.equals("")) {
            return "";
        }
        int i = SwingUtilities2.stringWidth(paramJComponent, paramFontMetrics, paramString);
        if (i > paramInt) {
            return SwingUtilities2.clipString(paramJComponent, paramFontMetrics, paramString, paramInt);
        }
        return paramString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent paramJComponent, FontMetrics paramFontMetrics, String paramString, int paramInt) {
        int k;
        boolean bool;
        String str = "...";
        String original = paramString;
        if (paramString != null && paramString.length() < 3) {
            return paramString;
        }
        if ((paramInt -= SwingUtilities2.stringWidth(paramJComponent, paramFontMetrics, str)) <= 0) {
            return str;
        }
        Object object = charsBufferLock;
        synchronized (object) {
            int i = SwingUtilities2.syncCharsBuffer(paramString);
            bool = SwingUtilities2.isComplexLayout(charsBuffer, 0, i);
            if (!bool) {
                int j = 0;
                for (k = 0; k < i; ++k) {
                    if ((j += paramFontMetrics.charWidth(charsBuffer[k])) <= paramInt) continue;
                    if (k > paramString.length() - 4) {
                        return original;
                    }
                    paramString = paramString.substring(0, k);
                    break;
                }
            }
        }
        if (bool) {
            LineBreakMeasurer localLineBreakMeasurer;
            FontRenderContext objTxtLayout = SwingUtilities2.getFontRenderContext(paramJComponent, paramFontMetrics);
            AttributedString localAttributedString = new AttributedString(paramString);
            if (paramJComponent != null) {
                localAttributedString.addAttribute(TextAttribute.NUMERIC_SHAPING, paramJComponent.getClientProperty(TextAttribute.NUMERIC_SHAPING));
            }
            if ((k = (localLineBreakMeasurer = new LineBreakMeasurer(localAttributedString.getIterator(), objTxtLayout)).nextOffset(paramInt)) > paramString.length() - 4) {
                return original;
            }
            paramString = paramString.substring(0, k);
        }
        return paramString + str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(JComponent paramJComponent, Graphics paramGraphics, String paramString, int paramInt1, int paramInt2) {
        Object localObject1;
        if (paramString == null || paramString.length() <= 0) {
            return;
        }
        if (SwingUtilities2.isPrinting(paramGraphics) && (localObject1 = SwingUtilities2.getGraphics2D(paramGraphics)) != null) {
            String localObject4 = SwingUtilities2.trimTrailingSpaces(paramString);
            if (!localObject4.isEmpty()) {
                float f = (float)((Graphics2D)localObject1).getFont().getStringBounds(localObject4, DEFAULT_FRC).getWidth();
                TextLayout localObject2 = SwingUtilities2.createTextLayout(paramJComponent, paramString, ((Graphics2D)localObject1).getFont(), ((Graphics2D)localObject1).getFontRenderContext());
                localObject2 = localObject2.getJustifiedLayout(f);
                Color localObject3 = ((Graphics2D)localObject1).getColor();
                if (localObject3 instanceof PrintColorUIResource) {
                    ((Graphics2D)localObject1).setColor(((PrintColorUIResource)localObject3).getPrintColor());
                }
                localObject2.draw((Graphics2D)localObject1, paramInt1, paramInt2);
                ((Graphics2D)localObject1).setColor(localObject3);
            }
            return;
        }
        localObject1 = SwingUtilities2.drawTextAntialiased(paramJComponent);
        if (localObject1 != null && paramGraphics instanceof Graphics2D) {
            boolean bool;
            Graphics2D localGraphics2D = (Graphics2D)paramGraphics;
            Object localObject2 = null;
            Object localObject3 = localGraphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (((AATextInfo)localObject1).aaHint != localObject3) {
                localGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, ((AATextInfo)localObject1).aaHint);
            } else {
                localObject3 = null;
            }
            if (((AATextInfo)localObject1).lcdContrastHint != null) {
                localObject2 = localGraphics2D.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (((AATextInfo)localObject1).lcdContrastHint.equals(localObject2)) {
                    localObject2 = null;
                } else {
                    localGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, ((AATextInfo)localObject1).lcdContrastHint);
                }
            }
            boolean bl = bool = paramJComponent != null && paramJComponent.getClientProperty(TextAttribute.NUMERIC_SHAPING) != null;
            if (bool) {
                Object object = charsBufferLock;
                synchronized (object) {
                    int i = SwingUtilities2.syncCharsBuffer(paramString);
                    bool = SwingUtilities2.isComplexLayout(charsBuffer, 0, i);
                }
            }
            if (bool) {
                TextLayout objTxtLayout = SwingUtilities2.createTextLayout(paramJComponent, paramString, localGraphics2D.getFont(), localGraphics2D.getFontRenderContext());
                objTxtLayout.draw(localGraphics2D, paramInt1, paramInt2);
            } else {
                paramGraphics.drawString(paramString, paramInt1, paramInt2);
            }
            if (localObject3 != null) {
                localGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, localObject3);
            }
            if (localObject2 != null) {
                localGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, localObject2);
            }
        } else {
            paramGraphics.drawString(paramString, paramInt1, paramInt2);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent paramJComponent, Graphics paramGraphics, String paramString, int paramInt1, int paramInt2, int paramInt3) {
        if (paramString == null || paramString.length() <= 0) {
            return;
        }
        if (paramGraphics instanceof Graphics2D) {
            ((Graphics2D)paramGraphics).setRenderingHint(AjaxSwingUnderlineCharAtHint.getInstance(), paramInt1);
        }
        SwingUtilities2.drawString(paramJComponent, paramGraphics, paramString, paramInt2, paramInt3);
        if (paramGraphics instanceof Graphics2D) {
            ((Graphics2D)paramGraphics).setRenderingHint(AjaxSwingUnderlineCharAtHint.getInstance(), null);
        }
    }

    public static int loc2IndexFileList(JList paramJList, Point paramPoint) {
        Object localObject;
        int i = paramJList.locationToIndex(paramPoint);
        if (i != -1 && (localObject = paramJList.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)localObject).booleanValue() && !SwingUtilities2.pointIsInActualBounds(paramJList, i, paramPoint)) {
            i = -1;
        }
        return i;
    }

    private static boolean pointIsInActualBounds(JList paramJList, int paramInt, Point paramPoint) {
        ListCellRenderer localListCellRenderer = paramJList.getCellRenderer();
        ListModel localListModel = paramJList.getModel();
        Object localObject = localListModel.getElementAt(paramInt);
        Component localComponent = localListCellRenderer.getListCellRendererComponent(paramJList, localObject, paramInt, false, false);
        Dimension localDimension = localComponent.getPreferredSize();
        Rectangle localRectangle = paramJList.getCellBounds(paramInt, paramInt);
        if (!localComponent.getComponentOrientation().isLeftToRight()) {
            localRectangle.x += localRectangle.width - localDimension.width;
        }
        localRectangle.width = localDimension.width;
        return localRectangle.contains(paramPoint);
    }

    public static boolean pointOutsidePrefSize(JTable paramJTable, int paramInt1, int paramInt2, Point paramPoint) {
        if (paramJTable.convertColumnIndexToModel(paramInt2) != 0 || paramInt1 == -1) {
            return true;
        }
        TableCellRenderer localTableCellRenderer = paramJTable.getCellRenderer(paramInt1, paramInt2);
        Object localObject = paramJTable.getValueAt(paramInt1, paramInt2);
        Component localComponent = localTableCellRenderer.getTableCellRendererComponent(paramJTable, localObject, false, false, paramInt1, paramInt2);
        Dimension localDimension = localComponent.getPreferredSize();
        Rectangle localRectangle = paramJTable.getCellRect(paramInt1, paramInt2, false);
        localRectangle.width = localDimension.width;
        localRectangle.height = localDimension.height;
        assert (paramPoint.x >= localRectangle.x && paramPoint.y >= localRectangle.y);
        return paramPoint.x > localRectangle.x + localRectangle.width || paramPoint.y > localRectangle.y + localRectangle.height;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel paramListSelectionModel, int paramInt1, int paramInt2) {
        if (paramInt2 == -1) {
            paramInt2 = paramInt1;
        }
        if (paramInt1 == -1) {
            paramListSelectionModel.setAnchorSelectionIndex(-1);
            paramListSelectionModel.setLeadSelectionIndex(-1);
        } else {
            if (paramListSelectionModel.isSelectedIndex(paramInt1)) {
                paramListSelectionModel.addSelectionInterval(paramInt1, paramInt1);
            } else {
                paramListSelectionModel.removeSelectionInterval(paramInt1, paramInt1);
            }
            paramListSelectionModel.setAnchorSelectionIndex(paramInt2);
        }
    }

    public static boolean shouldIgnore(MouseEvent paramMouseEvent, JComponent paramJComponent) {
        return paramJComponent == null || !paramJComponent.isEnabled() || !SwingUtilities.isLeftMouseButton(paramMouseEvent) || paramMouseEvent.isConsumed();
    }

    public static void adjustFocus(JComponent paramJComponent) {
        if (!paramJComponent.hasFocus() && paramJComponent.isRequestFocusEnabled()) {
            paramJComponent.requestFocus();
        }
    }

    public static int drawChars(JComponent paramJComponent, Graphics paramGraphics, char[] paramArrayOfChar, int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
        Object localObject3;
        Object localObject2;
        Object localObject1;
        if (paramInt2 <= 0) {
            return paramInt3;
        }
        int i = paramInt3 + SwingUtilities2.getFontMetrics(paramJComponent, paramGraphics).charsWidth(paramArrayOfChar, paramInt1, paramInt2);
        if (SwingUtilities2.isPrinting(paramGraphics) && (localObject1 = SwingUtilities2.getGraphics2D(paramGraphics)) != null) {
            localObject2 = ((Graphics2D)localObject1).getFontRenderContext();
            localObject3 = SwingUtilities2.getFontRenderContext(paramJComponent);
            if (localObject3 != null && !SwingUtilities2.isFontRenderContextPrintCompatible((FontRenderContext)localObject2, (FontRenderContext)localObject3)) {
                String localObject4 = new String(paramArrayOfChar, paramInt1, paramInt2);
                TextLayout localTextLayout = new TextLayout(localObject4, ((Graphics2D)localObject1).getFont(), (FontRenderContext)localObject2);
                String str = SwingUtilities2.trimTrailingSpaces(localObject4);
                if (!str.isEmpty()) {
                    float f = (float)((Graphics2D)localObject1).getFont().getStringBounds(paramArrayOfChar, paramInt1, paramInt1 + paramInt2, (FontRenderContext)localObject3).getWidth();
                    localTextLayout = localTextLayout.getJustifiedLayout(f);
                    Color localColor = ((Graphics2D)localObject1).getColor();
                    if (localColor instanceof PrintColorUIResource) {
                        ((Graphics2D)localObject1).setColor(((PrintColorUIResource)localColor).getPrintColor());
                    }
                    localTextLayout.draw((Graphics2D)localObject1, paramInt3, paramInt4);
                    ((Graphics2D)localObject1).setColor(localColor);
                }
                return i;
            }
        }
        if ((localObject1 = SwingUtilities2.drawTextAntialiased(paramJComponent)) != null && paramGraphics instanceof Graphics2D) {
            localObject2 = (Graphics2D)paramGraphics;
            localObject3 = null;
            Object localObject4 = ((Graphics2D)localObject2).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (((AATextInfo)localObject1).aaHint != null && ((AATextInfo)localObject1).aaHint != localObject4) {
                ((Graphics2D)localObject2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, ((AATextInfo)localObject1).aaHint);
            } else {
                localObject4 = null;
            }
            if (((AATextInfo)localObject1).lcdContrastHint != null) {
                localObject3 = ((Graphics2D)localObject2).getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (((AATextInfo)localObject1).lcdContrastHint.equals(localObject3)) {
                    localObject3 = null;
                } else {
                    ((Graphics2D)localObject2).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, ((AATextInfo)localObject1).lcdContrastHint);
                }
            }
            paramGraphics.drawChars(paramArrayOfChar, paramInt1, paramInt2, paramInt3, paramInt4);
            if (localObject4 != null) {
                ((Graphics2D)localObject2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, localObject4);
            }
            if (localObject3 != null) {
                ((Graphics2D)localObject2).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, localObject3);
            }
        } else {
            paramGraphics.drawChars(paramArrayOfChar, paramInt1, paramInt2, paramInt3, paramInt4);
        }
        return i;
    }

    public static float drawString(JComponent paramJComponent, Graphics paramGraphics, AttributedCharacterIterator paramAttributedCharacterIterator, int paramInt1, int paramInt2) {
        float f1;
        Graphics2D localGraphics2D;
        boolean bool = SwingUtilities2.isPrinting(paramGraphics);
        Color localColor = paramGraphics.getColor();
        if (bool && localColor instanceof PrintColorUIResource) {
            paramGraphics.setColor(((PrintColorUIResource)localColor).getPrintColor());
        }
        if ((localGraphics2D = SwingUtilities2.getGraphics2D(paramGraphics)) == null) {
            paramGraphics.drawString(paramAttributedCharacterIterator, paramInt1, paramInt2);
            f1 = paramInt1;
        } else {
            AttributedCharacterIterator localAttributedCharacterIterator;
            FontRenderContext localFontRenderContext2;
            FontRenderContext localFontRenderContext1;
            if (bool) {
                localFontRenderContext1 = SwingUtilities2.getFontRenderContext(paramJComponent);
                if (localFontRenderContext1.isAntiAliased() || localFontRenderContext1.usesFractionalMetrics()) {
                    localFontRenderContext1 = new FontRenderContext(localFontRenderContext1.getTransform(), false, false);
                }
            } else {
                localFontRenderContext1 = SwingUtilities2.getFRCProperty(paramJComponent);
                if (localFontRenderContext1 == null) {
                    localFontRenderContext1 = localGraphics2D.getFontRenderContext();
                }
            }
            TextLayout localTextLayout = new TextLayout(paramAttributedCharacterIterator, localFontRenderContext1);
            if (bool && !SwingUtilities2.isFontRenderContextPrintCompatible(localFontRenderContext1, localFontRenderContext2 = localGraphics2D.getFontRenderContext()) && (localAttributedCharacterIterator = SwingUtilities2.getTrimmedTrailingSpacesIterator(paramAttributedCharacterIterator)) != null) {
                float f2 = new TextLayout(paramAttributedCharacterIterator, localFontRenderContext2).getAdvance();
                localTextLayout = localTextLayout.getJustifiedLayout(f2);
            }
            localTextLayout.draw(localGraphics2D, paramInt1, paramInt2);
            f1 = localTextLayout.getAdvance();
        }
        if (bool) {
            paramGraphics.setColor(localColor);
        }
        return f1;
    }

    private static TextLayout createTextLayout(JComponent paramJComponent, String paramString, Font paramFont, FontRenderContext paramFontRenderContext) {
        Object localObject;
        Object object = localObject = paramJComponent == null ? null : paramJComponent.getClientProperty(TextAttribute.NUMERIC_SHAPING);
        if (localObject == null) {
            return new TextLayout(paramString, paramFont, paramFontRenderContext);
        }
        HashMap<TextAttribute, Object> localHashMap = new HashMap<TextAttribute, Object>();
        localHashMap.put(TextAttribute.FONT, paramFont);
        localHashMap.put(TextAttribute.NUMERIC_SHAPING, localObject);
        return new TextLayout(paramString, localHashMap, paramFontRenderContext);
    }

    private static boolean isFontRenderContextPrintCompatible(FontRenderContext paramFontRenderContext1, FontRenderContext paramFontRenderContext2) {
        if (paramFontRenderContext1 == paramFontRenderContext2) {
            return true;
        }
        if (paramFontRenderContext1 == null || paramFontRenderContext2 == null) {
            return false;
        }
        if (paramFontRenderContext1.getFractionalMetricsHint() != paramFontRenderContext2.getFractionalMetricsHint()) {
            return false;
        }
        if (!paramFontRenderContext1.isTransformed() && !paramFontRenderContext2.isTransformed()) {
            return true;
        }
        double[] arrayOfDouble1 = new double[4];
        double[] arrayOfDouble2 = new double[4];
        paramFontRenderContext1.getTransform().getMatrix(arrayOfDouble1);
        paramFontRenderContext2.getTransform().getMatrix(arrayOfDouble2);
        return arrayOfDouble1[0] == arrayOfDouble2[0] && arrayOfDouble1[1] == arrayOfDouble2[1] && arrayOfDouble1[2] == arrayOfDouble2[2] && arrayOfDouble1[3] == arrayOfDouble2[3];
    }

    public static Graphics2D getGraphics2D(Graphics paramGraphics) {
        if (paramGraphics instanceof Graphics2D) {
            return (Graphics2D)paramGraphics;
        }
        if (paramGraphics instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)paramGraphics).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component paramComponent) {
        assert (paramComponent != null);
        if (paramComponent == null) {
            return DEFAULT_FRC;
        }
        return paramComponent.getFontMetrics(paramComponent.getFont()).getFontRenderContext();
    }

    private static FontRenderContext getFontRenderContext(Component paramComponent, FontMetrics paramFontMetrics) {
        assert (paramFontMetrics != null || paramComponent != null);
        return paramFontMetrics != null ? paramFontMetrics.getFontRenderContext() : SwingUtilities2.getFontRenderContext(paramComponent);
    }

    public static FontMetrics getFontMetrics(JComponent paramJComponent, Font paramFont) {
        FontRenderContext localFontRenderContext = SwingUtilities2.getFRCProperty(paramJComponent);
        if (localFontRenderContext == null) {
            localFontRenderContext = DEFAULT_FRC;
        }
        return FontDesignMetrics.getMetrics(paramFont, localFontRenderContext);
    }

    private static FontRenderContext getFRCProperty(JComponent paramJComponent) {
        AATextInfo localAATextInfo;
        if (paramJComponent != null && (localAATextInfo = (AATextInfo)paramJComponent.getClientProperty(AA_TEXT_PROPERTY_KEY)) != null) {
            return localAATextInfo.frc;
        }
        return null;
    }

    static boolean isPrinting(Graphics paramGraphics) {
        return paramGraphics instanceof PrinterGraphics || paramGraphics instanceof PrintGraphics;
    }

    private static String trimTrailingSpaces(String paramString) {
        int i;
        for (i = paramString.length() - 1; i >= 0 && Character.isWhitespace(paramString.charAt(i)); --i) {
        }
        return paramString.substring(0, i + 1);
    }

    private static AttributedCharacterIterator getTrimmedTrailingSpacesIterator(AttributedCharacterIterator paramAttributedCharacterIterator) {
        int i = paramAttributedCharacterIterator.getIndex();
        char j = paramAttributedCharacterIterator.last();
        int k = 0;
        while (j != '\uffff' && Character.isWhitespace((int)j)) {
            k = paramAttributedCharacterIterator.previous();
        }
        if (k != 65535) {
            int m = paramAttributedCharacterIterator.getIndex();
            if (m == paramAttributedCharacterIterator.getEndIndex() - 1) {
                paramAttributedCharacterIterator.setIndex(i);
                return paramAttributedCharacterIterator;
            }
            AttributedString localAttributedString = new AttributedString(paramAttributedCharacterIterator, paramAttributedCharacterIterator.getBeginIndex(), m + 1);
            return localAttributedString.getIterator();
        }
        return null;
    }

    public static boolean useSelectedTextColor(Highlighter.Highlight paramHighlight, JTextComponent paramJTextComponent) {
        Highlighter.HighlightPainter localHighlightPainter = paramHighlight.getPainter();
        String str = localHighlightPainter.getClass().getName();
        if (str.indexOf("javax.swing.text.DefaultHighlighter") != 0 && str.indexOf("com.sun.java.swing.plaf.windows.WindowsTextUI") != 0) {
            return false;
        }
        try {
            DefaultHighlighter.DefaultHighlightPainter localDefaultHighlightPainter = (DefaultHighlighter.DefaultHighlightPainter)localHighlightPainter;
            if (localDefaultHighlightPainter.getColor() != null && !localDefaultHighlightPainter.getColor().equals(paramJTextComponent.getSelectionColor())) {
                return false;
            }
        }
        catch (ClassCastException localClassCastException) {
            return false;
        }
        return true;
    }

    public static boolean canAccessSystemClipboard() {
        boolean bool = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager localSecurityManager = System.getSecurityManager();
            if (localSecurityManager == null) {
                bool = true;
            } else {
                try {
                    localSecurityManager.checkSystemClipboardAccess();
                    bool = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (bool && !SwingUtilities2.isTrustedContext()) {
                    bool = SwingUtilities2.canCurrentEventAccessSystemClipboard(true);
                }
            }
        }
        return bool;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canCurrentEventAccessSystemClipboard(false);
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent paramAWTEvent) {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canEventAccessSystemClipboard(paramAWTEvent, false);
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent paramInputEvent) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Field run() {
                    try {
                        Field localField = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                        localField.setAccessible(true);
                        return localField;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean bool = false;
        try {
            bool = inputEvent_CanAccessSystemClipboard_Field.getBoolean(paramInputEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return bool;
    }

    private static boolean isAccessClipboardGesture(InputEvent paramInputEvent) {
        boolean i = false;
        if (paramInputEvent instanceof KeyEvent) {
            KeyEvent localKeyEvent = (KeyEvent)paramInputEvent;
            int j = localKeyEvent.getKeyCode();
            int k = localKeyEvent.getModifiers();
            switch (j) {
                case 67: 
                case 86: 
                case 88: {
                    i = k == 2;
                    break;
                }
                case 155: {
                    i = k == 2 || k == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    i = true;
                    break;
                }
                case 127: {
                    i = k == 1;
                }
            }
        }
        return i;
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent paramAWTEvent, boolean paramBoolean) {
        if (EventQueue.isDispatchThread()) {
            if (paramAWTEvent instanceof InputEvent && (!paramBoolean || SwingUtilities2.isAccessClipboardGesture((InputEvent)paramAWTEvent))) {
                return SwingUtilities2.inputEvent_canAccessSystemClipboard((InputEvent)paramAWTEvent);
            }
            return false;
        }
        return true;
    }

    public static void checkAccess(int paramInt) {
        if (System.getSecurityManager() != null && !Modifier.isPublic(paramInt)) {
            throw new SecurityException("Resource is not accessible");
        }
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean paramBoolean) {
        AWTEvent localAWTEvent = EventQueue.getCurrentEvent();
        return SwingUtilities2.canEventAccessSystemClipboard(localAWTEvent, paramBoolean);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    public static String displayPropertiesToCSS(Font paramFont, Color paramColor) {
        StringBuffer localStringBuffer = new StringBuffer("body {");
        if (paramFont != null) {
            localStringBuffer.append(" font-family: ");
            localStringBuffer.append(paramFont.getFamily());
            localStringBuffer.append(" ; ");
            localStringBuffer.append(" font-size: ");
            localStringBuffer.append(paramFont.getSize());
            localStringBuffer.append("pt ;");
            if (paramFont.isBold()) {
                localStringBuffer.append(" font-weight: 700 ; ");
            }
            if (paramFont.isItalic()) {
                localStringBuffer.append(" font-style: italic ; ");
            }
        }
        if (paramColor != null) {
            localStringBuffer.append(" color: #");
            if (paramColor.getRed() < 16) {
                localStringBuffer.append('0');
            }
            localStringBuffer.append(Integer.toHexString(paramColor.getRed()));
            if (paramColor.getGreen() < 16) {
                localStringBuffer.append('0');
            }
            localStringBuffer.append(Integer.toHexString(paramColor.getGreen()));
            if (paramColor.getBlue() < 16) {
                localStringBuffer.append('0');
            }
            localStringBuffer.append(Integer.toHexString(paramColor.getBlue()));
            localStringBuffer.append(" ; ");
        }
        localStringBuffer.append(" }");
        return localStringBuffer.toString();
    }

    public static Object makeIcon(Class<?> paramClass1, Class<?> paramClass2, String paramString) {
        final Class<?> baseClass = paramClass1;
        final Class<?> rootClass = paramClass2;
        final String imageFile = paramString;
        return new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults paramUIDefaults) {
                byte[] arrayOfByte = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public byte[] run() {
                        try {
                            int i;
                            InputStream localInputStream = null;
                            for (Class localClass = baseClass; localClass != null && (localInputStream = localClass.getResourceAsStream(imageFile)) == null && localClass != rootClass; localClass = localClass.getSuperclass()) {
                            }
                            if (localInputStream == null) {
                                return null;
                            }
                            BufferedInputStream localBufferedInputStream = new BufferedInputStream(localInputStream);
                            ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(1024);
                            byte[] arrayOfByte = new byte[1024];
                            while ((i = localBufferedInputStream.read(arrayOfByte)) > 0) {
                                localByteArrayOutputStream.write(arrayOfByte, 0, i);
                            }
                            localBufferedInputStream.close();
                            localByteArrayOutputStream.flush();
                            return localByteArrayOutputStream.toByteArray();
                        }
                        catch (IOException localIOException) {
                            System.err.println(localIOException.toString());
                            return null;
                        }
                    }
                });
                if (arrayOfByte == null) {
                    return null;
                }
                if (arrayOfByte.length == 0) {
                    System.err.println("warning: " + imageFile + " is zero-length");
                    return null;
                }
                return new ImageIconUIResource(arrayOfByte);
            }
        };
    }

    public static boolean isLocalDisplay() {
        GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean bool = localGraphicsEnvironment instanceof SunGraphicsEnvironment ? ((SunGraphicsEnvironment)localGraphicsEnvironment).isDisplayLocal() : true;
        return bool;
    }

    public static int getUIDefaultsInt(Object paramObject) {
        return SwingUtilities2.getUIDefaultsInt(paramObject, 0);
    }

    public static int getUIDefaultsInt(Object paramObject, Locale paramLocale) {
        return SwingUtilities2.getUIDefaultsInt(paramObject, paramLocale, 0);
    }

    public static int getUIDefaultsInt(Object paramObject, int paramInt) {
        return SwingUtilities2.getUIDefaultsInt(paramObject, null, paramInt);
    }

    public static int getUIDefaultsInt(Object paramObject, Locale paramLocale, int paramInt) {
        Object localObject = UIManager.get(paramObject, paramLocale);
        if (localObject instanceof Integer) {
            return (Integer)localObject;
        }
        if (localObject instanceof String) {
            try {
                return Integer.parseInt((String)localObject);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return paramInt;
    }

    public static Component compositeRequestFocus(Component paramComponent) {
        if (paramComponent instanceof Container) {
            Component localComponent;
            Object localObject1;
            Object localObject2;
            Container localContainer = (Container)paramComponent;
            if (localContainer.isFocusCycleRoot() && (localObject2 = ((FocusTraversalPolicy)(localObject1 = localContainer.getFocusTraversalPolicy())).getDefaultComponent(localContainer)) != null) {
                ((Component)localObject2).requestFocus();
                return (Component)localObject2;
            }
            localObject1 = localContainer.getFocusCycleRootAncestor();
            if (localObject1 != null && (localComponent = ((FocusTraversalPolicy)(localObject2 = ((Container)localObject1).getFocusTraversalPolicy())).getComponentAfter((Container)localObject1, localContainer)) != null && SwingUtilities.isDescendingFrom(localComponent, localContainer)) {
                localComponent.requestFocus();
                return localComponent;
            }
        }
        if (paramComponent.isFocusable()) {
            paramComponent.requestFocus();
            return paramComponent;
        }
        return null;
    }

    public static boolean tabbedPaneChangeFocusTo(Component paramComponent) {
        if (paramComponent != null) {
            if (paramComponent.isFocusTraversable()) {
                SwingUtilities2.compositeRequestFocus(paramComponent);
                return true;
            }
            if (paramComponent instanceof JComponent && ((JComponent)paramComponent).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static <V> Future<V> submit(Callable<V> paramCallable) {
        if (paramCallable == null) {
            throw new NullPointerException();
        }
        FutureTask<V> localFutureTask = new FutureTask<V>(paramCallable);
        SwingUtilities2.execute(localFutureTask);
        return localFutureTask;
    }

    public static <V> Future<V> submit(Runnable paramRunnable, V paramV) {
        if (paramRunnable == null) {
            throw new NullPointerException();
        }
        FutureTask<V> localFutureTask = new FutureTask<V>(paramRunnable, paramV);
        SwingUtilities2.execute(localFutureTask);
        return localFutureTask;
    }

    private static void execute(Runnable paramRunnable) {
        SwingUtilities.invokeLater(paramRunnable);
    }

    public static void setSkipClickCount(Component paramComponent, int paramInt) {
        if (paramComponent instanceof JTextComponent && ((JTextComponent)paramComponent).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)paramComponent).putClientProperty(SKIP_CLICK_COUNT, paramInt);
        }
    }

    public static int getAdjustedClickCount(JTextComponent paramJTextComponent, MouseEvent paramMouseEvent) {
        int i = paramMouseEvent.getClickCount();
        if (i == 1) {
            paramJTextComponent.putClientProperty(SKIP_CLICK_COUNT, null);
        } else {
            Integer localInteger = (Integer)paramJTextComponent.getClientProperty(SKIP_CLICK_COUNT);
            if (localInteger != null) {
                return i - localInteger;
            }
        }
        return i;
    }

    private static Section liesIn(Rectangle paramRectangle, Point paramPoint, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3) {
        boolean bool;
        int k;
        int j;
        int i;
        if (paramBoolean1) {
            i = paramRectangle.x;
            j = paramPoint.x;
            k = paramRectangle.width;
            bool = paramBoolean2;
        } else {
            i = paramRectangle.y;
            j = paramPoint.y;
            k = paramRectangle.height;
            bool = true;
        }
        if (paramBoolean3) {
            int m;
            int n = m = k >= 30 ? 10 : k / 3;
            if (j < i + m) {
                return bool ? Section.LEADING : Section.TRAILING;
            }
            if (j >= i + k - m) {
                return bool ? Section.TRAILING : Section.LEADING;
            }
            return Section.MIDDLE;
        }
        int m = i + k / 2;
        if (bool) {
            return j >= m ? Section.TRAILING : Section.LEADING;
        }
        return j < m ? Section.TRAILING : Section.LEADING;
    }

    public static Section liesInHorizontal(Rectangle paramRectangle, Point paramPoint, boolean paramBoolean1, boolean paramBoolean2) {
        return SwingUtilities2.liesIn(paramRectangle, paramPoint, true, paramBoolean1, paramBoolean2);
    }

    public static Section liesInVertical(Rectangle paramRectangle, Point paramPoint, boolean paramBoolean) {
        return SwingUtilities2.liesIn(paramRectangle, paramPoint, false, false, paramBoolean);
    }

    public static int convertColumnIndexToModel(TableColumnModel paramTableColumnModel, int paramInt) {
        if (paramInt < 0) {
            return paramInt;
        }
        return paramTableColumnModel.getColumn(paramInt).getModelIndex();
    }

    public static int convertColumnIndexToView(TableColumnModel paramTableColumnModel, int paramInt) {
        if (paramInt < 0) {
            return paramInt;
        }
        for (int i = 0; i < paramTableColumnModel.getColumnCount(); ++i) {
            if (paramTableColumnModel.getColumn(i).getModelIndex() != paramInt) continue;
            return i;
        }
        return -1;
    }

    public static int getSystemMnemonicKeyMask() {
        return 8;
    }

    static {
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextInfoPropertyKey");
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
        COMPONENT_UI_PROPERTY_KEY = new StringBuffer("ComponentUIPropertyKey");
        BASICMENUITEMUI_MAX_TEXT_OFFSET = new StringUIClientPropertyKey("maxTextOffset");
        inputEvent_CanAccessSystemClipboard_Field = null;
        charsBufferLock = new Object();
        charsBuffer = new char[100];
        fontCache = new LSBCacheEntry[6];
    }

    public static enum Section {
        LEADING,
        MIDDLE,
        TRAILING;

    }

    private static class LSBCacheEntry {
        private static final byte UNSET = 127;
        private static final char[] oneChar = new char[1];
        private byte[] lsbCache = new byte[1];
        private Font font;
        private FontRenderContext frc;

        public LSBCacheEntry(FontRenderContext paramFontRenderContext, Font paramFont) {
            this.reset(paramFontRenderContext, paramFont);
        }

        public void reset(FontRenderContext paramFontRenderContext, Font paramFont) {
            this.font = paramFont;
            this.frc = paramFontRenderContext;
            for (int i = this.lsbCache.length - 1; i >= 0; --i) {
                this.lsbCache[i] = 127;
            }
        }

        public int getLeftSideBearing(char paramChar) {
            int i = paramChar - 87;
            assert (i >= 0 && i < 1);
            byte j = this.lsbCache[i];
            if (j == 127) {
                Object localObject;
                LSBCacheEntry.oneChar[0] = paramChar;
                GlyphVector localGlyphVector = this.font.createGlyphVector(this.frc, oneChar);
                j = (byte)localGlyphVector.getGlyphPixelBounds((int)0, (FontRenderContext)this.frc, (float)0.0f, (float)0.0f).x;
                if (j < 0 && ((localObject = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || localObject == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                    j = (byte)(j + 1);
                }
                this.lsbCache[i] = j;
            }
            return j;
        }

        public boolean equals(Object paramObject) {
            if (paramObject == this) {
                return true;
            }
            if (!(paramObject instanceof LSBCacheEntry)) {
                return false;
            }
            LSBCacheEntry localLSBCacheEntry = (LSBCacheEntry)paramObject;
            return this.font.equals(localLSBCacheEntry.font) && this.frc.equals(localLSBCacheEntry.frc);
        }

        public int hashCode() {
            int i = 17;
            if (this.font != null) {
                i = 37 * i + this.font.hashCode();
            }
            if (this.frc != null) {
                i = 37 * i + this.frc.hashCode();
            }
            return i;
        }
    }

    public static class AATextInfo {
        Object aaHint;
        Integer lcdContrastHint;
        FontRenderContext frc;

        private static AATextInfo getAATextInfoFromMap(Map paramMap) {
            Object localObject1 = paramMap.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object localObject2 = paramMap.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (localObject1 == null || localObject1 == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || localObject1 == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                return null;
            }
            return new AATextInfo(localObject1, (Integer)localObject2);
        }

        public static AATextInfo getAATextInfo(boolean paramBoolean) {
            SunToolkit.setAAFontSettingsCondition(paramBoolean);
            Toolkit localToolkit = Toolkit.getDefaultToolkit();
            Object localObject = localToolkit.getDesktopProperty("awt.font.desktophints");
            if (localObject instanceof Map) {
                return AATextInfo.getAATextInfoFromMap((Map)localObject);
            }
            return null;
        }

        public AATextInfo(Object paramObject, Integer paramInteger) {
            if (paramObject == null) {
                throw new InternalError("null not allowed here");
            }
            if (paramObject == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || paramObject == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                throw new InternalError("AA must be on");
            }
            this.aaHint = paramObject;
            this.lcdContrastHint = paramInteger;
            this.frc = new FontRenderContext(null, paramObject, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }
}

